/*
 * Decompiled with CFR 0.152.
 */
package net.wiseoldman.panel;

import com.google.common.base.Strings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.WorldType;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.ui.components.materialtabs.MaterialTab;
import net.runelite.client.ui.components.materialtabs.MaterialTabGroup;
import net.runelite.client.util.LinkBrowser;
import net.wiseoldman.WomUtilsConfig;
import net.wiseoldman.beans.PlayerInfo;
import net.wiseoldman.panel.ActivitiesPanel;
import net.wiseoldman.panel.BossingPanel;
import net.wiseoldman.panel.MiscInfo;
import net.wiseoldman.panel.MiscInfoLabel;
import net.wiseoldman.panel.NameAutocompleter;
import net.wiseoldman.panel.SkillingPanel;
import net.wiseoldman.web.WomClient;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WomPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(WomPanel.class);
    @Inject
    private Client client;
    private static final int MAX_USERNAME_LENGTH = 12;
    private final SkillingPanel skillingPanel;
    private final BossingPanel bossingPanel;
    private final ActivitiesPanel activitiesPanel;
    private final NameAutocompleter nameAutocompleter;
    private final WomClient womClient;
    private final WomUtilsConfig config;
    private final IconTextField searchBar;
    private final List<MiscInfoLabel> miscInfoLabels = new ArrayList<MiscInfoLabel>();
    private final List<JButton> buttons = new ArrayList<JButton>();

    @Inject
    public WomPanel(final Client client, NameAutocompleter nameAutocompleter, WomClient womClient, WomUtilsConfig config, SkillingPanel skillingPanel, BossingPanel bossingPanel, ActivitiesPanel activitiesPanel) {
        this.nameAutocompleter = nameAutocompleter;
        this.womClient = womClient;
        this.config = config;
        this.skillingPanel = skillingPanel;
        this.bossingPanel = bossingPanel;
        this.activitiesPanel = activitiesPanel;
        this.setBorder(new EmptyBorder(18, 10, 0, 10));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 10, 0);
        this.searchBar = new IconTextField();
        this.searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.searchBar.setPreferredSize(new Dimension(205, 30));
        this.searchBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.searchBar.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.searchBar.setMinimumSize(new Dimension(0, 30));
        this.searchBar.addActionListener(e -> this.lookup());
        this.searchBar.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (client == null) {
                    return;
                }
                Player localPlayer = client.getLocalPlayer();
                if (localPlayer != null) {
                    WomPanel.this.lookup(localPlayer.getName());
                }
            }
        });
        this.searchBar.addClearListener(() -> {
            this.searchBar.setIcon(IconTextField.Icon.SEARCH);
            this.searchBar.setEditable(true);
            this.toggleButtons(false);
        });
        this.add((Component)this.searchBar, c);
        ++c.gridy;
        this.add(this.createButtonsPanel(), c);
        ++c.gridy;
        JLabel overviewTitle = new JLabel("Overview");
        overviewTitle.setFont(FontManager.getRunescapeBoldFont());
        this.add(overviewTitle, c);
        ++c.gridy;
        this.add(this.createOverViewPanel(), c);
        ++c.gridy;
        MiscInfoLabel lastUpdated = new MiscInfoLabel(MiscInfo.LAST_UPDATED);
        this.miscInfoLabels.add(lastUpdated);
        this.add(lastUpdated, c);
        ++c.gridy;
        JPanel display = new JPanel();
        MaterialTabGroup tabGroup = new MaterialTabGroup(display);
        MaterialTab skillingTab = new MaterialTab("Skills", tabGroup, (JComponent)skillingPanel);
        MaterialTab bossingTab = new MaterialTab("Bosses", tabGroup, (JComponent)bossingPanel);
        MaterialTab activitiesTab = new MaterialTab("Activities", tabGroup, (JComponent)activitiesPanel);
        tabGroup.setBorder((Border)new EmptyBorder(10, 0, 0, 0));
        tabGroup.addTab(skillingTab);
        tabGroup.addTab(bossingTab);
        tabGroup.addTab(activitiesTab);
        tabGroup.select(skillingTab);
        this.add((Component)tabGroup, c);
        ++c.gridy;
        this.add(display, c);
        ++c.gridy;
        this.addInputKeyListener(nameAutocompleter);
    }

    public void shutdown() {
        this.removeInputKeyListener(this.nameAutocompleter);
    }

    public void onActivate() {
        super.onActivate();
        this.searchBar.requestFocusInWindow();
    }

    private void toggleButtons(boolean enabled) {
        for (JButton button : this.buttons) {
            button.setEnabled(enabled);
        }
    }

    public void lookup(String username) {
        this.searchBar.setText(username);
        this.lookup();
    }

    private void lookup() {
        String lookup = WomPanel.sanitize(this.searchBar.getText());
        this.toggleButtons(false);
        if (Strings.isNullOrEmpty((String)lookup)) {
            return;
        }
        if (lookup.length() > 12) {
            this.searchBar.setIcon(IconTextField.Icon.ERROR);
            return;
        }
        this.searchBar.setEditable(false);
        this.searchBar.setIcon(IconTextField.Icon.LOADING_DARKER);
        this.resetOverview();
        this.skillingPanel.reset();
        this.bossingPanel.reset();
        this.activitiesPanel.reset();
        this.womClient.lookupAsync(lookup).whenCompleteAsync((result, ex) -> this.updateAfterSearch(lookup, (PlayerInfo)result, (Throwable)ex));
    }

    private void updateAfterSearch(String lookup, PlayerInfo result, Throwable ex) {
        SwingUtilities.invokeLater(() -> {
            if (!WomPanel.sanitize(this.searchBar.getText()).equals(lookup)) {
                return;
            }
            this.toggleButtons(true);
            if (result == null || ex != null) {
                if (ex != null) {
                    log.warn("Error fetching Wise Old Man data " + ex.getMessage());
                }
                this.searchBar.setIcon(IconTextField.Icon.ERROR);
                this.searchBar.setEditable(true);
                return;
            }
            if (result.getLatestSnapshot() == null) {
                log.warn("Player on WOM without snapshot {}.", (Object)lookup);
                this.searchBar.setIcon(IconTextField.Icon.ERROR);
                this.searchBar.setEditable(true);
                return;
            }
            this.searchBar.setIcon(IconTextField.Icon.SEARCH);
            this.searchBar.setEditable(true);
            this.applyResult(result);
        });
    }

    private void applyOverviewResult(PlayerInfo result) {
        for (MiscInfoLabel infoLabel : this.miscInfoLabels) {
            infoLabel.format(result, this.config.relativeTime());
        }
    }

    private void resetOverview() {
        for (MiscInfoLabel infoLabel : this.miscInfoLabels) {
            infoLabel.reset();
        }
    }

    private void applyResult(PlayerInfo result) {
        assert (SwingUtilities.isEventDispatchThread());
        this.nameAutocompleter.addToSearchHistory(result.getUsername());
        this.applyOverviewResult(result);
        this.skillingPanel.update(result);
        this.bossingPanel.update(result);
        this.activitiesPanel.update(result);
    }

    void addInputKeyListener(KeyListener l) {
        this.searchBar.addKeyListener(l);
    }

    void removeInputKeyListener(KeyListener l) {
        this.searchBar.removeKeyListener(l);
    }

    private static String sanitize(String lookup) {
        return lookup.replace('\u00a0', ' ');
    }

    private void openPlayerProfile(String username) {
        String url = new HttpUrl.Builder().scheme("https").host(this.client.getWorldType().contains(WorldType.SEASONAL) ? "league.wiseoldman.net" : "wiseoldman.net").addPathSegment("players").addPathSegment(username).build().toString();
        SwingUtilities.invokeLater(() -> LinkBrowser.browse((String)url));
    }

    private JPanel createButtonsPanel() {
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new GridBagLayout());
        buttonsPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.ipady = 10;
        JButton updateButton = new JButton();
        updateButton.setFont(FontManager.getRunescapeSmallFont());
        updateButton.setEnabled(false);
        updateButton.addActionListener(e -> this.womClient.updateAsync(WomPanel.sanitize(this.searchBar.getText())).whenCompleteAsync((result, ex) -> this.updateAfterSearch(WomPanel.sanitize(this.searchBar.getText()), (PlayerInfo)result, (Throwable)ex)));
        updateButton.setText("Update");
        JButton profileButton = new JButton();
        profileButton.setFont(FontManager.getRunescapeSmallFont());
        profileButton.setEnabled(false);
        profileButton.addActionListener(e -> this.openPlayerProfile(WomPanel.sanitize(this.searchBar.getText())));
        profileButton.setText("Open Profile");
        this.buttons.add(updateButton);
        this.buttons.add(profileButton);
        buttonsPanel.add((Component)updateButton, gbc);
        ++gbc.gridx;
        gbc.insets.left = 7;
        buttonsPanel.add((Component)profileButton, gbc);
        return buttonsPanel;
    }

    private JPanel createOverViewPanel() {
        JPanel miscInfoPanel = new JPanel();
        miscInfoPanel.setLayout(new GridLayout(3, 2, 5, 5));
        for (MiscInfo info : MiscInfo.values()) {
            if (info == MiscInfo.LAST_UPDATED) continue;
            MiscInfoLabel miscInfoLabel = new MiscInfoLabel(info);
            this.miscInfoLabels.add(miscInfoLabel);
            miscInfoPanel.add(miscInfoLabel);
        }
        return miscInfoPanel;
    }
}

