/*
 * Decompiled with CFR 0.152.
 */
package net.wiseoldman.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.hiscore.HiscoreSkill;
import net.runelite.client.hiscore.HiscoreSkillType;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.QuantityFormatter;
import net.wiseoldman.WomUtilsPlugin;
import net.wiseoldman.beans.Activity;
import net.wiseoldman.beans.Boss;
import net.wiseoldman.beans.Skill;
import net.wiseoldman.util.Format;
import net.wiseoldman.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRow
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(TableRow.class);
    private static final int ICON_WIDTH = 35;
    Map<String, JLabel> labels = new HashMap<String, JLabel>();

    TableRow(String name, String formattedName, HiscoreSkillType type, String ... labels) {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(2, 0, 2, 0));
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel dataPanel = new JPanel(new GridLayout());
        dataPanel.setOpaque(false);
        String directory = type == HiscoreSkillType.BOSS ? "bosses/" : (type == HiscoreSkillType.ACTIVITY ? "activities/" : "/skill_icons_small/");
        for (String l : labels) {
            dataPanel.add(this.createCell(l));
        }
        String iconDirectory = directory + name.toLowerCase() + ".png";
        log.debug("Loading icon for {}", (Object)iconDirectory);
        JPanel iconPanel = new JPanel(new BorderLayout());
        iconPanel.setOpaque(false);
        JLabel iconLabel = new JLabel("", 0);
        iconPanel.add(iconLabel);
        ImageIcon icon = new ImageIcon(ImageUtil.loadImageResource(WomUtilsPlugin.class, (String)iconDirectory));
        iconPanel.setPreferredSize(new Dimension(35, icon.getIconHeight()));
        iconLabel.setIcon(icon);
        iconLabel.setToolTipText(formattedName);
        this.add((Component)iconPanel, "West");
        this.add(dataPanel);
    }

    private JLabel createCell(String l) {
        JLabel label = new JLabel("--", 0);
        label.setFont(FontManager.getRunescapeSmallFont());
        this.labels.put(l, label);
        return label;
    }

    void update(Skill skill, boolean virtualLevels) {
        long experience = skill.getExperience();
        int level = skill.getLevel();
        int rank = skill.getRank();
        boolean ranked = rank != -1;
        double ehp = skill.getEhp();
        JLabel experienceLabel = this.labels.get("experience");
        experienceLabel.setText(experience > 0L ? Format.formatNumber(experience) : "--");
        experienceLabel.setToolTipText(experience > 0L ? QuantityFormatter.formatNumber((long)experience) : "");
        JLabel levelLabel = this.labels.get("level");
        int levelToDisplay = !virtualLevels && level > 99 ? 99 : level;
        levelLabel.setText(String.valueOf(levelToDisplay));
        levelLabel.setToolTipText(String.valueOf(levelToDisplay));
        JLabel rankLabel = this.labels.get("rank");
        rankLabel.setText(ranked ? Format.formatNumber(rank) : "--");
        rankLabel.setToolTipText(ranked ? QuantityFormatter.formatNumber((long)rank) : "Unranked");
        JLabel ehpLabel = this.labels.get("ehp");
        ehpLabel.setText(Format.formatNumber(ehp));
        ehpLabel.setToolTipText(QuantityFormatter.formatNumber((double)ehp));
    }

    void update(Boss boss, HiscoreSkill b) {
        int minimumKc;
        int kills = boss.getKills();
        boolean ranked = kills >= (minimumKc = Utils.getMinimumKc(b));
        int rank = boss.getRank();
        double ehb = boss.getEhb();
        JLabel killsLabel = this.labels.get("kills");
        killsLabel.setText((String)(ranked ? Format.formatNumber(kills) : "< " + minimumKc));
        killsLabel.setToolTipText((String)(ranked ? QuantityFormatter.formatNumber((long)kills) : "The Hiscores only start tracking " + b.getName() + " after " + minimumKc + " kc"));
        JLabel rankLabel = this.labels.get("rank");
        rankLabel.setText(ranked ? Format.formatNumber(rank) : "--");
        rankLabel.setToolTipText(ranked ? QuantityFormatter.formatNumber((long)rank) : "Unranked");
        JLabel ehbLabel = this.labels.get("ehb");
        ehbLabel.setText(Format.formatNumber(ehb));
        ehbLabel.setToolTipText(QuantityFormatter.formatNumber((double)ehb));
    }

    void update(Activity minigame) {
        int score = minigame.getScore();
        int rank = minigame.getRank();
        boolean ranked = rank != -1;
        JLabel killsLabel = this.labels.get("score");
        killsLabel.setText(ranked ? Format.formatNumber(score) : "--");
        killsLabel.setToolTipText(ranked ? QuantityFormatter.formatNumber((long)score) : "");
        JLabel rankLabel = this.labels.get("rank");
        rankLabel.setText(ranked ? Format.formatNumber(rank) : "--");
        rankLabel.setToolTipText(ranked ? QuantityFormatter.formatNumber((long)rank) : "Unranked");
    }
}

