/*
 * Decompiled with CFR 0.152.
 */
package net.wiseoldman.panel;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.api.Experience;
import net.runelite.client.hiscore.HiscoreSkill;
import net.runelite.client.hiscore.HiscoreSkillType;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.QuantityFormatter;
import net.wiseoldman.WomUtilsConfig;
import net.wiseoldman.beans.PlayerInfo;
import net.wiseoldman.beans.Skill;
import net.wiseoldman.beans.Snapshot;
import net.wiseoldman.panel.RowPair;
import net.wiseoldman.panel.StatsTableHeader;
import net.wiseoldman.panel.TableRow;
import net.wiseoldman.util.Format;

class SkillingPanel
extends JPanel {
    private static final List<HiscoreSkill> SKILLS = ImmutableList.of((Object)HiscoreSkill.ATTACK, (Object)HiscoreSkill.DEFENCE, (Object)HiscoreSkill.STRENGTH, (Object)HiscoreSkill.HITPOINTS, (Object)HiscoreSkill.RANGED, (Object)HiscoreSkill.PRAYER, (Object)HiscoreSkill.MAGIC, (Object)HiscoreSkill.COOKING, (Object)HiscoreSkill.WOODCUTTING, (Object)HiscoreSkill.FLETCHING, (Object)HiscoreSkill.FISHING, (Object)HiscoreSkill.FIREMAKING, (Object[])new HiscoreSkill[]{HiscoreSkill.CRAFTING, HiscoreSkill.SMITHING, HiscoreSkill.MINING, HiscoreSkill.HERBLORE, HiscoreSkill.AGILITY, HiscoreSkill.THIEVING, HiscoreSkill.SLAYER, HiscoreSkill.FARMING, HiscoreSkill.RUNECRAFT, HiscoreSkill.HUNTER, HiscoreSkill.CONSTRUCTION});
    static Color[] ROW_COLORS = new Color[]{ColorScheme.DARKER_GRAY_COLOR, new Color(34, 34, 34)};
    TableRow overallRow;
    List<RowPair> tableRows = new ArrayList<RowPair>();
    WomUtilsConfig config;

    @Inject
    private SkillingPanel(WomUtilsConfig config) {
        this.config = config;
        this.setLayout(new GridLayout(0, 1));
        StatsTableHeader tableHeader = new StatsTableHeader("skilling");
        this.overallRow = new TableRow(HiscoreSkill.OVERALL.name(), HiscoreSkill.OVERALL.getName(), HiscoreSkillType.SKILL, "experience", "level", "rank", "ehp");
        this.overallRow.setBackground(ROW_COLORS[1]);
        this.add(tableHeader);
        this.add(this.overallRow);
        for (int i = 0; i < SKILLS.size(); ++i) {
            HiscoreSkill skill = SKILLS.get(i);
            TableRow row = new TableRow(skill.name(), skill.getName(), HiscoreSkillType.SKILL, "experience", "level", "rank", "ehp");
            row.setBackground(ROW_COLORS[i % 2]);
            this.tableRows.add(new RowPair(skill, row));
            this.add(row);
        }
    }

    public void update(PlayerInfo info) {
        if (info == null) {
            return;
        }
        Snapshot latestSnapshot = info.getLatestSnapshot();
        for (RowPair rp : this.tableRows) {
            HiscoreSkill skill = rp.getSkill();
            TableRow row = rp.getRow();
            row.update(latestSnapshot.getData().getSkills().getSkill(skill), this.config.virtualLevels());
        }
        this.updateTotalLevel(latestSnapshot);
    }

    private void updateTotalLevel(Snapshot snapshot) {
        int totalLevel = 0;
        Skill overall = snapshot.getData().getSkills().getSkill(HiscoreSkill.OVERALL);
        long overallExperience = overall.getExperience();
        int overallRank = overall.getRank();
        for (HiscoreSkill skill : SKILLS) {
            int experience = (int)snapshot.getData().getSkills().getSkill(skill).getExperience();
            int level = experience >= 0 ? Experience.getLevelForXp((int)experience) : 0;
            totalLevel += !this.config.virtualLevels() && level > 99 ? 99 : level;
        }
        JLabel expLabel = this.overallRow.labels.get("experience");
        JLabel levelLabel = this.overallRow.labels.get("level");
        JLabel rankLabel = this.overallRow.labels.get("rank");
        JLabel ehpLabel = this.overallRow.labels.get("ehp");
        expLabel.setText(overallExperience >= 0L ? Format.formatNumber(overallExperience) : "--");
        expLabel.setToolTipText(overallExperience >= 0L ? QuantityFormatter.formatNumber((long)overallExperience) : "");
        levelLabel.setText(totalLevel > 0 ? String.valueOf(totalLevel) : "--");
        levelLabel.setToolTipText(totalLevel > 0 ? QuantityFormatter.formatNumber((long)totalLevel) : "");
        rankLabel.setText(overallRank > 0 ? Format.formatNumber(overallRank) : "--");
        rankLabel.setToolTipText(overallRank > 0 ? QuantityFormatter.formatNumber((long)overallRank) : "Unranked");
        ehpLabel.setText(Format.formatNumber(overall.getEhp()));
        ehpLabel.setToolTipText(QuantityFormatter.formatNumber((double)overall.getEhp()));
    }

    public void reset() {
        for (Map.Entry<String, JLabel> entry : this.overallRow.labels.entrySet()) {
            JLabel label = entry.getValue();
            label.setText("--");
            label.setToolTipText("");
        }
        for (RowPair rp : this.tableRows) {
            TableRow row = rp.getRow();
            for (Map.Entry<String, JLabel> e : row.labels.entrySet()) {
                JLabel label = e.getValue();
                label.setText("--");
                label.setToolTipText("");
            }
        }
    }
}

