/*
 * Decompiled with CFR 0.152.
 */
package net.wiseoldman.panel;

import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.wiseoldman.beans.PlayerBuild;
import net.wiseoldman.beans.PlayerInfo;
import net.wiseoldman.panel.MiscInfo;
import net.wiseoldman.ui.CountryIcon;
import net.wiseoldman.util.Format;
import net.wiseoldman.util.Utils;

public class MiscInfoLabel
extends JLabel {
    MiscInfo info;

    public MiscInfoLabel(MiscInfo info) {
        this.info = info;
        this.setFont(FontManager.getRunescapeSmallFont());
        this.setBorder(new EmptyBorder(5, 10, 5, 5));
        this.setText(info.getDefaultText());
        this.setToolTipText(info.getHoverText());
        if (info != MiscInfo.LAST_UPDATED) {
            this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            this.setOpaque(true);
            this.setIcon(info.getIcon());
        } else {
            this.setHorizontalAlignment(0);
        }
    }

    public void format(PlayerInfo result, boolean relative) {
        switch (this.info) {
            case COUNTRY: {
                String country = result.getCountry();
                String countryText = country == null ? "--" : country;
                String countryCode = country == null ? "default" : country.toLowerCase();
                this.setIcon(CountryIcon.loadSquareImage(countryCode));
                this.setText(countryText);
                break;
            }
            case BUILD: {
                PlayerBuild build = result.getBuild();
                String buildText = build == null ? PlayerBuild.MAIN.toString() : build.toString();
                this.setText(buildText);
                this.setIcon(Utils.getIcon(result.getType()));
                break;
            }
            case TTM: {
                this.setText(Format.formatNumber(result.getTtm()) + "h");
                break;
            }
            case EHP: {
                this.setText(Format.formatNumber(result.getEhp()));
                break;
            }
            case EHB: {
                this.setText(Format.formatNumber(result.getEhb()));
                break;
            }
            case EXP: {
                long experience = result.getExp();
                this.setText(experience > 0L ? Format.formatNumber(experience) : "--");
                break;
            }
            case LAST_UPDATED: {
                this.setText(this.info.getHoverText() + " " + Format.formatDate(result.getUpdatedAt(), relative));
            }
        }
    }

    public void reset() {
        if (this.info == MiscInfo.COUNTRY || this.info == MiscInfo.BUILD) {
            this.setIcon(this.info.getIcon());
        }
        this.setText(this.info.getDefaultText());
    }
}

