/*
 * Decompiled with CFR 0.152.
 */
package net.wiseoldman.panel;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.hiscore.HiscoreSkill;
import net.runelite.client.hiscore.HiscoreSkillType;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.QuantityFormatter;
import net.wiseoldman.beans.Computed;
import net.wiseoldman.beans.PlayerInfo;
import net.wiseoldman.beans.Snapshot;
import net.wiseoldman.panel.RowPair;
import net.wiseoldman.panel.StatsTableHeader;
import net.wiseoldman.panel.TableRow;
import net.wiseoldman.util.Format;

class BossingPanel
extends JPanel {
    private static final List<HiscoreSkill> BOSSES = ImmutableList.of((Object)HiscoreSkill.ABYSSAL_SIRE, (Object)HiscoreSkill.ALCHEMICAL_HYDRA, (Object)HiscoreSkill.ARTIO, (Object)HiscoreSkill.BARROWS_CHESTS, (Object)HiscoreSkill.BRYOPHYTA, (Object)HiscoreSkill.CALLISTO, (Object)HiscoreSkill.CALVARION, (Object)HiscoreSkill.CERBERUS, (Object)HiscoreSkill.CHAMBERS_OF_XERIC, (Object)HiscoreSkill.CHAMBERS_OF_XERIC_CHALLENGE_MODE, (Object)HiscoreSkill.CHAOS_ELEMENTAL, (Object)HiscoreSkill.CHAOS_FANATIC, (Object[])new HiscoreSkill[]{HiscoreSkill.COMMANDER_ZILYANA, HiscoreSkill.CORPOREAL_BEAST, HiscoreSkill.DAGANNOTH_PRIME, HiscoreSkill.DAGANNOTH_REX, HiscoreSkill.DAGANNOTH_SUPREME, HiscoreSkill.CRAZY_ARCHAEOLOGIST, HiscoreSkill.DERANGED_ARCHAEOLOGIST, HiscoreSkill.DUKE_SUCELLUS, HiscoreSkill.GENERAL_GRAARDOR, HiscoreSkill.GIANT_MOLE, HiscoreSkill.GROTESQUE_GUARDIANS, HiscoreSkill.HESPORI, HiscoreSkill.KALPHITE_QUEEN, HiscoreSkill.KING_BLACK_DRAGON, HiscoreSkill.KRAKEN, HiscoreSkill.KREEARRA, HiscoreSkill.KRIL_TSUTSAROTH, HiscoreSkill.MIMIC, HiscoreSkill.NEX, HiscoreSkill.NIGHTMARE, HiscoreSkill.PHOSANIS_NIGHTMARE, HiscoreSkill.OBOR, HiscoreSkill.PHANTOM_MUSPAH, HiscoreSkill.SARACHNIS, HiscoreSkill.SCORPIA, HiscoreSkill.SKOTIZO, HiscoreSkill.SPINDEL, HiscoreSkill.TEMPOROSS, HiscoreSkill.THE_GAUNTLET, HiscoreSkill.THE_CORRUPTED_GAUNTLET, HiscoreSkill.THE_LEVIATHAN, HiscoreSkill.THE_WHISPERER, HiscoreSkill.THEATRE_OF_BLOOD, HiscoreSkill.THEATRE_OF_BLOOD_HARD_MODE, HiscoreSkill.THERMONUCLEAR_SMOKE_DEVIL, HiscoreSkill.TOMBS_OF_AMASCUT, HiscoreSkill.TOMBS_OF_AMASCUT_EXPERT, HiscoreSkill.TZKAL_ZUK, HiscoreSkill.TZTOK_JAD, HiscoreSkill.VARDORVIS, HiscoreSkill.VENENATIS, HiscoreSkill.VETION, HiscoreSkill.VORKATH, HiscoreSkill.WINTERTODT, HiscoreSkill.ZALCANO, HiscoreSkill.ZULRAH});
    static Color[] ROW_COLORS = new Color[]{ColorScheme.DARKER_GRAY_COLOR, new Color(34, 34, 34)};
    TableRow totalEhbRow;
    List<RowPair> tableRows = new ArrayList<RowPair>();

    @Inject
    private BossingPanel() {
        this.setLayout(new GridLayout(0, 1));
        StatsTableHeader tableHeader = new StatsTableHeader("bossing");
        this.totalEhbRow = new TableRow("ehb", "EHB", HiscoreSkillType.BOSS, "kills", "rank", "ehb");
        this.totalEhbRow.setBackground(ROW_COLORS[1]);
        this.add(tableHeader);
        this.add(this.totalEhbRow);
        for (int i = 0; i < BOSSES.size(); ++i) {
            HiscoreSkill boss = BOSSES.get(i);
            TableRow row = new TableRow(boss.name(), boss.getName(), HiscoreSkillType.BOSS, "kills", "rank", "ehb");
            row.setBackground(ROW_COLORS[i % 2]);
            this.tableRows.add(new RowPair(boss, row));
            this.add(row);
        }
    }

    public void update(PlayerInfo info) {
        if (info == null) {
            return;
        }
        Snapshot latestSnapshot = info.getLatestSnapshot();
        for (RowPair rp : this.tableRows) {
            HiscoreSkill boss = rp.getSkill();
            TableRow row = rp.getRow();
            row.update(latestSnapshot.getData().getBosses().getBoss(boss), boss);
        }
        this.updateTotalEhb(latestSnapshot.getData().getComputed().getEhb());
    }

    private void updateTotalEhb(Computed ehb) {
        JLabel rankLabel = this.totalEhbRow.labels.get("rank");
        JLabel ehbLabel = this.totalEhbRow.labels.get("ehb");
        int rank = ehb.getRank();
        double value = ehb.getValue();
        rankLabel.setText(Format.formatNumber(rank));
        rankLabel.setToolTipText(QuantityFormatter.formatNumber((long)rank));
        ehbLabel.setText(Format.formatNumber(value));
        ehbLabel.setToolTipText(QuantityFormatter.formatNumber((double)value));
    }

    public void reset() {
        for (Map.Entry<String, JLabel> entry : this.totalEhbRow.labels.entrySet()) {
            JLabel label = entry.getValue();
            label.setText("--");
            label.setToolTipText("");
        }
        for (RowPair rp : this.tableRows) {
            TableRow row = rp.getRow();
            for (Map.Entry<String, JLabel> e : row.labels.entrySet()) {
                JLabel label = e.getValue();
                label.setText("--");
                label.setToolTipText("");
            }
        }
    }
}

