/*
 * Decompiled with CFR 0.152.
 */
package net.wiseoldman.panel;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.hiscore.HiscoreSkill;
import net.runelite.client.hiscore.HiscoreSkillType;
import net.runelite.client.ui.ColorScheme;
import net.wiseoldman.beans.PlayerInfo;
import net.wiseoldman.beans.Snapshot;
import net.wiseoldman.panel.RowPair;
import net.wiseoldman.panel.StatsTableHeader;
import net.wiseoldman.panel.TableRow;

public class ActivitiesPanel
extends JPanel {
    private static final List<HiscoreSkill> ACTIVITIES = ImmutableList.of((Object)HiscoreSkill.LEAGUE_POINTS, (Object)HiscoreSkill.BOUNTY_HUNTER_HUNTER, (Object)HiscoreSkill.BOUNTY_HUNTER_ROGUE, (Object)HiscoreSkill.CLUE_SCROLL_ALL, (Object)HiscoreSkill.CLUE_SCROLL_BEGINNER, (Object)HiscoreSkill.CLUE_SCROLL_EASY, (Object)HiscoreSkill.CLUE_SCROLL_MEDIUM, (Object)HiscoreSkill.CLUE_SCROLL_HARD, (Object)HiscoreSkill.CLUE_SCROLL_ELITE, (Object)HiscoreSkill.CLUE_SCROLL_MASTER, (Object)HiscoreSkill.LAST_MAN_STANDING, (Object)HiscoreSkill.PVP_ARENA_RANK, (Object[])new HiscoreSkill[]{HiscoreSkill.SOUL_WARS_ZEAL, HiscoreSkill.RIFTS_CLOSED});
    static Color[] ROW_COLORS = new Color[]{ColorScheme.DARKER_GRAY_COLOR, new Color(34, 34, 34)};
    List<RowPair> tableRows = new ArrayList<RowPair>();

    @Inject
    private ActivitiesPanel() {
        this.setLayout(new GridLayout(0, 1));
        StatsTableHeader tableHeader = new StatsTableHeader("activities");
        this.add(tableHeader);
        for (int i = 0; i < ACTIVITIES.size(); ++i) {
            HiscoreSkill activity = ACTIVITIES.get(i);
            TableRow row = new TableRow(activity.name(), activity.getName(), HiscoreSkillType.ACTIVITY, "score", "rank");
            row.setBackground(ROW_COLORS[1 - i % 2]);
            this.tableRows.add(new RowPair(activity, row));
            this.add(row);
        }
    }

    public void update(PlayerInfo info) {
        if (info == null) {
            return;
        }
        Snapshot latestSnapshot = info.getLatestSnapshot();
        for (RowPair rp : this.tableRows) {
            HiscoreSkill minigame = rp.getSkill();
            TableRow row = rp.getRow();
            row.update(latestSnapshot.getData().getActivities().getActivity(minigame));
        }
    }

    public void reset() {
        for (RowPair rp : this.tableRows) {
            TableRow row = rp.getRow();
            for (Map.Entry<String, JLabel> e : row.labels.entrySet()) {
                JLabel label = e.getValue();
                label.setText("--");
                label.setToolTipText("");
            }
        }
    }
}

