/*
 * Decompiled with CFR 0.152.
 */
package net.wiseoldman.beans;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import net.wiseoldman.beans.CompetitionType;
import net.wiseoldman.beans.GroupInfo;
import net.wiseoldman.beans.Metric;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class Competition {
    int id;
    String title;
    Metric metric;
    CompetitionType type;
    Date startsAt;
    Date endsAt;
    int groupId;
    int score;
    Date createdAt;
    Date updatedAt;
    GroupInfo group;
    int particiantCount;

    public boolean isActive() {
        return this.hasStarted() && !this.hasEnded();
    }

    public boolean hasEnded() {
        return this.endsAt.before(new Date());
    }

    public boolean hasStarted() {
        return this.startsAt.before(new Date());
    }

    public Duration durationLeft() {
        if (this.isActive()) {
            return Duration.between(Instant.now(), this.endsAt.toInstant());
        }
        if (!this.hasStarted()) {
            return Duration.between(Instant.now(), this.startsAt.toInstant());
        }
        return Duration.ZERO;
    }

    private String durationLeftPretty() {
        return DurationFormatUtils.formatDurationWords((long)this.durationLeft().toMillis(), (boolean)true, (boolean)true);
    }

    public String getStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append("Competition: ").append(this.title).append(" ");
        if (this.isActive()) {
            sb.append("ends in ").append(this.durationLeftPretty());
        } else if (!this.hasStarted()) {
            sb.append("starts in ").append(this.durationLeftPretty());
        }
        return sb.toString();
    }

    public String getTimeStatus() {
        StringBuilder sb = new StringBuilder();
        if (this.isActive()) {
            sb.append("Ends in ").append(this.durationLeftPretty());
        } else if (!this.hasStarted()) {
            sb.append("Starts in ").append(this.durationLeftPretty());
        } else {
            sb.append("Ended");
        }
        return sb.toString();
    }

    public int getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public Metric getMetric() {
        return this.metric;
    }

    public CompetitionType getType() {
        return this.type;
    }

    public Date getStartsAt() {
        return this.startsAt;
    }

    public Date getEndsAt() {
        return this.endsAt;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public int getScore() {
        return this.score;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public GroupInfo getGroup() {
        return this.group;
    }

    public int getParticiantCount() {
        return this.particiantCount;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMetric(Metric metric) {
        this.metric = metric;
    }

    public void setType(CompetitionType type) {
        this.type = type;
    }

    public void setStartsAt(Date startsAt) {
        this.startsAt = startsAt;
    }

    public void setEndsAt(Date endsAt) {
        this.endsAt = endsAt;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setGroup(GroupInfo group) {
        this.group = group;
    }

    public void setParticiantCount(int particiantCount) {
        this.particiantCount = particiantCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Competition)) {
            return false;
        }
        Competition other = (Competition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        Metric this$metric = this.getMetric();
        Metric other$metric = other.getMetric();
        if (this$metric == null ? other$metric != null : !((Object)((Object)this$metric)).equals((Object)other$metric)) {
            return false;
        }
        CompetitionType this$type = this.getType();
        CompetitionType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Date this$startsAt = this.getStartsAt();
        Date other$startsAt = other.getStartsAt();
        if (this$startsAt == null ? other$startsAt != null : !((Object)this$startsAt).equals(other$startsAt)) {
            return false;
        }
        Date this$endsAt = this.getEndsAt();
        Date other$endsAt = other.getEndsAt();
        if (this$endsAt == null ? other$endsAt != null : !((Object)this$endsAt).equals(other$endsAt)) {
            return false;
        }
        if (this.getGroupId() != other.getGroupId()) {
            return false;
        }
        if (this.getScore() != other.getScore()) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Date this$updatedAt = this.getUpdatedAt();
        Date other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        GroupInfo this$group = this.getGroup();
        GroupInfo other$group = other.getGroup();
        if (this$group == null ? other$group != null : !((Object)this$group).equals(other$group)) {
            return false;
        }
        return this.getParticiantCount() == other.getParticiantCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Competition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        Metric $metric = this.getMetric();
        result = result * 59 + ($metric == null ? 43 : ((Object)((Object)$metric)).hashCode());
        CompetitionType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Date $startsAt = this.getStartsAt();
        result = result * 59 + ($startsAt == null ? 43 : ((Object)$startsAt).hashCode());
        Date $endsAt = this.getEndsAt();
        result = result * 59 + ($endsAt == null ? 43 : ((Object)$endsAt).hashCode());
        result = result * 59 + this.getGroupId();
        result = result * 59 + this.getScore();
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Date $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        GroupInfo $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : ((Object)$group).hashCode());
        result = result * 59 + this.getParticiantCount();
        return result;
    }

    public String toString() {
        return "Competition(id=" + this.getId() + ", title=" + this.getTitle() + ", metric=" + this.getMetric() + ", type=" + this.getType() + ", startsAt=" + this.getStartsAt() + ", endsAt=" + this.getEndsAt() + ", groupId=" + this.getGroupId() + ", score=" + this.getScore() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", group=" + this.getGroup() + ", particiantCount=" + this.getParticiantCount() + ")";
    }
}

