/*
 * Decompiled with CFR 0.152.
 */
package net.wiseoldman;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.inject.Binder;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Nameable;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.WorldType;
import net.runelite.api.clan.ClanRank;
import net.runelite.api.clan.ClanSettings;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.NameableNameChanged;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetUtil;
import net.runelite.client.Notifier;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatCommandManager;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.InfoBoxMenuClicked;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.menus.MenuManager;
import net.runelite.client.menus.WidgetMenuOption;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.plugins.xpupdater.XpUpdaterConfig;
import net.runelite.client.plugins.xpupdater.XpUpdaterPlugin;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.util.Text;
import net.wiseoldman.WomUtilsConfig;
import net.wiseoldman.beans.Competition;
import net.wiseoldman.beans.CompetitionInfo;
import net.wiseoldman.beans.GroupMembership;
import net.wiseoldman.beans.NameChangeEntry;
import net.wiseoldman.beans.ParticipantWithCompetition;
import net.wiseoldman.beans.ParticipantWithStanding;
import net.wiseoldman.events.WomGroupMemberAdded;
import net.wiseoldman.events.WomGroupMemberRemoved;
import net.wiseoldman.events.WomGroupSynced;
import net.wiseoldman.events.WomOngoingPlayerCompetitionsFetched;
import net.wiseoldman.events.WomUpcomingPlayerCompetitionsFetched;
import net.wiseoldman.panel.NameAutocompleter;
import net.wiseoldman.panel.WomPanel;
import net.wiseoldman.ui.CodeWordOverlay;
import net.wiseoldman.ui.CompetitionInfobox;
import net.wiseoldman.ui.PlaceHolderCompetitionInfobox;
import net.wiseoldman.ui.SyncButton;
import net.wiseoldman.ui.WomIconHandler;
import net.wiseoldman.util.DelayedAction;
import net.wiseoldman.web.WomClient;
import net.wiseoldman.web.WomCommand;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDependency(value=XpUpdaterPlugin.class)
@PluginDescriptor(name="Wise Old Man", tags={"wom", "utils", "group", "xp"}, description="Helps you manage your wiseoldman.net group and track your competitions.")
public class WomUtilsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WomUtilsPlugin.class);
    static final String CONFIG_GROUP = "womutils";
    private static final File WORKING_DIR;
    private static final String NAME_CHANGES = "name-changes.json";
    private static final String ADD_MEMBER = "Add member";
    private static final String REMOVE_MEMBER = "Remove member";
    private static final String IMPORT_MEMBERS = "Import";
    private static final String BROWSE_GROUP = "Browse";
    private static final String MENU_TARGET = "WOM group";
    private static final String LOOKUP = "WOM lookup";
    private static final String IGNORE_RANK = "Ignore rank";
    private static final String UNIGNORE_RANK = "Unignore rank";
    private static final String KICK_OPTION = "Kick";
    public static final String HIDE_COMPETITION_INFOBOX = "Hide competition";
    public static final String SHOW_ALL_COMPETITIONS = "Show all competitions";
    private static final ImmutableList<String> AFTER_OPTIONS;
    private final int RESIZABLE_VIEWPORT_BOTTOM_LINE_FRIEND_CHAT_TAB_ID = 10747941;
    private final ImmutableList<WidgetMenuOption> WIDGET_IMPORT_MENU_OPTIONS = new ImmutableList.Builder().add((Object)new WidgetMenuOption("Import", "WOM group", 35913774)).add((Object)new WidgetMenuOption("Import", "WOM group", 10551338)).add((Object)new WidgetMenuOption("Import", "WOM group", 10747941)).build();
    private final ImmutableList<WidgetMenuOption> WIDGET_BROWSE_MENU_OPTIONS = new ImmutableList.Builder().add((Object)new WidgetMenuOption("Browse", "WOM group", 35913774)).add((Object)new WidgetMenuOption("Browse", "WOM group", 10551338)).add((Object)new WidgetMenuOption("Browse", "WOM group", 10747941)).build();
    private static final int XP_THRESHOLD = 10000;
    private static final int CLAN_SIDEPANEL_DRAW = 4397;
    private static final int CLAN_SETTINGS_MEMBERS_DRAW = 4232;
    private static final int CLAN_SETTINGS_INFO_PAGE_WIDGET = 690;
    private static final int CLAN_SETTINGS_INFO_PAGE_WIDGET_ID = 0x2B20002;
    private static final int CLAN_SETTINGS_MEMBERS_PAGE_WIDGET = 693;
    private static final int CLAN_SETTINGS_MEMBERS_PAGE_WIDGET_ID = 45416450;
    private static final int CLAN_OPTIONS_RANKS_WIDGET = 45416459;
    private static final Color SUCCESS;
    private static final Color DEFAULT_CLAN_SETTINGS_TEXT_COLOR;
    private static final Splitter SPLITTER;
    private boolean levelupThisSession = false;
    private static String MESSAGE_PREFIX;
    public boolean isSeasonal = false;
    @Inject
    private Client client;
    @Inject
    private WomUtilsConfig config;
    @Inject
    private MenuManager menuManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ChatboxPanelManager chatboxPanelManager;
    @Inject
    private Gson gson;
    @Inject
    private JsonParser jsonParser;
    @Inject
    private WomIconHandler iconHandler;
    @Inject
    private ChatCommandManager chatCommandManager;
    @Inject
    private WomClient womClient;
    @Inject
    private XpUpdaterConfig xpUpdaterConfig;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ScheduledExecutorService scheduledExecutorService;
    @Inject
    private Notifier notifier;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private CodeWordOverlay codeWordOverlay;
    private WomPanel womPanel;
    @Inject
    ClientToolbar clientToolbar;
    private Map<String, String> nameChanges = new HashMap<String, String>();
    private LinkedBlockingQueue<NameChangeEntry> queue = new LinkedBlockingQueue();
    private Map<String, GroupMembership> groupMembers = new HashMap<String, GroupMembership>();
    private List<ParticipantWithStanding> playerCompetitionsOngoing = new ArrayList<ParticipantWithStanding>();
    private List<ParticipantWithCompetition> playerCompetitionsUpcoming = new ArrayList<ParticipantWithCompetition>();
    private List<CompetitionInfobox> competitionInfoboxes = new CopyOnWriteArrayList<CompetitionInfobox>();
    private List<ScheduledFuture<?>> scheduledFutures = new ArrayList();
    private Map<Integer, CompetitionInfo> competitionInfoMap = new HashMap<Integer, CompetitionInfo>();
    private List<String> ignoredRanks = new ArrayList<String>();
    private List<String> alwaysIncludedOnSync = new ArrayList<String>();
    private List<Integer> hiddenCompetitions = new ArrayList<Integer>();
    private boolean showTimerOngoing;
    private boolean showTimerUpcoming;
    private int upcomingInfoboxesMaxDays;
    private boolean fetchXp;
    private long lastXp;
    private boolean visitedLoginScreen = true;
    private boolean recentlyLoggedIn;
    private String playerName;
    private long accountHash;
    private boolean namechangesSubmitted = false;
    private SyncButton syncButton;
    private NavigationButton navButton;
    private PlaceHolderCompetitionInfobox placeHolderCompetitionInfobox;
    private final Map<Skill, Integer> previousSkillLevels = new EnumMap<Skill, Integer>(Skill.class);

    protected void startUp() throws Exception {
        log.info("Wise Old Man started!");
        this.womPanel = (WomPanel)((Object)this.injector.getInstance(WomPanel.class));
        try {
            this.loadFile();
        }
        catch (IOException e) {
            log.error("Could not load previous name changes");
        }
        this.iconHandler.loadIcons();
        this.womClient.importGroupMembers();
        if (this.config.playerLookupOption()) {
            this.menuManager.addPlayerMenuItem(LOOKUP);
        }
        if (this.config.importGroup()) {
            this.addGroupImportOptions();
        }
        if (this.config.browseGroup()) {
            this.addGroupBrowseOptions();
        }
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.iconHandler.rebuildLists(this.groupMembers, this.config.showicons());
            this.recentlyLoggedIn = true;
        }
        for (WomCommand c : WomCommand.values()) {
            this.chatCommandManager.registerCommandAsync(c.getCommand(), this::commandHandler);
        }
        this.hiddenCompetitions = new ArrayList<Integer>(Arrays.asList((Integer[])this.gson.fromJson(this.config.hiddenCompetitionIds(), Integer[].class)));
        this.showTimerOngoing = this.config.timerOngoing();
        this.showTimerUpcoming = this.config.timerUpcoming();
        this.upcomingInfoboxesMaxDays = this.config.upcomingMaxDays();
        this.placeHolderCompetitionInfobox = new PlaceHolderCompetitionInfobox(this);
        this.infoBoxManager.addInfoBox((InfoBox)this.placeHolderCompetitionInfobox);
        this.ignoredRanks = new ArrayList<String>(Arrays.asList((String[])this.gson.fromJson(this.config.ignoredRanks(), String[].class)));
        this.alwaysIncludedOnSync.addAll(SPLITTER.splitToList((CharSequence)this.config.alwaysIncludedOnSync()));
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"wom-icon.png");
        this.navButton = NavigationButton.builder().tooltip("Wise Old Man").icon(icon).priority(5).panel((PluginPanel)this.womPanel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.overlayManager.add((Overlay)this.codeWordOverlay);
        this.clientThread.invoke(this::saveCurrentLevels);
    }

    protected void shutDown() throws Exception {
        this.removeGroupMenuOptions();
        this.menuManager.removePlayerMenuItem(LOOKUP);
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.iconHandler.rebuildLists(this.groupMembers, false);
        }
        for (WomCommand c : WomCommand.values()) {
            this.chatCommandManager.unregisterCommand(c.getCommand());
        }
        this.clientToolbar.removeNavigation(this.navButton);
        this.womPanel.shutdown();
        this.clearInfoboxes();
        this.cancelNotifications();
        this.previousSkillLevels.clear();
        this.competitionInfoMap.clear();
        this.hiddenCompetitions.clear();
        this.ignoredRanks.clear();
        this.alwaysIncludedOnSync.clear();
        this.levelupThisSession = false;
        this.overlayManager.remove((Overlay)this.codeWordOverlay);
        this.infoBoxManager.removeInfoBox((InfoBox)this.placeHolderCompetitionInfobox);
        log.info("Wise Old Man stopped!");
    }

    private void addGroupBrowseOptions() {
        this.addGroupMenuOptions((List<WidgetMenuOption>)this.WIDGET_BROWSE_MENU_OPTIONS, ev -> this.openGroupInBrowser());
    }

    private void addGroupImportOptions() {
        this.addGroupMenuOptions((List<WidgetMenuOption>)this.WIDGET_IMPORT_MENU_OPTIONS, ev -> this.womClient.importGroupMembers());
    }

    private void saveCurrentLevels() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        for (Skill s : Skill.values()) {
            this.previousSkillLevels.put(s, this.client.getRealSkillLevel(s));
        }
    }

    private void commandHandler(ChatMessage chatMessage, String s) {
        WomCommand cmd = WomCommand.fromCommand(s);
        if (cmd == null) {
            return;
        }
        this.commandLookup(cmd, chatMessage);
    }

    private void commandLookup(WomCommand command, ChatMessage chatMessage) {
        ChatMessageType type = chatMessage.getType();
        String player = type == ChatMessageType.PRIVATECHATOUT ? this.client.getLocalPlayer().getName() : Text.sanitize((String)chatMessage.getName());
        this.womClient.commandLookup(player, command, chatMessage);
    }

    @Subscribe
    public void onNameableNameChanged(NameableNameChanged nameableNameChanged) {
        Nameable nameable = nameableNameChanged.getNameable();
        String name = nameable.getName();
        String prev = nameable.getPrevName();
        if (Strings.isNullOrEmpty((String)prev) || name.equals(prev) || prev.startsWith("[#") || name.startsWith("[#")) {
            return;
        }
        NameChangeEntry entry = new NameChangeEntry(Text.toJagexName((String)prev), Text.toJagexName((String)name));
        if (this.isChangeAlreadyRegistered(entry)) {
            return;
        }
        this.registerNameChange(entry);
    }

    private boolean isChangeAlreadyRegistered(NameChangeEntry entry) {
        String expected = this.nameChanges.get(entry.getNewName());
        return expected != null && expected.equals(entry.getOldName());
    }

    private void registerNameChange(NameChangeEntry entry) {
        this.nameChanges.put(entry.getNewName(), entry.getOldName());
        this.queue.add(entry);
    }

    @Schedule(period=30L, unit=ChronoUnit.MINUTES)
    public void sendUpdate() {
        if (this.queue.isEmpty()) {
            if (this.syncButton != null) {
                this.syncButton.setEnabled();
            }
            this.namechangesSubmitted = true;
            return;
        }
        this.womClient.submitNameChanges(this.queue.toArray(new NameChangeEntry[0]));
        this.clientThread.invoke(this.queue::clear);
        try {
            this.saveFile();
            if (this.syncButton != null) {
                this.syncButton.setEnabled();
            }
            this.namechangesSubmitted = true;
        }
        catch (IOException e) {
            log.error("Could not write name changes to filesystem");
        }
    }

    private void loadFile() throws IOException {
        File file = new File(WORKING_DIR, NAME_CHANGES);
        if (file.exists()) {
            String json = Files.asCharSource((File)file, (Charset)Charsets.UTF_8).read();
            JsonObject jsonObject = this.jsonParser.parse(json).getAsJsonObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                this.nameChanges.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
        }
    }

    private void saveFile() throws IOException {
        String changes = this.gson.toJson(this.nameChanges);
        File file = new File(WORKING_DIR, NAME_CHANGES);
        Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)changes);
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        boolean addMenuLookup;
        if (!this.config.addRemoveMember() && !this.config.menuLookupOption()) {
            return;
        }
        int groupId = WidgetUtil.componentToInterface((int)event.getActionParam1());
        String option = event.getOption();
        if (!AFTER_OPTIONS.contains((Object)option) || option.equals("Delete") && groupId != 432) {
            return;
        }
        boolean addModifyMember = this.config.addRemoveMember() && this.config.groupId() > 0 && !Strings.isNullOrEmpty((String)this.config.verificationCode()) && (groupId == 7 || groupId == 429 || groupId == 701 || groupId == 702);
        int offset = (addModifyMember ? 1 : 0) + ((addMenuLookup = this.config.menuLookupOption() && (groupId == 429 || groupId == 7 || groupId == 701 || groupId == 702 || groupId == 162 && !KICK_OPTION.equals(option) || groupId == 500 || groupId == 163 || groupId == 432)) ? 1 : 0);
        if (offset == 0) {
            return;
        }
        String name = Text.toJagexName((String)Text.removeTags((String)event.getTarget()));
        if (addModifyMember) {
            this.client.createMenuEntry(-offset).setOption(this.groupMembers.containsKey(name.toLowerCase()) ? REMOVE_MEMBER : ADD_MEMBER).setType(MenuAction.RUNELITE).setTarget(event.getTarget()).onClick(e -> {
                if (this.groupMembers.containsKey(name.toLowerCase())) {
                    this.womClient.removeGroupMember(name);
                } else {
                    this.womClient.addGroupMember(name);
                }
            });
            --offset;
        }
        if (addMenuLookup) {
            this.client.createMenuEntry(-offset).setTarget(event.getTarget()).setOption(LOOKUP).setType(MenuAction.RUNELITE).setIdentifier(event.getIdentifier()).onClick(e -> this.lookupPlayer(name));
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuAction() == MenuAction.RUNELITE_PLAYER && event.getMenuOption().equals(LOOKUP)) {
            Player player = this.client.getCachedPlayers()[event.getId()];
            if (player == null) {
                return;
            }
            String target = player.getName();
            this.lookupPlayer(target);
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged event) {
        Skill s = event.getSkill();
        int levelAfter = this.client.getRealSkillLevel(s);
        int levelBefore = this.previousSkillLevels.getOrDefault(s, -1);
        if (levelBefore != -1 && levelAfter > levelBefore) {
            this.levelupThisSession = true;
        }
        this.previousSkillLevels.put(s, levelAfter);
    }

    private void openGroupInBrowser() {
        String url = new HttpUrl.Builder().scheme("https").host(this.isSeasonal ? "league.wiseoldman.net" : "wiseoldman.net").addPathSegment("groups").addPathSegment("" + this.config.groupId()).build().toString();
        SwingUtilities.invokeLater(() -> LinkBrowser.browse((String)url));
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals(CONFIG_GROUP)) {
            return;
        }
        this.menuManager.removePlayerMenuItem(LOOKUP);
        if (this.config.playerLookupOption()) {
            this.menuManager.addPlayerMenuItem(LOOKUP);
        }
        this.removeGroupMenuOptions();
        if (this.config.groupId() > 0) {
            if (this.config.browseGroup()) {
                this.addGroupBrowseOptions();
            }
            if (this.config.importGroup()) {
                this.addGroupImportOptions();
            }
        }
        if ((event.getKey().equals("showIcons") || event.getKey().equals("showFlags")) && this.client.getGameState() == GameState.LOGGED_IN) {
            this.iconHandler.rebuildLists(this.groupMembers, this.config.showicons());
        }
        if (event.getKey().equals("sendCompetitionNotification")) {
            this.updateScheduledNotifications();
        }
        if (event.getKey().equals("timerOngoing") || event.getKey().equals("timerUpcoming") || event.getKey().equals("upcomingMaxDays")) {
            this.showTimerOngoing = this.config.timerOngoing();
            this.showTimerUpcoming = this.config.timerUpcoming();
            this.upcomingInfoboxesMaxDays = this.config.upcomingMaxDays();
        }
        if (event.getKey().equals("alwaysIncludedOnSync")) {
            this.alwaysIncludedOnSync.clear();
            this.alwaysIncludedOnSync.addAll(SPLITTER.splitToList((CharSequence)this.config.alwaysIncludedOnSync()));
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 1658) {
            this.iconHandler.rebuildMemberList(!this.config.showicons(), this.groupMembers, 458764);
        } else if (event.getScriptId() == 4397) {
            this.iconHandler.rebuildMemberList(!this.config.showicons(), this.groupMembers, 45940742);
            this.iconHandler.rebuildMemberList(!this.config.showicons(), this.groupMembers, 46006278);
        } else if (event.getScriptId() == 4232) {
            this.iconHandler.rebuildSettingsMemberList(!this.config.showicons(), this.groupMembers);
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        if (widgetLoaded.getGroupId() != 690 && widgetLoaded.getGroupId() != 693) {
            return;
        }
        switch (widgetLoaded.getGroupId()) {
            case 693: {
                this.clientThread.invoke(() -> this.createSyncButton(45416450));
                if (this.syncButton != null) {
                    this.syncButton.setEnabled();
                }
                this.clientThread.invokeLater(this::updateIgnoredRankColors);
                break;
            }
            case 690: {
                this.clientThread.invoke(() -> this.createSyncButton(0x2B20002));
                if (this.namechangesSubmitted) {
                    this.syncButton.setEnabled();
                    break;
                }
                this.clientThread.invokeLater(this::sendUpdate);
            }
        }
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        if (!this.config.showicons() || !this.iconHandler.iconsAreLoaded()) {
            return;
        }
        this.iconHandler.handleScriptEvent(event, this.groupMembers);
    }

    @Subscribe
    public void onInfoBoxMenuClicked(InfoBoxMenuClicked event) {
        if (!(event.getInfoBox() instanceof CompetitionInfobox) && !(event.getInfoBox() instanceof PlaceHolderCompetitionInfobox)) {
            return;
        }
        switch (event.getEntry().getOption()) {
            case "Hide competition": {
                this.hiddenCompetitions.add(((CompetitionInfobox)event.getInfoBox()).getLinkedCompetitionId());
                this.config.hiddenCompetitionIds(this.gson.toJson(this.hiddenCompetitions));
                break;
            }
            case "Show all competitions": {
                this.hiddenCompetitions.clear();
                this.config.hiddenCompetitionIds(this.gson.toJson(this.hiddenCompetitions));
            }
        }
    }

    public boolean allInfoboxesAreHidden() {
        return this.competitionInfoboxes.size() != 0 && this.competitionInfoboxes.stream().allMatch(ib -> !ib.shouldShow() || ib.isHidden()) && this.countHiddenInfoboxes() != 0;
    }

    public int countHiddenInfoboxes() {
        return (int)this.competitionInfoboxes.stream().filter(ib -> ib.shouldShow() && ib.isHidden()).count();
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        if (event.getMenuEntries().length < 2) {
            return;
        }
        MenuEntry entry = event.getMenuEntries()[event.getMenuEntries().length - 1];
        if (entry.getType() != MenuAction.CC_OP || entry.getParam1() != 45416459) {
            return;
        }
        ClanSettings clanSettings = this.client.getClanSettings();
        String targetPlayer = Text.removeTags((String)entry.getTarget());
        ClanRank rank = clanSettings.findMember(targetPlayer).getRank();
        String rankTitle = clanSettings.titleForRank(rank).getName();
        String targetRank = ColorUtil.wrapWithColorTag((String)rankTitle, (Color)new Color(16748608));
        boolean rankIsIgnored = this.ignoredRanks.contains(rankTitle.toLowerCase());
        this.client.createMenuEntry(-1).setOption(!rankIsIgnored ? IGNORE_RANK : UNIGNORE_RANK).setType(MenuAction.RUNELITE).setTarget(targetRank).onClick(e -> {
            if (!rankIsIgnored) {
                this.ignoredRanks.add(rankTitle.toLowerCase());
            } else {
                this.ignoredRanks.removeIf(r -> r.equals(rankTitle.toLowerCase()));
            }
            this.config.ignoredRanks(this.gson.toJson(this.ignoredRanks));
            this.updateIgnoredRankColors();
        });
    }

    private void updateIgnoredRankColors() {
        Widget parent = this.client.getWidget(45416459);
        if (parent == null) {
            return;
        }
        Widget[] children = parent.getDynamicChildren();
        if (children == null || children.length == 0) {
            return;
        }
        for (Widget child : children) {
            if (this.ignoredRanks.contains(child.getText().toLowerCase())) {
                child.setTextColor(Color.RED.getRGB());
                continue;
            }
            child.setTextColor(DEFAULT_CLAN_SETTINGS_TEXT_COLOR.getRGB());
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        GameState state = gameStateChanged.getGameState();
        switch (state) {
            case LOGGED_IN: {
                if (this.accountHash != this.client.getAccountHash()) {
                    this.fetchXp = true;
                }
                this.recentlyLoggedIn = true;
                this.isSeasonal = this.client.getWorldType().contains(WorldType.SEASONAL);
                break;
            }
            case LOGIN_SCREEN: {
                this.visitedLoginScreen = true;
                this.namechangesSubmitted = false;
            }
            case HOPPING: {
                Player local = this.client.getLocalPlayer();
                if (local == null) {
                    return;
                }
                long totalXp = this.client.getOverallExperience();
                if (Math.abs(totalXp - this.lastXp) <= 10000L && !this.levelupThisSession) break;
                this.updateMostRecentPlayer();
                this.lastXp = totalXp;
                this.levelupThisSession = false;
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.fetchXp) {
            this.lastXp = this.client.getOverallExperience();
            this.fetchXp = false;
        }
        Player local = this.client.getLocalPlayer();
        if (this.visitedLoginScreen && this.recentlyLoggedIn && local != null) {
            this.playerName = local.getName();
            this.accountHash = this.client.getAccountHash();
            this.womClient.fetchOngoingPlayerCompetitions(this.playerName);
            this.womClient.fetchUpcomingPlayerCompetitions(this.playerName);
            this.recentlyLoggedIn = false;
            this.visitedLoginScreen = false;
        }
    }

    private void addGroupMenuOptions(List<WidgetMenuOption> menuOptions, Consumer<MenuEntry> callback) {
        for (WidgetMenuOption option : menuOptions) {
            this.menuManager.addManagedCustomMenu(option, callback);
        }
    }

    private void removeGroupMenuOptions() {
        for (WidgetMenuOption option : this.WIDGET_BROWSE_MENU_OPTIONS) {
            this.menuManager.removeManagedCustomMenu(option);
        }
        for (WidgetMenuOption option : this.WIDGET_IMPORT_MENU_OPTIONS) {
            this.menuManager.removeManagedCustomMenu(option);
        }
    }

    private void updateMostRecentPlayer() {
        this.updateMostRecentPlayer(false);
    }

    private void updateMostRecentPlayer(boolean always) {
        boolean coreUpdaterIsOff = this.pluginManager.getPlugins().stream().noneMatch(p -> p instanceof XpUpdaterPlugin && this.pluginManager.isPluginEnabled(p));
        if (always || !this.xpUpdaterConfig.wiseoldman() || coreUpdaterIsOff) {
            log.debug("Submitting update for {}", (Object)this.playerName);
            this.womClient.updatePlayer(this.playerName, this.accountHash);
        }
    }

    private void lookupPlayer(String playerName) {
        SwingUtilities.invokeLater(() -> {
            if (!this.navButton.isSelected()) {
                this.navButton.getOnSelect().run();
            }
            this.womPanel.lookup(playerName);
        });
    }

    @Subscribe
    public void onWomGroupSynced(WomGroupSynced event) {
        HashMap<String, GroupMembership> old = new HashMap<String, GroupMembership>(this.groupMembers);
        this.groupMembers.clear();
        for (GroupMembership member : event.getGroupInfo().getMemberships()) {
            this.groupMembers.put(member.getPlayer().getUsername(), member);
        }
        this.onGroupUpdate();
        if (!event.isSilent()) {
            String message = this.compareChanges(old, this.groupMembers);
            this.sendResponseToChat(message, SUCCESS);
            this.iconHandler.rebuildSettingsMemberList(!this.config.showicons(), this.groupMembers);
        }
    }

    @Subscribe
    public void onWomGroupMemberAdded(WomGroupMemberAdded event) {
        this.womClient.importGroupMembers();
        this.onGroupUpdate();
        String message = "New player added: " + event.getUsername();
        this.sendResponseToChat(message, SUCCESS);
    }

    @Subscribe
    public void onWomGroupMemberRemoved(WomGroupMemberRemoved event) {
        this.womClient.importGroupMembers();
        this.onGroupUpdate();
        String message = "Player removed: " + event.getUsername();
        this.sendResponseToChat(message, SUCCESS);
    }

    @Subscribe
    public void onWomOngoingPlayerCompetitionsFetched(WomOngoingPlayerCompetitionsFetched event) {
        this.playerCompetitionsOngoing = Arrays.asList(event.getCompetitions());
        log.debug("Fetched {} ongoing competitions for player {}", (Object)event.getCompetitions().length, (Object)event.getUsername());
        for (ParticipantWithStanding pws : this.playerCompetitionsOngoing) {
            Competition c = pws.getCompetition();
            if (!this.config.competitionLoginMessage()) continue;
            this.sendHighlightedMessage(c.getStatus());
        }
        this.updateInfoboxes();
        this.updateScheduledNotifications();
    }

    @Subscribe
    public void onWomUpcomingPlayerCompetitionsFetched(WomUpcomingPlayerCompetitionsFetched event) {
        this.playerCompetitionsUpcoming = Arrays.asList(event.getCompetitions());
        log.debug("Fetched {} upcoming competitions for player {}", (Object)event.getCompetitions().length, (Object)event.getUsername());
        this.updateInfoboxes();
        this.updateScheduledNotifications();
    }

    private void updateInfoboxes() {
        this.clearInfoboxes();
        for (ParticipantWithCompetition pwc : this.playerCompetitionsUpcoming) {
            Competition c = pwc.getCompetition();
            this.competitionInfoboxes.add(new CompetitionInfobox(c, this));
        }
        for (ParticipantWithStanding pws : this.playerCompetitionsOngoing) {
            this.competitionInfoboxes.add(new CompetitionInfobox(pws, this));
        }
        log.debug("Adding infoboxes for {} upcoming and {} ongoing competitions", (Object)this.playerCompetitionsUpcoming.size(), (Object)this.playerCompetitionsOngoing.size());
        for (CompetitionInfobox b : this.competitionInfoboxes) {
            this.infoBoxManager.addInfoBox((InfoBox)b);
        }
    }

    private void clearInfoboxes() {
        this.infoBoxManager.removeIf(CompetitionInfobox.class::isInstance);
        this.competitionInfoboxes.clear();
    }

    private void updateScheduledNotifications() {
        Competition c;
        this.cancelNotifications();
        ArrayList<DelayedAction> delayedActions = new ArrayList<DelayedAction>();
        for (ParticipantWithCompetition pwc : this.playerCompetitionsUpcoming) {
            c = pwc.getCompetition();
            if (c.hasStarted()) continue;
            delayedActions.add(new DelayedAction(c.durationLeft().plusSeconds(1L), () -> this.updateMostRecentPlayer(true)));
            if (!this.config.sendCompetitionNotification()) continue;
            delayedActions.add(new DelayedAction(c.durationLeft().minusHours(1L), () -> this.notifier.notify(c.getStatus())));
            delayedActions.add(new DelayedAction(c.durationLeft().minusMinutes(15L), () -> this.notifier.notify(c.getStatus())));
            delayedActions.add(new DelayedAction(c.durationLeft().plusSeconds(1L), () -> this.notifier.notify("Competition: " + c.getTitle() + " has started!")));
        }
        for (ParticipantWithStanding pws : this.playerCompetitionsOngoing) {
            c = pws.getCompetition();
            delayedActions.add(new DelayedAction(c.durationLeft().minusMinutes(15L), () -> this.updateMostRecentPlayer(true)));
            if (!this.config.sendCompetitionNotification()) continue;
            delayedActions.add(new DelayedAction(c.durationLeft().minusHours(1L), () -> this.notifier.notify(c.getStatus())));
            delayedActions.add(new DelayedAction(c.durationLeft().minusMinutes(15L), () -> this.notifier.notify(c.getStatus())));
            delayedActions.add(new DelayedAction(c.durationLeft().minusMinutes(4L), () -> this.notifier.notify("Competition: " + c.getTitle() + " is ending soon, logout now to record your final datapoint!")));
            delayedActions.add(new DelayedAction(c.durationLeft().plusSeconds(1L), () -> this.notifier.notify("Competition: " + c.getTitle() + " is over, thanks for playing!")));
        }
        for (DelayedAction action : delayedActions) {
            if (action.getDelay().isNegative()) continue;
            this.scheduledFutures.add(this.scheduledExecutorService.schedule(action.getRunnable(), action.getDelay().getSeconds(), TimeUnit.SECONDS));
        }
    }

    private void cancelNotifications() {
        for (ScheduledFuture<?> sf : this.scheduledFutures) {
            sf.cancel(false);
        }
        this.scheduledFutures.clear();
    }

    private void onGroupUpdate() {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.iconHandler.rebuildLists(this.groupMembers, this.config.showicons());
        }
    }

    private String compareChanges(Map<String, GroupMembership> oldMembers, Map<String, GroupMembership> newMembers) {
        int membersAdded = 0;
        int ranksChanged = 0;
        for (String username : newMembers.keySet()) {
            if (oldMembers.containsKey(username)) {
                if (newMembers.get(username).getRole().equals(oldMembers.get(username).getRole())) continue;
                ++ranksChanged;
                continue;
            }
            ++membersAdded;
        }
        int membersRemoved = oldMembers.size() + membersAdded - newMembers.size();
        return String.format("Synced %d clan members. %d added, %d removed, %d ranks changed.", newMembers.size(), membersAdded, membersRemoved, ranksChanged);
    }

    private void sendResponseToChat(String message, Color color) {
        ChatMessageBuilder cmb = new ChatMessageBuilder();
        cmb.append(color, MESSAGE_PREFIX + message);
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(cmb.build()).build());
    }

    private void sendHighlightedMessage(String chatMessage) {
        String message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(MESSAGE_PREFIX + chatMessage).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
    }

    private void createSyncButton(int w) {
        if (this.config.syncClanButton() && this.config.groupId() > 0 && !Strings.isNullOrEmpty((String)this.config.verificationCode())) {
            this.syncButton = new SyncButton(this.client, this.womClient, this.chatboxPanelManager, w, this.groupMembers, this.ignoredRanks, this.alwaysIncludedOnSync);
        }
    }

    @Provides
    WomUtilsConfig provideConfig(ConfigManager configManager) {
        return (WomUtilsConfig)configManager.getConfig(WomUtilsConfig.class);
    }

    public void configure(Binder binder) {
        binder.bind(WomIconHandler.class);
        binder.bind(NameAutocompleter.class);
        binder.bind(WomClient.class);
        binder.bind(CodeWordOverlay.class);
    }

    public List<Integer> getHiddenCompetitions() {
        return this.hiddenCompetitions;
    }

    public boolean isShowTimerOngoing() {
        return this.showTimerOngoing;
    }

    public boolean isShowTimerUpcoming() {
        return this.showTimerUpcoming;
    }

    public int getUpcomingInfoboxesMaxDays() {
        return this.upcomingInfoboxesMaxDays;
    }

    static {
        AFTER_OPTIONS = ImmutableList.of((Object)"Message", (Object)"Add ignore", (Object)"Remove friend", (Object)"Delete", (Object)KICK_OPTION);
        SUCCESS = new Color(170, 255, 40);
        DEFAULT_CLAN_SETTINGS_TEXT_COLOR = new Color(16750623);
        SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
        MESSAGE_PREFIX = "Wom: ";
        WORKING_DIR = new File(RuneLite.RUNELITE_DIR, "wom-utils");
        WORKING_DIR.mkdirs();
    }
}

