/*
 * Decompiled with CFR 0.152.
 */
package net.wiseoldman;

import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="womutils")
public interface WomUtilsConfig
extends Config {
    @ConfigSection(name="Group", description="The group configurations", position=1)
    public static final String groupConfig = "groupConfig";
    @ConfigSection(name="Lookup", description="Lookup menu option configurations", position=2)
    public static final String lookupConfig = "lookupConfig";
    @ConfigSection(name="Competitions", description="Competition configurations", position=3)
    public static final String competitionConfig = "competitionConfig";
    @ConfigSection(name="Event codeword", description="Event codeword configurations", position=4)
    public static final String eventCodeword = "eventCodeword";

    @ConfigItem(keyName="playerLookupOption", name="Player option", description="Add WOM Lookup option to players", position=0, section="lookupConfig")
    default public boolean playerLookupOption() {
        return true;
    }

    @ConfigItem(keyName="menuLookupOption", name="Menu option", description="Add WOM Lookup option to menus", position=1, section="lookupConfig")
    default public boolean menuLookupOption() {
        return true;
    }

    @ConfigItem(keyName="virtualLevels", name="Virtual levels", description="Show virtual levels in the side bar on lookup", position=2, section="lookupConfig")
    default public boolean virtualLevels() {
        return false;
    }

    @ConfigItem(keyName="relativeTime", name="Relative time", description="Display last updated time relative to current date and time", position=3, section="lookupConfig")
    default public boolean relativeTime() {
        return false;
    }

    @ConfigItem(keyName="showIcons", name="Show icons", description="Show icons in friend list and clan chat for people who are in the WOM group", position=0, section="groupConfig")
    default public boolean showicons() {
        return true;
    }

    @ConfigItem(keyName="showFlags", name="Show flags", description="Show flags instead of the group icon where possible for your group members, requires icons to be enabled.", position=1, section="groupConfig")
    default public boolean showFlags() {
        return true;
    }

    @ConfigItem(keyName="importGroup", name="Import Group option", description="Add Import WOM Group menu option to the clan chat tab", position=2, section="groupConfig")
    default public boolean importGroup() {
        return true;
    }

    @ConfigItem(keyName="browseGroup", name="Browse Group option", description="Add Browse WOM Group menu option to the clan chat tab", position=3, section="groupConfig")
    default public boolean browseGroup() {
        return true;
    }

    @ConfigItem(keyName="addRemoveMember", name="Add/Remove Member option", description="Add options to add & remove players from group, to clan chat and friend list", position=4, section="groupConfig")
    default public boolean addRemoveMember() {
        return true;
    }

    @ConfigItem(keyName="syncClanButton", name="Sync Clan button", description="Add a sync clan button to the clan members list in settings if a group is configured", position=5, section="groupConfig")
    default public boolean syncClanButton() {
        return true;
    }

    @ConfigItem(keyName="alwaysIncludedOnSync", name="Always Included", description="Players that will always be included in the group regardless of clan sync method, comma separated names", position=6, section="groupConfig")
    default public String alwaysIncludedOnSync() {
        return "";
    }

    @ConfigItem(keyName="groupId", name="Group Id", description="The group id in WOM", position=7, section="groupConfig")
    default public int groupId() {
        return 0;
    }

    @ConfigItem(keyName="verificationCode", name="Verification code", description="Verification code for the WOM group", secret=true, position=8, section="groupConfig")
    default public String verificationCode() {
        return "";
    }

    @ConfigItem(keyName="competitionLoginMessage", name="Login info", description="Show ongoing competition info when logging in", position=1, section="competitionConfig")
    default public boolean competitionLoginMessage() {
        return true;
    }

    @ConfigItem(keyName="timerOngoing", name="Timer Ongoing", description="Displays timers for ongoing competitions", position=2, section="competitionConfig")
    default public boolean timerOngoing() {
        return true;
    }

    @ConfigItem(keyName="timerUpcoming", name="Timer Upcoming", description="Display timers for upcoming competitions", position=3, section="competitionConfig")
    default public boolean timerUpcoming() {
        return false;
    }

    @ConfigItem(keyName="upcomingMaxDays", name="Upcoming up to", description="Don't show info for competitions later than this many days in the future", position=4, section="competitionConfig")
    @Range(max=365)
    @Units(value=" days")
    default public int upcomingMaxDays() {
        return 7;
    }

    @ConfigItem(keyName="sendCompetitionNotification", name="Competition Notifications", description="Sends notifications at start and end times for competitions", position=5, section="competitionConfig")
    default public boolean sendCompetitionNotification() {
        return false;
    }

    @ConfigItem(keyName="displayCodeword", name="Display codeword", description="Displays an event codeword overlay", position=13, section="eventCodeword")
    default public boolean displayCodeword() {
        return false;
    }

    @ConfigItem(keyName="configuredCodeword", name="Codeword", description="Event codeword", position=14, section="eventCodeword")
    default public String configuredCodeword() {
        return "WOMCodeword";
    }

    @ConfigItem(keyName="showTimestamp", name="Show timestamp", description="Attach a timestamp to the codeword", position=15, section="eventCodeword")
    default public boolean showTimestamp() {
        return true;
    }

    @ConfigItem(keyName="codewordColor", name="Codeword color", description="Overlay codeword color", position=16, section="eventCodeword")
    default public Color codewordColor() {
        return new Color(65386);
    }

    @ConfigItem(keyName="timestampColor", name="Timestamp color", description="Overlay timestamp color", position=16, section="eventCodeword")
    default public Color timestampColor() {
        return new Color(0xFFFFFF);
    }

    @ConfigItem(keyName="hiddenCompetitionIds", name="", description="", hidden=true)
    default public String hiddenCompetitionIds() {
        return "[]";
    }

    @ConfigItem(keyName="hiddenCompetitionIds", name="", description="", hidden=true)
    public void hiddenCompetitionIds(String var1);

    @ConfigItem(keyName="ignoredRanks", name="", description="", hidden=true)
    default public String ignoredRanks() {
        return "[]";
    }

    @ConfigItem(keyName="ignoredRanks", name="", description="", hidden=true)
    public void ignoredRanks(String var1);
}

