/*
 * Decompiled with CFR 0.152.
 */
package dekvall.danceparty;

import com.google.common.collect.ImmutableList;
import com.google.inject.Provides;
import dekvall.danceparty.DanceMove;
import dekvall.danceparty.DancePartyConfig;
import dekvall.danceparty.Move;
import dekvall.danceparty.WorkoutMove;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicChanged;
import net.runelite.api.events.PlayerDespawned;
import net.runelite.api.events.PlayerSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Dance Party")
public class DancePartyPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DancePartyPlugin.class);
    private static final int DANCE_DURATION_BARROWS = 8;
    private static final int DANCE_DURATION_BOSSKILL = 8;
    private static final int DANCE_DURATION_LEVELUP = 40;
    private static final int DANCE_DURATION_PETDROP = 60;
    private static final int DANCE_DURATION_RAIDDONE = 20;
    private static final Pattern NUMBER_PATTERN = Pattern.compile("([0-9]+)");
    private static final Pattern BOSSKILL_MESSAGE_PATTERN = Pattern.compile("Your (.+) kill count is: <col=ff0000>(\\d+)</col>.");
    private static final ImmutableList<String> PET_MESSAGES = ImmutableList.of((Object)"You have a funny feeling like you're being followed", (Object)"You feel something weird sneaking into your backpack", (Object)"You have a funny feeling like you would have been followed");
    @Inject
    private Client client;
    @Inject
    private DancePartyConfig config;
    private final Set<Player> players = new HashSet<Player>();
    private final Random rand = new Random();
    private static int forceDanceTick = 0;

    protected void startUp() throws Exception {
        log.info("Dance Party started!");
    }

    protected void shutDown() throws Exception {
        this.players.clear();
        log.info("Dance Party stopped!");
    }

    @Subscribe
    public void onPlayerSpawned(PlayerSpawned event) {
        if (event.getPlayer() != this.client.getLocalPlayer()) {
            this.players.add(event.getPlayer());
        }
    }

    @Subscribe
    public void onPlayerDespawned(PlayerDespawned event) {
        this.players.remove(event.getPlayer());
    }

    @Subscribe
    public void onGraphicChanged(GraphicChanged event) {
        if (event.getActor() != this.client.getLocalPlayer()) {
            return;
        }
        switch (event.getActor().getGraphic()) {
            case 199: 
            case 1388: 
            case 1389: {
                forceDanceTick = this.client.getTickCount() + 40;
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        for (Player player : this.players) {
            this.applyAnimationIfPossible(player);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        Matcher m;
        if (event.getType() != ChatMessageType.GAMEMESSAGE && event.getType() != ChatMessageType.SPAM && event.getType() != ChatMessageType.TRADE && event.getType() != ChatMessageType.FRIENDSCHATNOTIFICATION) {
            return;
        }
        String chatMessage = event.getMessage();
        if (this.config.partyOnRaidDone()) {
            if (chatMessage.startsWith("Your Barrows chest count is") && (m = NUMBER_PATTERN.matcher(Text.removeTags((String)chatMessage))).find()) {
                forceDanceTick = this.client.getTickCount() + 8;
                return;
            }
            if ((chatMessage.startsWith("Your completed Chambers of Xeric count is:") || chatMessage.startsWith("Your completed Chambers of Xeric Challenge Mode count is:") || chatMessage.startsWith("Your completed Theatre of Blood count is:")) && (m = NUMBER_PATTERN.matcher(Text.removeTags((String)chatMessage))).find()) {
                forceDanceTick = this.client.getTickCount() + 20;
                return;
            }
        }
        if (this.config.partyOnPetDrop()) {
            if (PET_MESSAGES.stream().anyMatch(chatMessage::contains)) {
                forceDanceTick = this.client.getTickCount() + 60;
                return;
            }
        }
        if (this.config.partyOnBossKill() && (m = BOSSKILL_MESSAGE_PATTERN.matcher(chatMessage)).matches()) {
            forceDanceTick = this.client.getTickCount() + 8;
        }
    }

    void applyAnimationIfPossible(Player player) {
        if (player.getAnimation() != -1 || this.config.disableInPvp() && this.client.getVar(8121) == 1 || (this.config.partyOnBossKill() || this.config.partyOnLevelup() || this.config.partyOnPetDrop() || this.config.partyOnRaidDone()) && forceDanceTick < this.client.getTickCount()) {
            return;
        }
        if (this.config.workoutMode()) {
            this.setPlayerMoveFrom(WorkoutMove.values(), player);
        } else {
            this.setPlayerMoveFrom(DanceMove.values(), player);
        }
    }

    private void setPlayerMoveFrom(Move[] moves, Player player) {
        Move move = moves[this.rand.nextInt(moves.length)];
        player.setAnimation(move.getAnimId());
        player.setActionFrame(0);
        if (move.getGfxId() != -1) {
            player.setGraphic(move.getGfxId());
            player.setSpotAnimFrame(0);
        }
    }

    @Provides
    DancePartyConfig provideConfig(ConfigManager configManager) {
        return (DancePartyConfig)configManager.getConfig(DancePartyConfig.class);
    }
}

