/*
 * Decompiled with CFR 0.152.
 */
package com.dpshelper;

import com.dpshelper.DPSHelperConfig;
import com.dpshelper.DPSHelperOverlay;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.kit.KitType;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.http.api.item.ItemEquipmentStats;
import net.runelite.http.api.item.ItemStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="DPS Helper", description="This plugin helps you to lose less ticks when attacking npcs, by telling you the ticks between attacks, so you can optimize your gameplay")
public class DPSHelperPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DPSHelperPlugin.class);
    @Inject
    private Client client;
    @Inject
    private DPSHelperConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private DPSHelperOverlay overlay;
    @Inject
    private ItemManager itemManager;
    private int attackToReset;
    private int attacks;
    private int gameTicks;
    private int cooldown;
    private int lastAttackTick;
    private int totalTickLost;
    private int aSpeed1;
    private int aSpeed2;
    private int currentAS;
    private boolean inCombat = false;

    @Provides
    DPSHelperConfig provideConfig(ConfigManager configManager) {
        return (DPSHelperConfig)configManager.getConfig(DPSHelperConfig.class);
    }

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
        this.resetPlugin();
    }

    protected void shutDown() {
        this.resetPlugin();
        this.overlayManager.remove((Overlay)this.overlay);
        this.lastAttackTick = 0;
        this.currentAS = 0;
        this.cooldown = 0;
        this.inCombat = false;
    }

    private void resetPlugin() {
        this.gameTicks = 0;
        this.attacks = 0;
        this.attackToReset = this.config.getAttackReset();
        this.totalTickLost = 0;
    }

    private void resetGameTick() {
        this.gameTicks = 0;
    }

    private void idleReset() {
        this.gameTicks = 0;
        this.inCombat = false;
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.gameTicks > this.config.getMaxIdle()) {
            this.idleReset();
        }
        if (this.inCombat) {
            ++this.gameTicks;
            if (--this.cooldown <= 0) {
                // empty if block
            }
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        Actor actor = event.getActor();
        int animationId = actor.getAnimation();
        if (actor instanceof Player) {
            if (animationId == this.config.getSkip1() || animationId == this.config.getSkip2()) {
                return;
            }
            if (!actor.equals(this.client.getLocalPlayer())) {
                return;
            }
            switch (animationId) {
                case -1: {
                    break;
                }
                case 245: 
                case 376: 
                case 377: 
                case 381: 
                case 386: 
                case 390: 
                case 393: 
                case 395: 
                case 400: 
                case 401: 
                case 406: 
                case 407: 
                case 414: 
                case 419: 
                case 422: 
                case 423: 
                case 426: 
                case 428: 
                case 440: 
                case 1058: 
                case 1060: 
                case 1062: 
                case 1064: 
                case 1067: 
                case 1074: 
                case 1167: 
                case 1203: 
                case 1378: 
                case 1658: 
                case 1665: 
                case 1667: 
                case 1710: 
                case 1711: 
                case 1712: 
                case 1872: 
                case 2062: 
                case 2066: 
                case 2067: 
                case 2068: 
                case 2075: 
                case 2080: 
                case 2081: 
                case 2082: 
                case 2890: 
                case 3157: 
                case 3294: 
                case 3297: 
                case 3298: 
                case 3299: 
                case 3300: 
                case 3852: 
                case 4503: 
                case 4505: 
                case 5061: 
                case 5865: 
                case 5870: 
                case 6118: 
                case 6147: 
                case 7004: 
                case 7045: 
                case 7054: 
                case 7055: 
                case 7328: 
                case 7511: 
                case 7512: 
                case 7514: 
                case 7515: 
                case 7516: 
                case 7521: 
                case 7552: 
                case 7554: 
                case 7555: 
                case 7556: 
                case 7617: 
                case 7638: 
                case 7640: 
                case 7642: 
                case 7644: 
                case 8010: 
                case 8056: 
                case 8145: 
                case 8194: 
                case 8195: 
                case 8288: 
                case 8289: 
                case 8290: 
                case 8291: 
                case 8292: 
                case 9168: 
                case 9171: 
                case 9173: 
                case 9471: 
                case 9493: {
                    this.totalTickLost += this.getTickLostOnAttack();
                    this.handleAttack();
                    this.inCombat = true;
                    if (this.cooldown <= 0) {
                        this.getAttackSpeed();
                        this.cooldown = this.currentAS;
                    }
                    ++this.attacks;
                    this.checkSummary();
                    this.resetGameTick();
                }
            }
        }
    }

    private int getTickLostOnAttack() {
        int sum = 0;
        if (!this.inCombat) {
            if (this.attacks == 0) {
                sum = 0;
            }
        } else {
            sum = this.gameTicks - this.currentAS;
        }
        return sum;
    }

    private void checkSummary() {
        if (!this.config.getSummary()) {
            return;
        }
        if (this.attacks >= this.attackToReset) {
            this.postSummary();
        }
    }

    private void postSummary() {
        String s = "You lost " + this.totalTickLost + " ticks in the last " + this.config.getAttackReset() + " attacks";
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", s, null);
        }
        this.resetPlugin();
    }

    private void handleAttack() {
        if (!this.config.getEachAttack()) {
            return;
        }
        if (!this.inCombat) {
            if (this.attacks == 0) {
                this.getAttackSpeed();
                this.lastAttackTick = this.currentAS;
            }
        } else {
            this.lastAttackTick = this.gameTicks;
        }
        if (this.config.getUI()) {
            return;
        }
        String s = "Ticks between last attack: " + this.lastAttackTick + " ticks";
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", s, null);
        }
    }

    private void getAttackSpeed() {
        int itemId = this.client.getLocalPlayer().getPlayerComposition().getEquipmentId(KitType.WEAPON);
        ItemStats stats = this.itemManager.getItemStats(itemId, false);
        if (stats == null) {
            return;
        }
        ItemEquipmentStats currentEquipment = stats.getEquipment();
        this.handleAS(currentEquipment.getAspeed());
    }

    private void handleAS(int aSpeed) {
        this.aSpeed2 = this.aSpeed1 = this.currentAS;
        this.currentAS = aSpeed;
    }

    public int getGameTicks() {
        return this.gameTicks;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getLastAttackTick() {
        return this.lastAttackTick;
    }

    public int getASpeed2() {
        return this.aSpeed2;
    }

    public int getCurrentAS() {
        return this.currentAS;
    }
}

