/*
 * Decompiled with CFR 0.152.
 */
package com.dpshelper;

import com.dpshelper.DPSHelperConfig;
import com.dpshelper.DPSHelperPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.TitleComponent;

class DPSHelperOverlay
extends OverlayPanel {
    private final DPSHelperPlugin plugin;
    private final DPSHelperConfig config;

    @Inject
    private DPSHelperOverlay(DPSHelperPlugin plugin, DPSHelperConfig config) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "DPS Helper overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.getUI()) {
            int tick = this.plugin.getLastAttackTick();
            String lastAttack = "Ticks since last attack: " + tick;
            this.panelComponent.getChildren().add(TitleComponent.builder().text(lastAttack).color(tick == this.plugin.getASpeed2() ? Color.GREEN : Color.RED).build());
            this.panelComponent.setPreferredSize(new Dimension(graphics.getFontMetrics().stringWidth(lastAttack) + 10, 0));
            return super.render(graphics);
        }
        return null;
    }
}

