/*
 * Decompiled with CFR 0.152.
 */
package chestnut1693.batslocator;

import chestnut1693.batslocator.BatsLocator;
import chestnut1693.batslocator.BatsLocatorConfig;
import chestnut1693.batslocator.BatsLocatorPlugin;
import chestnut1693.batslocator.Chest;
import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.components.ProgressPieComponent;

public class BatsOverlay
extends Overlay {
    private BatsLocatorPlugin plugin;
    private BatsLocatorConfig config;
    private Client client;
    private ProgressPieComponent pie = new ProgressPieComponent();

    @Inject
    public BatsOverlay(BatsLocatorConfig config, BatsLocatorPlugin plugin, Client client) {
        this.config = config;
        this.plugin = plugin;
        this.client = client;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.pie.setProgress(100.0);
        this.pie.setBorderColor(Color.black);
    }

    public Dimension render(Graphics2D graphics) {
        WorldPoint playerLocation;
        Player player = this.client.getLocalPlayer();
        WorldPoint worldPoint = playerLocation = player == null ? null : player.getWorldLocation();
        if (playerLocation == null) {
            return null;
        }
        BatsLocator batsLocator = this.plugin.getBatsLocator();
        if (this.plugin.isInRaidChambers() && batsLocator.isDrawChestStates()) {
            for (Chest chest : batsLocator.getChests().values()) {
                Color color;
                Point chestCanvas;
                LocalPoint chestLocal;
                if (chest.getState() == Chest.State.GRUBS || playerLocation.distanceTo(chest.getLocation()) > 25 || (chestLocal = LocalPoint.fromWorld((Client)this.client, (WorldPoint)chest.getLocation())) == null || (chestCanvas = Perspective.localToCanvas((Client)this.client, (LocalPoint)chestLocal, (int)this.client.getPlane())) == null) continue;
                switch (chest.getState()) {
                    case UNVISITED: {
                        color = this.config.unvisitedColor();
                        break;
                    }
                    case BATS: {
                        color = this.config.batsColor();
                        break;
                    }
                    case POISON: {
                        color = this.config.poisonColor();
                        break;
                    }
                    default: {
                        color = Color.white;
                    }
                }
                String chestNumber = String.valueOf(chest.getNumber());
                graphics.setFont(FontManager.getRunescapeSmallFont());
                int stringWidth = graphics.getFontMetrics().stringWidth(chestNumber);
                int stringHeight = graphics.getFontMetrics().getHeight();
                if (batsLocator.getSolutionSets().size() == 0 && (chest.getState() == Chest.State.POISON || chest.getState() == Chest.State.BATS)) {
                    chestCanvas = new Point(chestCanvas.getX() - stringWidth / 2, chestCanvas.getY() - stringHeight / 2);
                    OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)chestCanvas, (String)chestNumber, (Color)color);
                    continue;
                }
                if (chest.getSolutionSetCount() != 0 && chest.getSolutionSetCount() == batsLocator.getHighestSolutionSetCount()) {
                    this.pie.setDiameter((int)Math.round((double)this.config.dotSize() + (double)this.config.dotSize() / 3.0));
                    graphics.setFont(FontManager.getRunescapeFont());
                    stringWidth = graphics.getFontMetrics().stringWidth(chestNumber);
                    stringHeight = graphics.getFontMetrics().getHeight();
                } else {
                    this.pie.setDiameter(this.config.dotSize());
                    color = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.config.transparency());
                }
                this.pie.setFill(color);
                this.pie.setPosition(new Point(chestCanvas.getX(), chestCanvas.getY()));
                switch (this.config.displayMode()) {
                    case DOTS: {
                        this.pie.render(graphics);
                        break;
                    }
                    case NUMBERS: {
                        chestCanvas = new Point(chestCanvas.getX() - stringWidth / 2, chestCanvas.getY() + stringHeight / 2);
                        OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)chestCanvas, (String)chestNumber, (Color)color);
                    }
                }
            }
        }
        return null;
    }
}

