/*
 * Decompiled with CFR 0.152.
 */
package chestnut1693.batslocator;

import chestnut1693.batslocator.BatsLocator;
import chestnut1693.batslocator.BatsLocatorConfig;
import chestnut1693.batslocator.BatsOverlay;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.GraphicsObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Bats Locator", description="Helps locate the chest with bats at the thieving room inside Chambers of Xeric", tags={"finder", "thieving"}, enabledByDefault=true)
public class BatsLocatorPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BatsLocatorPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private BatsLocatorConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private BatsOverlay overlay;
    private BatsLocator batsLocator;
    private boolean inRaidChambers;

    @Provides
    BatsLocatorConfig provideConfig(ConfigManager configManager) {
        return (BatsLocatorConfig)configManager.getConfig(BatsLocatorConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.clientThread.invokeLater(() -> this.checkRaidPresence(true));
        this.batsLocator = new BatsLocator(this.client);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.inRaidChambers = false;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("raids")) {
            return;
        }
        this.clientThread.invokeLater(() -> this.checkRaidPresence(true));
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        this.checkRaidPresence(false);
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject gameObject = event.getGameObject();
        switch (gameObject.getId()) {
            case 29746: {
                this.batsLocator.troughSpawnEvent(gameObject);
                break;
            }
            case 29742: 
            case 29743: 
            case 29744: 
            case 29745: {
                this.batsLocator.chestSpawnEvent(gameObject);
            }
        }
    }

    @Subscribe
    public void onGraphicsObjectCreated(GraphicsObjectCreated event) {
        GraphicsObject graphicsObject;
        if (this.inRaidChambers && (graphicsObject = event.getGraphicsObject()).getId() == 184) {
            this.batsLocator.poisonSplatEvent(WorldPoint.fromLocal((Client)this.client, (LocalPoint)graphicsObject.getLocation()));
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.inRaidChambers) {
            this.batsLocator.gameTickEvent();
        }
    }

    private void checkRaidPresence(boolean force) {
        boolean setting;
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        boolean bl = setting = this.client.getVar(5432) == 1;
        if (force || this.inRaidChambers != setting) {
            if (!setting) {
                this.batsLocator = new BatsLocator(this.client);
            }
            this.inRaidChambers = setting;
        }
    }

    public BatsLocator getBatsLocator() {
        return this.batsLocator;
    }

    public boolean isInRaidChambers() {
        return this.inRaidChambers;
    }
}

