/*
 * Decompiled with CFR 0.152.
 */
package chestnut1693.batslocator;

import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.Range;

@ConfigGroup(value="chestnut1693.batslocator")
public interface BatsLocatorConfig
extends Config {
    @ConfigItem(keyName="unvisitedColor", name="Unvisited chest color", description="Configures the color of the unvisited chest dot and number", position=0)
    default public Color unvisitedColor() {
        return Color.magenta;
    }

    @ConfigItem(keyName="batsColor", name="Bats chest color", description="Configures the color of the bats chest dot and number", position=1)
    default public Color batsColor() {
        return Color.white;
    }

    @ConfigItem(keyName="poisonColor", name="Poison chest color", description="Configures the color of the poison chest dot and number", position=2)
    default public Color poisonColor() {
        return Color.green;
    }

    @Range(max=27)
    @ConfigItem(keyName="dotSize", name="Dot size", description="Configures the size of the transparent dots, solid dots are one third larger", position=3)
    default public int dotSize() {
        return 9;
    }

    @Range(max=255)
    @ConfigItem(keyName="transparency", name="Transparency", description="Configures the transparency of the chest dots and numbers that are not likely to contain poison or bats", position=4)
    default public int transparency() {
        return 75;
    }

    @ConfigItem(keyName="displayMode", name="Display mode", description="Configures displaying chest states as dots or numbers", position=5)
    default public DisplayMode displayMode() {
        return DisplayMode.DOTS;
    }

    public static enum DisplayMode {
        DOTS,
        NUMBERS;

    }
}

