/*
 * Decompiled with CFR 0.152.
 */
package chestnut1693.batslocator;

import chestnut1693.batslocator.Chest;
import chestnut1693.batslocator.RoomType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.coords.WorldPoint;

public class BatsLocator {
    static final int TROUGH = 29746;
    static final int CLOSED = 29742;
    static final int OPENED_POISON_OR_BATS = 29743;
    static final int OPENED_WITHOUT_GRUBS = 29744;
    static final int OPENED_WITH_GRUBS = 29745;
    static final int POISON_SPLAT = 184;
    private RoomType roomType;
    private HashMap<WorldPoint, Chest> chests = new HashMap();
    private HashSet<Chest> poisonBatsChests = new HashSet();
    private HashSet<Chest> grubsChests = new HashSet();
    private ArrayList<ArrayList<Chest>> solutionSets = new ArrayList();
    private int highestSolutionSetCount = 0;
    private boolean drawChestStates = false;
    private Client client;
    private int rotation = -1;

    public BatsLocator(Client client) {
        this.client = client;
    }

    public void troughSpawnEvent(GameObject trough) {
        if (this.roomType == null && this.rotation == -1) {
            int plane = trough.getPlane();
            int chunkX = trough.getLocalLocation().getSceneX() / 8;
            int chunkY = trough.getLocalLocation().getSceneY() / 8;
            int chunkData = this.client.getInstanceTemplateChunks()[plane][chunkX][chunkY];
            int instanceX = (chunkData >> 14 & 0x3FF) * 8;
            this.rotation = chunkData >> 1 & 3;
            switch (instanceX) {
                case 3264: 
                case 3272: {
                    this.roomType = RoomType.LEFT;
                    break;
                }
                case 3344: {
                    this.roomType = RoomType.RIGHT;
                    break;
                }
                case 3312: {
                    this.roomType = RoomType.STRAIGHT;
                }
            }
            this.assignChestNumbersAndGenerateSolutionSets();
        }
    }

    public void chestSpawnEvent(GameObject chestObject) {
        WorldPoint chestLocation = chestObject.getWorldLocation();
        Chest chest = this.chests.get(chestLocation);
        if (chest == null) {
            chest = new Chest(chestLocation);
            this.chests.put(chestLocation, chest);
            switch (chestObject.getId()) {
                case 29743: {
                    this.poisonBatsChests.add(chest);
                    break;
                }
                case 29744: 
                case 29745: {
                    this.grubsChests.add(chest);
                }
            }
            this.assignChestNumbersAndGenerateSolutionSets();
        } else {
            switch (chestObject.getId()) {
                case 29743: {
                    this.poisonBatsChests.add(chest);
                    this.openChest(chest, Chest.State.POISON);
                    break;
                }
                case 29744: 
                case 29745: {
                    this.grubsChests.add(chest);
                    this.openChest(chest, Chest.State.GRUBS);
                }
            }
        }
    }

    private ArrayList<ArrayList<Chest>> solutionSetsContaining(Chest chest) {
        ArrayList<ArrayList<Chest>> solutionSets = new ArrayList<ArrayList<Chest>>();
        for (ArrayList<Chest> solutionSet : this.solutionSets) {
            if (!solutionSet.contains(chest)) continue;
            solutionSets.add(solutionSet);
        }
        return solutionSets;
    }

    private boolean solutionSetContains(ArrayList<Chest> solutionSet, Chest.State state) {
        for (Chest chest : solutionSet) {
            if (chest.getState() != state) continue;
            return true;
        }
        return false;
    }

    private void openChest(Chest openedChest, Chest.State state) {
        openedChest.setState(state);
        if (this.solutionSets.size() == 0) {
            if (this.poisonBatsChests.size() == 4) {
                for (Chest chest : this.chests.values()) {
                    if (this.poisonBatsChests.contains(chest)) continue;
                    chest.setState(Chest.State.GRUBS);
                }
            }
            return;
        }
        if (state == Chest.State.POISON || state == Chest.State.BATS) {
            HashSet<Chest> possiblePoisonBatsChests = new HashSet<Chest>();
            for (ArrayList<Chest> solutionSet : this.solutionSetsContaining(openedChest)) {
                for (Chest chest : solutionSet) {
                    if (chest.getState() == Chest.State.GRUBS) continue;
                    possiblePoisonBatsChests.add(chest);
                }
            }
            if (possiblePoisonBatsChests.size() == 0) {
                this.solutionSets.clear();
            }
            for (ArrayList<Chest> solutionSet : this.solutionSets) {
                for (Chest chest : solutionSet) {
                    if (possiblePoisonBatsChests.contains(chest) || chest.getState() != Chest.State.UNVISITED) continue;
                    chest.setState(Chest.State.GRUBS);
                }
            }
        }
        Iterator<ArrayList<Chest>> solutionSets = this.solutionSets.iterator();
        while (solutionSets.hasNext()) {
            ArrayList<Chest> solutionSet = solutionSets.next();
            for (Chest chest : solutionSet) {
                if (chest.getState() != Chest.State.UNVISITED) continue;
                boolean setState = true;
                for (ArrayList<Chest> otherSolutionSet : this.solutionSetsContaining(chest)) {
                    if (this.solutionSetContains(otherSolutionSet, Chest.State.GRUBS)) continue;
                    setState = false;
                    break;
                }
                if (!setState) continue;
                chest.setState(Chest.State.GRUBS);
            }
            if (!this.solutionSetContains(solutionSet, Chest.State.GRUBS)) continue;
            solutionSets.remove();
        }
        if (this.solutionSets.size() == 1 && this.solutionSetContains(this.solutionSets.get(0), Chest.State.BATS)) {
            for (Chest chest : this.solutionSets.get(0)) {
                if (chest.getState() != Chest.State.UNVISITED) continue;
                chest.setState(Chest.State.POISON);
            }
        }
        if (this.solutionSets.size() == 0) {
            if (this.poisonBatsChests.size() == 4) {
                for (Chest chest : this.chests.values()) {
                    if (this.poisonBatsChests.contains(chest)) continue;
                    chest.setState(Chest.State.GRUBS);
                }
            } else {
                for (Chest chest : this.chests.values()) {
                    if (this.poisonBatsChests.contains(chest) || this.grubsChests.contains(chest)) continue;
                    chest.setState(Chest.State.UNVISITED);
                }
            }
        }
        this.findSolutionSetCounts();
    }

    private void findSolutionSetCounts() {
        this.highestSolutionSetCount = 0;
        for (Chest chest : this.chests.values()) {
            chest.setSolutionSetCount(0);
            if (chest.getState() != Chest.State.UNVISITED) continue;
            for (ArrayList<Chest> solutionSet : this.solutionSetsContaining(chest)) {
                if (this.solutionSetContains(solutionSet, Chest.State.GRUBS)) continue;
                chest.setSolutionSetCount(chest.getSolutionSetCount() + 1);
            }
            if (chest.getSolutionSetCount() <= this.highestSolutionSetCount) continue;
            this.highestSolutionSetCount = chest.getSolutionSetCount();
        }
    }

    private void assignChestNumbersAndGenerateSolutionSets() {
        if (this.rotation != -1 && this.roomType != null && this.chests.size() == this.roomType.getChestCount()) {
            Comparator<Chest> comparator;
            switch (this.rotation) {
                case 0: {
                    comparator = Comparator.comparing(Chest::getLocation, Comparator.comparing(WorldPoint::getY).thenComparing(WorldPoint::getX));
                    break;
                }
                case 1: {
                    comparator = Comparator.comparing(Chest::getLocation, Comparator.comparing(WorldPoint::getX).reversed().thenComparing(WorldPoint::getY).reversed());
                    break;
                }
                case 2: {
                    comparator = Comparator.comparing(Chest::getLocation, Comparator.comparing(WorldPoint::getY).thenComparing(WorldPoint::getX).reversed());
                    break;
                }
                case 3: {
                    comparator = Comparator.comparing(Chest::getLocation, Comparator.comparing(WorldPoint::getX).reversed().thenComparing(WorldPoint::getY));
                    break;
                }
                default: {
                    comparator = Comparator.comparing(Chest::getNumber);
                }
            }
            ArrayList<Chest> chests = new ArrayList<Chest>(this.chests.values());
            chests.sort(comparator);
            for (int i = 0; i < chests.size(); ++i) {
                chests.get(i).setNumber(i);
            }
            for (int[] indices : this.roomType.getSolutionSets()) {
                ArrayList<Chest> solutionSet = new ArrayList<Chest>();
                for (int index : indices) {
                    solutionSet.add(chests.get(index));
                }
                this.solutionSets.add(solutionSet);
            }
            Object object = this.chests.values().iterator();
            while (object.hasNext()) {
                Chest chest = (Chest)object.next();
                if (this.solutionSetsContaining(chest).size() != 0) continue;
                chest.setState(Chest.State.GRUBS);
            }
            for (Chest chest : this.poisonBatsChests) {
                this.openChest(chest, Chest.State.POISON);
            }
            for (Chest chest : this.grubsChests) {
                this.openChest(chest, Chest.State.GRUBS);
            }
            this.findSolutionSetCounts();
            this.drawChestStates = true;
        }
    }

    public void poisonSplatEvent(WorldPoint worldPoint) {
        Chest chest = this.chests.get(worldPoint);
        if (chest != null) {
            chest.setTickPoison(this.client.getTickCount());
        }
    }

    public void gameTickEvent() {
        for (Chest chest : this.poisonBatsChests) {
            if (chest.getState() != Chest.State.POISON || chest.getTickPoison() != -1L) continue;
            this.openChest(chest, Chest.State.BATS);
        }
    }

    public RoomType getRoomType() {
        return this.roomType;
    }

    public HashMap<WorldPoint, Chest> getChests() {
        return this.chests;
    }

    public HashSet<Chest> getPoisonBatsChests() {
        return this.poisonBatsChests;
    }

    public HashSet<Chest> getGrubsChests() {
        return this.grubsChests;
    }

    public ArrayList<ArrayList<Chest>> getSolutionSets() {
        return this.solutionSets;
    }

    public int getHighestSolutionSetCount() {
        return this.highestSolutionSetCount;
    }

    public boolean isDrawChestStates() {
        return this.drawChestStates;
    }
}

