/*
 * Decompiled with CFR 0.152.
 */
package com.NoNewItems;

import com.NoNewItems.NoNewItemsConfig;
import com.google.inject.Provides;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.JagexColor;
import net.runelite.api.NodeCache;
import net.runelite.api.Player;
import net.runelite.api.events.PostItemComposition;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="No New Items", description="Avoid using items that were not originally part of Old School RuneScape.", tags={"07", "07 only", "no updates", "no changes", "items", "no new items"})
public class NoNewItemsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NoNewItemsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private NoNewItemsConfig config;
    @Inject
    private ClientThread clientThread;
    public short[] all_colours = new short[65536];
    public short[] new_colours = new short[65536];
    public short[] all_textures = new short[94];
    public short[] new_textures = new short[94];
    public int[] inserted_item_ids;

    public void reset(boolean show_reset_message) {
        Player[] cached_players;
        if (show_reset_message) {
            this.clientThread.invokeLater(this::reset_message);
        }
        NodeCache cache = this.client.getItemModelCache();
        cache.reset();
        cache = this.client.getItemSpriteCache();
        cache.reset();
        cache = this.client.getItemCompositionCache();
        cache.reset();
        Player me = this.client.getLocalPlayer();
        if (me != null) {
            me.getPlayerComposition().setHash();
        }
        for (Player other : cached_players = this.client.getCachedPlayers()) {
            if (other == null) continue;
            other.getPlayerComposition().setHash();
        }
    }

    public void reset_message() {
        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "\n", null);
        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "\nNo New Items Plugin: Please note that you may need to log out and back in for visual changes to some other players to fully take effect.\n", null);
        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "\n", null);
    }

    protected void startUp() throws Exception {
        int i;
        log.info("No New Items started!");
        for (i = 0; i < 65536; ++i) {
            this.all_colours[i] = (short)i;
            this.new_colours[i] = JagexColor.packHSL((int)0, (int)7, (int)51);
        }
        for (i = 0; i < 94; ++i) {
            this.all_textures[i] = (short)i;
            this.new_textures[i] = 56;
        }
        this.inserted_item_ids = new int[]{3066, 3068, 3070, 3072, 3074, 3076, 3078, 3082, 3084, 3086, 3088, 3090, 3092, 3242, 3244, 3246, 3248, 3905, 3907, 3909, 3911, 3921, 3923, 3925, 3963, 3965, 3967, 3927, 3929, 3931, 3933, 3250, 3252, 3254, 3256, 599, 1589, 2420, 2512, 1649, 1650, 1651, 1652, 1653, 6564, 2425, 3272, 3902, 4000, 4076, 4177, 3951, 4762, 4767, 4768, 4763, 4764, 4765, 4766, 4769, 4770, 4771, 4772, 3955, 3957, 3959, 3961, 3973, 3975, 3977, 3979, 3981, 3983, 3985, 3987, 3989, 3991, 3993, 3995, 3997, 3999, 4028, 4036, 4280, 4282, 4296, 4312, 4626, 4706, 5069, 4449, 4451, 4453, 4455, 5093, 5095, 5349, 6205, 6207, 6210, 6381, 1668, 1691, 6566, 7938, 8465, 8467, 8469, 8471, 8473, 8475, 8477, 8479, 8481, 8483, 8485, 8487, 8489, 8491, 8493, 8495, 8651, 8653, 8655, 8657, 8659, 8661, 8663, 8665, 8667, 8669, 8671, 8673, 8675, 8677, 8679, 8681, 8683, 8685, 8687, 8689, 8691, 8693, 8695, 8697, 8699, 8701, 8703, 8705, 8707, 8709, 8711, 8713, 8715, 8717, 8719, 8721, 8723, 8725, 8727, 8729, 8731, 8733, 8735, 8737, 8739, 8741, 8743, 8745, 8747, 8749, 8751, 8753, 8755, 8757, 8759, 8761, 8763, 8765, 8767, 8769, 8771, 8773, 8775, 8777, 1687, 1688, 1689, 1690, 1669, 1670, 1671, 1672, 9815, 9816, 10165, 10166, 10601, 10602, 10666, 10669, 10573, 10575, 10577, 10579, 10574, 10576, 10578, 10580};
        Arrays.sort(this.inserted_item_ids);
        this.reset(true);
    }

    protected void shutDown() throws Exception {
        log.info("No New Items stopped!");
        this.reset(true);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged change) {
        if (change.getGroup().equals("NoNewItems")) {
            boolean changes_player_visual = change.getKey().equals("hide_god_wars") || change.getKey().equals("hide_varrock_armour") || change.getKey().equals("hide_agility_cape") || change.getKey().equals("hide_land_of_the_goblins") || change.getKey().equals("hide_crystal_shield_and_bow");
            this.reset(changes_player_visual);
        }
    }

    public void hide_appearance(ItemComposition new_item) {
        new_item.setColorToReplace(this.all_colours);
        new_item.setColorToReplaceWith(this.new_colours);
        new_item.setTextureToReplace(this.all_textures);
        new_item.setTextureToReplaceWith(this.new_textures);
    }

    public void hide_item(ItemComposition new_item) {
        this.hide_appearance(new_item);
        if (this.config.hide_name()) {
            new_item.setName(this.config.new_name());
        }
    }

    public boolean is_a_new_item(int id) {
        if (id > 11685) {
            if (!this.config.hide_god_wars()) {
                boolean valid_god_wars_item;
                boolean bl = valid_god_wars_item = id >= 11787 && id < 11791 || id >= 11793 && id < 11847;
                if (valid_god_wars_item) {
                    return false;
                }
            }
            if (!(this.config.hide_varrock_armour() || id != 13104 && id != 18642)) {
                return false;
            }
            if (!this.config.hide_coin_pouches() && (id == 24703 || id >= 22521 && id <= 22538)) {
                return false;
            }
            if (!this.config.hide_bonds()) {
                boolean is_a_bond;
                boolean bl = is_a_bond = id == 13190 || id == 13191 || id == 13192 || id == 15430 || id == 15431;
                if (is_a_bond) {
                    return false;
                }
            }
            if (!this.config.hide_reward_caskets()) {
                boolean is_a_valid_clue_reward;
                boolean bl = is_a_valid_clue_reward = id == 20544 || id == 20545 || id == 20546;
                if (is_a_valid_clue_reward) {
                    return false;
                }
            }
            if (!this.config.hide_seed_nests()) {
                boolean is_a_new_seed_nest;
                boolean bl = is_a_new_seed_nest = id >= 22798 && id <= 22801;
                if (is_a_new_seed_nest) {
                    return false;
                }
            }
            if (!this.config.hide_agility_cape()) {
                boolean is_a_new_agility_cape;
                boolean bl = is_a_new_agility_cape = id == 13340 || id == 13341 || id == 14234 || id == 14235;
                if (is_a_new_agility_cape) {
                    return false;
                }
            }
            if (!this.config.hide_land_of_the_goblins()) {
                boolean is_from_lotg;
                boolean bl = is_from_lotg = id >= 26567 && id <= 26593;
                if (is_from_lotg) {
                    return false;
                }
            }
            if (!this.config.hide_crystal_shield_and_bow()) {
                boolean is_new_crystal_equip;
                boolean bl = is_new_crystal_equip = id == 16890 || id == 23991 || id == 23992 || id == 23993 || id == 23994 || id == 24127 || id == 24128 || id == 16888 || id == 23983 || id == 23984 || id == 23985 || id == 23986 || id == 24123 || id == 24124;
                if (is_new_crystal_equip) {
                    return false;
                }
            }
            if (!this.config.hide_path_of_glouphrie()) {
                boolean is_from_pog;
                boolean bl = is_from_pog = id >= 28573 && id <= 28590;
                if (is_from_pog) {
                    return false;
                }
            }
            return true;
        }
        if (id <= this.inserted_item_ids[this.inserted_item_ids.length - 1]) {
            for (int inserted_id : this.inserted_item_ids) {
                if (id < inserted_id) break;
                if (id != inserted_id) continue;
                return true;
            }
        }
        return false;
    }

    @Subscribe
    public void onPostItemComposition(PostItemComposition item_change) {
        ItemComposition new_item = item_change.getItemComposition();
        if (this.is_a_new_item(new_item.getId())) {
            this.hide_item(new_item);
        }
    }

    @Provides
    NoNewItemsConfig provideConfig(ConfigManager configManager) {
        return (NoNewItemsConfig)configManager.getConfig(NoNewItemsConfig.class);
    }
}

