/*
 * Decompiled with CFR 0.152.
 */
package com.leaguechatbroadcasts;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.IconID;
import net.runelite.api.clan.ClanChannel;
import net.runelite.api.clan.ClanChannelMember;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClanChannelChanged;
import net.runelite.api.events.ClanMemberJoined;
import net.runelite.api.events.ClanMemberLeft;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.WorldService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="League Chat Broadcasts")
public class LeagueChatBroadcastsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LeagueChatBroadcastsPlugin.class);
    private final Map<String, Set<String>> CLAN_MEMBER_NAMES = new HashMap<String, Set<String>>();
    private Set<Integer> LEAGUE_WORLDS = new HashSet<Integer>();
    @Inject
    private Client client;
    @Inject
    private WorldService worldService;

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN) {
            this.LEAGUE_WORLDS = this.worldService.getWorlds().getWorlds().stream().filter(world -> world.getTypes().contains(WorldType.SEASONAL)).map(World::getId).collect(Collectors.toSet());
        }
    }

    private List<ClanChannel> getClanChannels() {
        return Arrays.asList(this.client.getClanChannel(0), this.client.getGuestClanChannel(), this.client.getClanChannel(1));
    }

    private Set<String> getNamesOfMembers(ClanChannel channel) {
        return channel.getMembers().stream().map(ClanChannelMember::getName).map(Text::toJagexName).collect(Collectors.toSet());
    }

    @Subscribe
    public void onClanChannelChanged(ClanChannelChanged event) {
        List channels = this.getClanChannels().stream().filter(Objects::nonNull).collect(Collectors.toList());
        List channelNames = channels.stream().map(ClanChannel::getName).collect(Collectors.toList());
        for (String key : this.CLAN_MEMBER_NAMES.keySet()) {
            if (channelNames.contains(key)) continue;
            this.CLAN_MEMBER_NAMES.remove(key);
        }
        for (ClanChannel channel : channels) {
            this.CLAN_MEMBER_NAMES.put(channel.getName(), this.getNamesOfMembers(channel));
        }
    }

    @Subscribe
    public void onClanMemberJoined(ClanMemberJoined event) {
        String channelName = event.getClanChannel().getName();
        if (!this.CLAN_MEMBER_NAMES.containsKey(channelName)) {
            return;
        }
        this.CLAN_MEMBER_NAMES.get(channelName).add(event.getClanMember().getName());
    }

    @Subscribe
    public void onClanMemberLeft(ClanMemberLeft event) {
        String channelName = event.getClanChannel().getName();
        if (!this.CLAN_MEMBER_NAMES.containsKey(channelName)) {
            return;
        }
        this.CLAN_MEMBER_NAMES.get(channelName).remove(event.getClanMember().getName());
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        switch (event.getType()) {
            case CLAN_MESSAGE: 
            case CLAN_GIM_MESSAGE: 
            case CLAN_GUEST_MESSAGE: {
                break;
            }
            default: {
                return;
            }
        }
        Pattern expectedFormat = Pattern.compile("[\\w\\s]+:.*");
        String message = Text.sanitize((String)event.getMessage());
        Matcher regex = expectedFormat.matcher(message);
        if (!regex.matches()) {
            return;
        }
        HashSet allNames = new HashSet();
        this.CLAN_MEMBER_NAMES.values().forEach(allNames::addAll);
        Optional<String> possibleClanmateName = allNames.stream().filter(message::startsWith).findAny();
        if (!possibleClanmateName.isPresent()) {
            return;
        }
        String clanmateName = possibleClanmateName.get();
        Optional<String> possibleClanName = this.CLAN_MEMBER_NAMES.entrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(clanmateName)).map(Map.Entry::getKey).findAny();
        if (!possibleClanName.isPresent()) {
            return;
        }
        String clanName = possibleClanName.get();
        Optional<ClanChannel> possibleClan = this.getClanChannels().stream().filter(clanChannel -> clanChannel.getName().equals(clanName)).findAny();
        if (!possibleClan.isPresent()) {
            return;
        }
        ClanChannel clan = possibleClan.get();
        Optional<ClanChannelMember> possibleClanMember = clan.getMembers().stream().filter(clanMember -> clanMember.getName().equals(clanmateName)).findAny();
        if (!possibleClanMember.isPresent()) {
            return;
        }
        ClanChannelMember clanMember2 = possibleClanMember.get();
        if (this.LEAGUE_WORLDS.contains(clanMember2.getWorld())) {
            event.getMessageNode().setValue(IconID.LEAGUE + event.getMessage());
        }
    }
}

