/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.quickprayerpreview;

import io.hydrox.quickprayerpreview.Prayer;
import io.hydrox.quickprayerpreview.QuickPrayerPreviewOverlay;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Quick Prayer Preview", description="Preview your quick prayers by hovering over the orb", tags={"prayer", "quick prayer", "preview"})
public class QuickPrayerPreviewPlugin
extends Plugin {
    private static final int QUICK_PRAYER_VARBIT = 4102;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private QuickPrayerPreviewOverlay overlay;
    private List<Prayer> quickPrayers;
    private int quickPrayerVarb = -1;
    private final Map<Prayer, BufferedImage> prayerSprites = new HashMap<Prayer, BufferedImage>();

    public void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
    }

    public void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged e) {
        int varb = this.client.getVarbitValue(4102);
        if (varb == this.quickPrayerVarb) {
            return;
        }
        this.quickPrayerVarb = varb;
        this.quickPrayers = Prayer.fromVarb(varb);
        this.loadSprites();
    }

    private void loadSprites() {
        for (Prayer p : this.quickPrayers) {
            BufferedImage img = this.spriteManager.getSprite(p.getSpriteID(), 0);
            if (img == null) continue;
            BufferedImage norm = new BufferedImage(32, 32, 2);
            Graphics g = norm.getGraphics();
            g.drawImage(img, norm.getWidth() / 2 - img.getWidth() / 2, norm.getHeight() / 2 - img.getHeight() / 2, null);
            this.prayerSprites.put(p, norm);
        }
    }

    BufferedImage getSprite(Prayer p) {
        return this.prayerSprites.get((Object)p);
    }

    public List<Prayer> getQuickPrayers() {
        return this.quickPrayers;
    }
}

