/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.quickprayerpreview;

import io.hydrox.quickprayerpreview.Prayer;
import io.hydrox.quickprayerpreview.QuickPrayerPreviewPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.config.TooltipPositionType;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;

public class QuickPrayerPreviewOverlay
extends Overlay {
    private static final int UNDER_OFFSET = 24;
    private final Client client;
    private final QuickPrayerPreviewPlugin plugin;
    private final RuneLiteConfig runeLiteConfig;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    public QuickPrayerPreviewOverlay(Client client, QuickPrayerPreviewPlugin plugin, RuneLiteConfig runeLiteConfig) {
        this.client = client;
        this.plugin = plugin;
        this.runeLiteConfig = runeLiteConfig;
        this.setPosition(OverlayPosition.TOOLTIP);
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
        this.setPriority(OverlayPriority.HIGH);
        this.panelComponent.setOrientation(ComponentOrientation.HORIZONTAL);
    }

    public Dimension render(Graphics2D graphics) {
        int tooltipY;
        this.panelComponent.getChildren().clear();
        Widget orb = this.client.getWidget(WidgetInfo.MINIMAP_PRAYER_ORB);
        List<Prayer> prayers = this.plugin.getQuickPrayers();
        if (prayers == null || orb == null || orb.isHidden() || orb.isSelfHidden()) {
            return null;
        }
        Point mouseCanvasPosition = this.client.getMouseCanvasPosition();
        int canvasWidth = this.client.getCanvasWidth();
        int canvasHeight = this.client.getCanvasHeight();
        Rectangle prevBounds = this.getBounds();
        int tooltipX = Math.min(canvasWidth - prevBounds.width, mouseCanvasPosition.getX());
        int n = tooltipY = this.runeLiteConfig.tooltipPosition() == TooltipPositionType.UNDER_CURSOR ? Math.max(0, mouseCanvasPosition.getY() - 2 - prevBounds.height) : Math.min(canvasHeight - prevBounds.height, mouseCanvasPosition.getY() + 24);
        if (!orb.getBounds().contains(new java.awt.Point(mouseCanvasPosition.getX(), mouseCanvasPosition.getY()))) {
            return null;
        }
        this.panelComponent.setPreferredLocation(new java.awt.Point(tooltipX, tooltipY));
        for (Prayer p : prayers) {
            BufferedImage img = this.plugin.getSprite(p);
            if (img == null) continue;
            this.panelComponent.getChildren().add(new ImageComponent(img));
        }
        return this.panelComponent.render(graphics);
    }
}

