/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.quickprayerpreview;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

enum Prayer {
    THICK_SKIN(0, "Thick Skin", 115),
    BURST_OF_STRENGTH(1, "Burst of Strength", 116),
    CLARITY_OF_THOUGHT(2, "Clarity of Thought", 117),
    SHARP_EYE(18, "Sharp Eye", 133),
    MYSTIC_WILL(19, "Mystic Will", 134),
    ROCK_SKIN(3, "Rock Skin", 118),
    SUPERHUMAN_STRENGTH(4, "Superhuman Strength", 119),
    IMPROVED_REFLEXES(5, "Improved Reflexes", 120),
    RAPID_RESTORE(6, "Rapid Restore", 121),
    RAPID_HEAL(7, "Rapid Heal", 122),
    PROTECT_ITEM(8, "Protect Item", 123),
    HAWK_EYE(20, "Hawk Eye", 502),
    MYSTIC_LORE(21, "Mystic Lore", 503),
    STEEL_SKIN(9, "Steel Skin", 124),
    ULTIMATE_STRENGTH(10, "Ultimate Strength", 125),
    INCREDIBLE_REFLEXES(11, "Incredible reflexes", 126),
    PROTECT_FROM_MAGIC(12, "protect from magic", 127),
    PROTECT_FROM_MISSILES(13, "Protect from missiles", 128),
    PROTECT_FROM_MELEE(14, "Protect from melee", 129),
    EAGLE_EYE(22, "Eagle Eye", 504),
    MYSTIC_MIGHT(23, "Mystic Might", 505),
    RETRIBUTION(15, "Retribution", 131),
    REDEMPTION(16, "Redemption", 130),
    SMITE(17, "Smite", 132),
    PRESERVE(28, "Preserve", 947),
    CHIVALRY(25, "Chivalry", 945),
    PIETY(26, "Piety", 946),
    RIGOUR(24, "Rigour", 1420),
    AUGURY(27, "Augury", 1421);

    private final int bit;
    private final String name;
    private final int spriteID;
    private static final Map<Integer, Prayer> BITS;

    static List<Prayer> fromVarb(int varb) {
        ArrayList<Prayer> ret = new ArrayList<Prayer>();
        for (int i = 0; i < Prayer.values().length; ++i) {
            if ((varb & 1) == 1) {
                ret.add(BITS.get(i));
            }
            varb >>= 1;
        }
        return ret;
    }

    public int getBit() {
        return this.bit;
    }

    public String getName() {
        return this.name;
    }

    public int getSpriteID() {
        return this.spriteID;
    }

    private Prayer(int bit, String name, int spriteID) {
        this.bit = bit;
        this.name = name;
        this.spriteID = spriteID;
    }

    static {
        BITS = new HashMap<Integer, Prayer>();
        for (Prayer p : Prayer.values()) {
            BITS.put(p.bit, p);
        }
    }
}

