/*
 * Decompiled with CFR 0.152.
 */
package com.thatgamerblue.runelite.plugins.fakeiron;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.inject.Provides;
import com.thatgamerblue.runelite.plugins.fakeiron.FakeIronConfig;
import com.thatgamerblue.runelite.plugins.fakeiron.FakeIronIcons;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.IconID;
import net.runelite.api.IndexedSprite;
import net.runelite.api.events.BeforeRender;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Fake Ironman Icon", enabledByDefault=false)
public class FakeIronPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(FakeIronPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    private HashMap<FakeIronIcons, Integer> iconIds = new HashMap();
    private static List<String> players = new ArrayList<String>();
    private FakeIronIcons selectedIcon = null;
    @Inject
    private FakeIronConfig pluginConfig;
    private static final Splitter NEWLINE_SPLITTER = Splitter.on((String)"\n").omitEmptyStrings().trimResults();

    private void updateSelectedIcon() {
        if (this.selectedIcon != this.pluginConfig.icon()) {
            this.selectedIcon = this.pluginConfig.icon();
        }
    }

    @Provides
    FakeIronConfig getConfig(ConfigManager configManager) {
        return (FakeIronConfig)configManager.getConfig(FakeIronConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("fakeiron")) {
            if (this.pluginConfig.icon().isHeader()) {
                this.pluginConfig.icon(FakeIronIcons.valueOf(event.getOldValue()));
                return;
            }
            this.clientThread.invoke(() -> this.client.runScript(new Object[]{223}));
            players = NEWLINE_SPLITTER.splitToList((CharSequence)this.pluginConfig.otherPlayers().toLowerCase());
            this.updateSelectedIcon();
        }
    }

    public void startUp() {
        this.updateSelectedIcon();
        if (this.client.getModIcons() == null) {
            this.iconIds.clear();
            return;
        }
        this.loadSprites();
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.updateSelectedIcon();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        this.updateSelectedIcon();
        if (event.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (Stream.of(FakeIronIcons.values()).noneMatch(icon -> !Strings.isNullOrEmpty((String)icon.getImagePath()) && this.iconIds.getOrDefault(icon, IconID.NO_ENTRY.getIndex()).intValue() == IconID.NO_ENTRY.getIndex())) {
            return;
        }
        this.loadSprites();
    }

    private void loadSprites() {
        this.clientThread.invoke(() -> {
            IndexedSprite[] modIcons = this.client.getModIcons();
            ArrayList<IndexedSprite> newList = new ArrayList<IndexedSprite>();
            int modIconsStart = modIcons.length - 1;
            this.iconIds.put(FakeIronIcons.IRONMAN, IconID.IRONMAN.getIndex());
            this.iconIds.put(FakeIronIcons.ULTIMATE, IconID.ULTIMATE_IRONMAN.getIndex());
            this.iconIds.put(FakeIronIcons.HCIM, IconID.HARDCORE_IRONMAN.getIndex());
            this.iconIds.put(FakeIronIcons.GROUP, 41);
            this.iconIds.put(FakeIronIcons.HARDCORE_GROUP, 42);
            for (FakeIronIcons icon : FakeIronIcons.values()) {
                IndexedSprite sprite;
                if (Strings.isNullOrEmpty((String)icon.getImagePath())) continue;
                IndexedSprite indexedSprite = sprite = icon.isEmbedded() ? this.getIndexedSpriteEmbedded(icon.getImagePath()) : this.getIndexedSpriteFile(icon.getImagePath());
                if (sprite == null) continue;
                newList.add(sprite);
                this.iconIds.put(icon, ++modIconsStart);
            }
            IndexedSprite[] newAry = Arrays.copyOf(modIcons, modIcons.length + newList.size());
            System.arraycopy(newList.toArray(new IndexedSprite[0]), 0, newAry, modIcons.length, newList.size());
            this.client.setModIcons(newAry);
        });
    }

    public void shutDown() {
        this.iconIds.clear();
        this.clientThread.invoke(() -> this.client.runScript(new Object[]{223}));
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getName() == null || this.client.getLocalPlayer() == null || this.client.getLocalPlayer().getName() == null) {
            return;
        }
        boolean isLocalPlayer = Text.standardize((String)event.getName()).equalsIgnoreCase(Text.standardize((String)this.client.getLocalPlayer().getName()));
        if (isLocalPlayer || players.contains(Text.standardize((String)event.getName().toLowerCase()))) {
            event.getMessageNode().setName(this.getImgTag(this.iconIds.getOrDefault((Object)this.selectedIcon, IconID.NO_ENTRY.getIndex())) + Text.removeTags((String)event.getName()));
        }
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        if (!event.getEventName().equals("setChatboxInput")) {
            return;
        }
        this.updateChatbox();
    }

    @Subscribe
    public void onBeforeRender(BeforeRender event) {
        this.updateChatbox();
    }

    private void updateChatbox() {
        Widget chatboxTypedText = this.client.getWidget(WidgetInfo.CHATBOX_INPUT);
        if (this.getIconIdx() == -1) {
            return;
        }
        if (chatboxTypedText == null || chatboxTypedText.isHidden()) {
            return;
        }
        String[] chatbox = chatboxTypedText.getText().split(":", 2);
        String rsn = Objects.requireNonNull(this.client.getLocalPlayer()).getName();
        chatboxTypedText.setText(this.getImgTag(this.getIconIdx()) + Text.removeTags((String)rsn) + ":" + chatbox[1]);
    }

    private IndexedSprite getIndexedSpriteEmbedded(String file) {
        try {
            log.debug("Loading: {}", (Object)file);
            BufferedImage image = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)file);
            return ImageUtil.getImageIndexedSprite((BufferedImage)image, (Client)this.client);
        }
        catch (RuntimeException ex) {
            log.debug("Unable to load image: ", (Throwable)ex);
            return null;
        }
    }

    private IndexedSprite getIndexedSpriteFile(String file) {
        try {
            log.debug("Loading: {}", (Object)file);
            BufferedImage image = ImageIO.read(new File(RuneLite.RUNELITE_DIR, file));
            return ImageUtil.getImageIndexedSprite((BufferedImage)image, (Client)this.client);
        }
        catch (IOException | RuntimeException ex) {
            log.debug("Unable to load image: ", (Throwable)ex);
            return null;
        }
    }

    private String getImgTag(int i) {
        return "<img=" + i + ">";
    }

    private int getIconIdx() {
        if (this.selectedIcon == null) {
            this.updateSelectedIcon();
        }
        return this.iconIds.getOrDefault((Object)this.selectedIcon, IconID.NO_ENTRY.getIndex());
    }

    public Client getClient() {
        return this.client;
    }

    public static List<String> getPlayers() {
        return players;
    }

    public FakeIronConfig getPluginConfig() {
        return this.pluginConfig;
    }
}

