/*
 * Decompiled with CFR 0.152.
 */
package melky.worldflags;

import com.google.common.collect.ImmutableMap;
import java.awt.image.BufferedImage;
import java.util.Map;
import net.runelite.client.util.ImageUtil;

enum WorldRegionFlag {
    FLAG_US(0),
    FLAG_GB(1),
    FLAG_AU(3),
    FLAG_DE(7);

    private static final Map<Integer, WorldRegionFlag> worldRegionMap;
    private final int regionId;

    private WorldRegionFlag(int regionId) {
        this.regionId = regionId;
    }

    BufferedImage loadImage() {
        return ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)("/" + this.name().toLowerCase() + ".png"));
    }

    static WorldRegionFlag getByRegionId(int regionId) {
        return worldRegionMap.get(regionId);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (WorldRegionFlag worldRegion : WorldRegionFlag.values()) {
            builder.put((Object)worldRegion.regionId, (Object)worldRegion);
        }
        worldRegionMap = builder.build();
    }
}

