/*
 * Decompiled with CFR 0.152.
 */
package melky.worldflags;

import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.inject.Inject;
import melky.worldflags.WorldFlagsConfig;
import melky.worldflags.WorldFlagsMode;
import melky.worldflags.WorldRegionFlag;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.IndexedSprite;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.WorldService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="World country flags")
public class WorldFlagsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WorldFlagsPlugin.class);
    private int modIconsStart = -1;
    @Inject
    private Client client;
    @Inject
    private WorldService worldService;
    @Inject
    private ClientThread clientThread;
    @Inject
    private WorldFlagsConfig config;

    @Provides
    WorldFlagsConfig provideConfig(ConfigManager configManager) {
        return (WorldFlagsConfig)configManager.getConfig(WorldFlagsConfig.class);
    }

    protected void startUp() throws Exception {
        this.clientThread.invoke(() -> {
            this.loadRegionIcons();
            for (WorldFlagsMode flagMode : WorldFlagsMode.values()) {
                this.toggleWorldsToFlags(flagMode);
            }
        });
    }

    protected void shutDown() throws Exception {
        this.clientThread.invoke(() -> {
            for (WorldFlagsMode flagMode : WorldFlagsMode.values()) {
                this.toggleWorldsToFlags(flagMode, true);
            }
        });
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.clientThread.invoke(this::loadRegionIcons);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("worldflags")) {
            return;
        }
        switch (event.getKey()) {
            case "showClanFlags": {
                this.clientThread.invoke(() -> this.toggleWorldsToFlags(WorldFlagsMode.CHAT_CHANNEL));
                break;
            }
            case "showClanChannelFlags": {
                this.clientThread.invoke(() -> this.toggleWorldsToFlags(WorldFlagsMode.CLAN_CHANNEL));
                break;
            }
            case "showGuestChannelFlags": {
                this.clientThread.invoke(() -> this.toggleWorldsToFlags(WorldFlagsMode.GUEST_CHANNEL));
                break;
            }
            case "showFriendsFlags": {
                this.clientThread.invoke(() -> this.toggleWorldsToFlags(WorldFlagsMode.FRIENDS));
            }
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        WorldFlagsMode flagsMode = WorldFlagsMode.byScriptID.getOrDefault(event.getScriptId(), null);
        if (flagsMode != null) {
            this.clientThread.invoke(() -> this.toggleWorldsToFlags(flagsMode));
        }
    }

    private void loadRegionIcons() {
        IndexedSprite[] modIcons = this.client.getModIcons();
        if (this.modIconsStart != -1 || modIcons == null) {
            return;
        }
        WorldRegionFlag[] worldRegions = WorldRegionFlag.values();
        IndexedSprite[] newModIcons = Arrays.copyOf(modIcons, modIcons.length + worldRegions.length);
        this.modIconsStart = modIcons.length;
        for (int i = 0; i < worldRegions.length; ++i) {
            IndexedSprite sprite;
            WorldRegionFlag worldRegion = worldRegions[i];
            BufferedImage image = worldRegion.loadImage();
            newModIcons[this.modIconsStart + i] = sprite = ImageUtil.getImageIndexedSprite((BufferedImage)image, (Client)this.client);
        }
        log.debug("Loaded region icons");
        this.client.setModIcons(newModIcons);
    }

    private void toggleWorldsToFlags(WorldFlagsMode flagMode) {
        this.toggleWorldsToFlags(flagMode, false);
    }

    private void toggleWorldsToFlags(WorldFlagsMode flagMode, boolean forceDisable) {
        Widget containerWidget = this.client.getWidget(flagMode.getContainerWidget());
        if (containerWidget == null || containerWidget.getChildren() == null) {
            return;
        }
        boolean flagsEnable = false;
        switch (flagMode) {
            case CHAT_CHANNEL: {
                flagsEnable = this.config.showClanFlags();
                break;
            }
            case CLAN_CHANNEL: {
                flagsEnable = this.config.showClanChannelFlags();
                break;
            }
            case GUEST_CHANNEL: {
                flagsEnable = this.config.showGuestChannelFlags();
                break;
            }
            case FRIENDS: {
                flagsEnable = this.config.showFriendsFlags();
            }
        }
        if (forceDisable || !flagsEnable) {
            this.changeFlagsToWorlds(containerWidget, flagMode);
        } else {
            this.changeWorldsToFlags(containerWidget, flagMode);
        }
    }

    private void changeWorldsToFlags(Widget containerWidget, WorldFlagsMode flagMode) {
        WorldResult worldResult = this.worldService.getWorlds();
        for (int i = flagMode.getWidgetStartPosition() + this.amountOfChildrenToSkip(containerWidget, flagMode); i < containerWidget.getChildren().length; i += 3) {
            int worldNumber;
            World targetPlayerWorld;
            String regex;
            Widget listWidget = containerWidget.getChild(i);
            String worldString = Text.removeTags((String)listWidget.getText());
            if (!worldString.matches(regex = flagMode.getWorldMatchRegex()) || (targetPlayerWorld = worldResult.findWorld(worldNumber = Integer.parseInt(worldString = worldString.replace(flagMode.getWorldReplaceRegex(), "")))) == null) continue;
            int worldRegionId = targetPlayerWorld.getLocation();
            int regionModIconId = WorldRegionFlag.getByRegionId(worldRegionId).ordinal() + this.modIconsStart;
            listWidget.setText(worldString + " <img=" + regionModIconId + ">");
        }
    }

    private void changeFlagsToWorlds(Widget containerWidget, WorldFlagsMode flagMode) {
        for (int i = flagMode.getWidgetStartPosition() + this.amountOfChildrenToSkip(containerWidget, flagMode); i < containerWidget.getChildren().length; i += 3) {
            Widget listWidget = containerWidget.getChild(i);
            String worldString = this.removeColorTags(listWidget.getText());
            if (!worldString.matches("^\\d+\\s?<img=\\d+>$") || !listWidget.getName().equals("")) continue;
            String worldNum = listWidget.getText().replaceAll("\\s?<img=\\d+>$", "");
            listWidget.setText(flagMode.getWorldReplaceRegex() + worldNum);
        }
    }

    private int amountOfChildrenToSkip(Widget containerWidget, WorldFlagsMode flagMode) {
        int additionalChildren = 0;
        if (flagMode == WorldFlagsMode.CLAN_CHANNEL || flagMode == WorldFlagsMode.GUEST_CHANNEL) {
            for (int i = 0; i < containerWidget.getChildren().length; ++i) {
                if (containerWidget.getChild(i).getType() == 3) continue;
                additionalChildren = containerWidget.getChild(i).getIndex();
                break;
            }
        }
        return additionalChildren;
    }

    private String removeColorTags(String text) {
        return text.replaceAll("<(/)?col(=([0-9]|[a-z]){6})*>", "");
    }
}

