/*
 * Decompiled with CFR 0.152.
 */
package melky.worldflags;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import net.runelite.api.widgets.WidgetInfo;

public enum WorldFlagsMode {
    CHAT_CHANNEL(1658, WidgetInfo.FRIENDS_CHAT_LIST, 1, "^W[0-9]{1,3}\\b", "W"),
    CLAN_CHANNEL(4397, WidgetInfo.CLAN_MEMBER_LIST, 1, "^W[0-9]{1,3}\\b", "W"),
    GUEST_CHANNEL(4399, WidgetInfo.CLAN_GUEST_MEMBER_LIST, 1, "^W[0-9]{1,3}\\b", "W"),
    FRIENDS(631, WidgetInfo.FRIEND_LIST_NAMES_CONTAINER, 2, "^World\\s[0-9]{1,3}\\b", "World ");

    private final int scriptID;
    private final WidgetInfo containerWidget;
    private final int widgetStartPosition;
    private final String worldMatchRegex;
    private final String worldReplaceRegex;
    public static final Map<Integer, WorldFlagsMode> byScriptID;

    public int getScriptID() {
        return this.scriptID;
    }

    public WidgetInfo getContainerWidget() {
        return this.containerWidget;
    }

    public int getWidgetStartPosition() {
        return this.widgetStartPosition;
    }

    public String getWorldMatchRegex() {
        return this.worldMatchRegex;
    }

    public String getWorldReplaceRegex() {
        return this.worldReplaceRegex;
    }

    private WorldFlagsMode(int scriptID, WidgetInfo containerWidget, int widgetStartPosition, String worldMatchRegex, String worldReplaceRegex) {
        this.scriptID = scriptID;
        this.containerWidget = containerWidget;
        this.widgetStartPosition = widgetStartPosition;
        this.worldMatchRegex = worldMatchRegex;
        this.worldReplaceRegex = worldReplaceRegex;
    }

    static {
        byScriptID = Maps.uniqueIndex(Arrays.asList(WorldFlagsMode.values()), WorldFlagsMode::getScriptID);
    }
}

