/*
 * Decompiled with CFR 0.152.
 */
package com.andmcadams.gloopylite;

import com.andmcadams.gloopylite.GloopyLiteConfig;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Provides;
import java.awt.Color;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.IconID;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ChatColorConfig;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.LinkBrowser;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="GloopyLite")
public class GloopyLitePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GloopyLitePlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ChatColorConfig chatColorConfig;
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private GloopyLiteConfig config;
    final String QUERY_STRING_TAG = "query";
    final Pattern GLOOPY_PATTERN = Pattern.compile("\\[\\[([^#<>\\[\\]{|}]*?)]]");
    final Pattern LINK_PATTERN = Pattern.compile("<query=([^#<>\\[\\]{|}]*?)>");
    final String GLOOPY_MESSAGE_PATTERN = "(<query=.[^#<>\\[\\]{|}]*?>)<col=[a-f0-9]+?><u=[a-f0-9]+?>";
    boolean hideMenuEntries = false;
    final ImmutableMap<ChatMessageType, ChatMessageType> CHAT_MAP = ImmutableMap.builder().put((Object)ChatMessageType.FRIENDSCHAT, (Object)ChatMessageType.FRIENDSCHATNOTIFICATION).put((Object)ChatMessageType.CLAN_CHAT, (Object)ChatMessageType.CLAN_MESSAGE).put((Object)ChatMessageType.CLAN_GUEST_CHAT, (Object)ChatMessageType.CLAN_GUEST_MESSAGE).put((Object)ChatMessageType.CLAN_GIM_CHAT, (Object)ChatMessageType.CLAN_GIM_MESSAGE).build();

    protected void startUp() throws Exception {
        log.info("GloopyLite started!");
        this.addListenersToChatbox();
    }

    protected void shutDown() throws Exception {
        log.info("GloopyLite stopped!");
        this.removeListenersFromChatbox();
    }

    private void sendLinkMessage(String chatMessage, String link, ChatMessageType t) {
        String color = ColorUtil.colorToHexCode((Color)this.config.textColor());
        String message = new ChatMessageBuilder().append(chatMessage).build();
        StringBuilder taggedMessage = new StringBuilder();
        taggedMessage.append(IconID.CHAIN_LINK).append("<").append("query").append("=").append(link).append(">").append("<col=").append(color).append(">").append("<u=").append(color).append(">").append(message).append("</u></col>");
        this.chatMessageManager.queue(QueuedMessage.builder().type(t).runeLiteFormattedMessage(taggedMessage.toString()).build());
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.client.isMenuOpen()) {
            return;
        }
        if (this.hideMenuEntries) {
            this.hideMenuEntries = false;
            this.client.setMenuEntries(new MenuEntry[0]);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        ChatMessageType t = (ChatMessageType)this.CHAT_MAP.get((Object)chatMessage.getType());
        if (t == null) {
            t = ChatMessageType.CONSOLE;
        }
        String message = chatMessage.getMessage();
        Matcher m = this.GLOOPY_PATTERN.matcher(message);
        while (m.find()) {
            String searchString = m.group(1).trim();
            if (searchString.isEmpty()) {
                return;
            }
            log.debug("Creating a link for the search string: " + searchString);
            this.sendLinkMessage("Search the wiki for \"" + searchString + "\"", searchString, t);
        }
    }

    private void toggleHighlight(Widget w, boolean shouldHighlight) {
        String text = w.getText();
        String colorHex = ColorUtil.colorToHexCode((Color)(shouldHighlight ? this.config.highlightTextColor() : this.config.textColor()));
        Matcher m = this.LINK_PATTERN.matcher(text);
        if (m.find()) {
            String newText = w.getText().replaceFirst("(<query=.[^#<>\\[\\]{|}]*?>)<col=[a-f0-9]+?><u=[a-f0-9]+?>", "$1<col=" + colorHex + "><u=" + colorHex + ">");
            w.setText(newText);
        }
    }

    private void onClick(Widget w) {
        String text;
        Matcher m;
        if ((!this.config.requireControlClick() || this.client.isKeyPressed(82)) && (m = this.LINK_PATTERN.matcher(text = w.getText())).find()) {
            this.openLinkInBrowser(m.group(1));
        }
    }

    private void openLinkInBrowser(String searchString) {
        try {
            String wikiUrlEncodedQuery = URLEncoder.encode(searchString.trim(), StandardCharsets.UTF_8.toString());
            String url = "https://oldschool.runescape.wiki/?search=" + wikiUrlEncodedQuery + "&title=Special%3ASearch";
            LinkBrowser.browse((String)url);
            log.debug("Going to " + url + "...");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Error encoding string", (Throwable)e);
        }
    }

    private void maybeHideMenuEntries(Widget w) {
        Matcher m;
        if ((!this.config.requireControlClick() || this.client.isKeyPressed(82)) && (m = this.LINK_PATTERN.matcher(w.getText())).find()) {
            this.hideMenuEntries = !this.config.requireControlClick() || this.client.isKeyPressed(82);
        }
    }

    private void addListenersToChatWidget(Widget w) {
        w.setOnMouseRepeatListener(new Object[]{ev -> this.maybeHideMenuEntries(w)});
        w.setOnMouseOverListener(new Object[]{ev -> this.toggleHighlight(w, true)});
        w.setOnMouseLeaveListener(new Object[]{ev -> this.toggleHighlight(w, false)});
        w.setOnClickListener(new Object[]{ev -> this.onClick(w)});
        w.setHasListener(true);
    }

    private void addListenersToChatbox() {
        Widget chatbox = this.client.getWidget(WidgetInfo.CHATBOX_MESSAGE_LINES);
        if (chatbox == null || chatbox.getDynamicChildren() == null) {
            return;
        }
        for (int i = 0; i < chatbox.getDynamicChildren().length; i += 4) {
            Widget w = chatbox.getDynamicChildren()[i];
            this.addListenersToChatWidget(w);
            Widget w2 = chatbox.getDynamicChildren()[i + 1];
            this.addListenersToChatWidget(w2);
        }
    }

    private void removeListenersFromChatWidget(Widget w) {
        w.setOnMouseOverListener((Object[])null);
        w.setOnMouseLeaveListener((Object[])null);
        w.setOnClickListener((Object[])null);
        w.setHasListener(false);
    }

    private void removeListenersFromChatbox() {
        Widget chatbox = this.client.getWidget(WidgetInfo.CHATBOX_MESSAGE_LINES);
        if (chatbox == null || chatbox.getDynamicChildren() == null) {
            return;
        }
        for (int i = 0; i < chatbox.getDynamicChildren().length; i += 4) {
            Widget w = chatbox.getDynamicChildren()[i];
            this.removeListenersFromChatWidget(w);
            Widget w2 = chatbox.getDynamicChildren()[i + 1];
            this.removeListenersFromChatWidget(w2);
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        int id = widgetLoaded.getGroupId();
        if (id == 162) {
            this.addListenersToChatbox();
        }
    }

    @Provides
    GloopyLiteConfig provideConfig(ConfigManager configManager) {
        return (GloopyLiteConfig)configManager.getConfig(GloopyLiteConfig.class);
    }
}

