/*
 * Decompiled with CFR 0.152.
 */
package io.github.deathbeam.plugins.fixedhidechat;

import io.github.deathbeam.plugins.fixedhidechat.FixedHideChatConstants;
import java.awt.event.KeyEvent;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.BeforeRender;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Fixed Mode Hide Chat", description="Hides chatbox in fixed mode and expands the view")
public class FixedHideChatPlugin
extends Plugin
implements KeyListener {
    private static final Logger log = LoggerFactory.getLogger(FixedHideChatPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private KeyManager keyManager;
    private int lastMenu = 0;
    private boolean hideChat = true;

    protected void startUp() throws Exception {
        this.keyManager.registerKeyListener((KeyListener)this);
    }

    protected void shutDown() throws Exception {
        this.keyManager.unregisterKeyListener((KeyListener)this);
        this.hideChat = true;
        this.lastMenu = 0;
        this.clientThread.invoke(this::resetWidgets);
    }

    public void keyTyped(KeyEvent e) {
        this.keyReleased(e);
    }

    public void keyPressed(KeyEvent e) {
        this.keyReleased(e);
    }

    public void keyReleased(KeyEvent e) {
        if (!this.client.isResized() && e.getKeyCode() == 27 && !this.hideChat) {
            this.hideChat = true;
            e.consume();
        }
    }

    @Subscribe
    public void onBeforeRender(BeforeRender event) {
        if (this.client.isResized()) {
            return;
        }
        Widget bankWidget = this.client.getWidget(WidgetInfo.BANK_CONTAINER);
        if (bankWidget != null && !bankWidget.isSelfHidden()) {
            bankWidget.setRelativeX(12);
            bankWidget.setRelativeY(2);
        }
        this.setViewSizeTo(334, 476);
        Widget chatboxMessages = this.client.getWidget(WidgetInfo.CHATBOX);
        if (chatboxMessages != null) {
            boolean found;
            boolean bl = found = !this.hideChat;
            if (!found) {
                for (Map.Entry<Integer, Integer> widgetInfo : FixedHideChatConstants.AUTO_EXPAND_WIDGETS) {
                    Widget widget = this.client.getWidget(widgetInfo.getKey().intValue(), widgetInfo.getValue().intValue());
                    if (widget == null || widget.isSelfHidden()) continue;
                    found = true;
                    break;
                }
            }
            this.setWidgetsSizeTo(found ? 476 : 334, found ? 334 : 476);
            chatboxMessages.setHidden(!found);
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (!"Switch tab".equals(event.getMenuOption())) {
            return;
        }
        Widget chatboxMessages = this.client.getWidget(WidgetInfo.CHATBOX);
        int newMenu = event.getWidgetId();
        this.hideChat = true;
        if (newMenu != this.lastMenu || chatboxMessages != null && chatboxMessages.isHidden()) {
            this.hideChat = false;
            this.lastMenu = newMenu;
        }
    }

    private static void changeWidgetHeight(int originalHeight, int newHeight, Widget widget) {
        if (widget.getHeight() == originalHeight) {
            Widget[] dynamicChildren;
            widget.setHeight(newHeight);
            Widget[] nestedChildren = widget.getNestedChildren();
            if (nestedChildren != null) {
                for (Widget nestedChild : nestedChildren) {
                    if (nestedChild.getHeight() != originalHeight) continue;
                    nestedChild.setHeight(newHeight);
                }
            }
            if ((dynamicChildren = widget.getDynamicChildren()) != null) {
                for (Widget child : dynamicChildren) {
                    if (child.getHeight() != originalHeight) continue;
                    child.setHeight(newHeight);
                }
            }
        }
    }

    private void setWidgetsSizeTo(int originalHeight, int newHeight) {
        for (Map.Entry<Integer, Integer> widgetInfo : FixedHideChatConstants.TO_CONTRACT_WIDGETS) {
            Widget widget = this.client.getWidget(widgetInfo.getKey().intValue(), widgetInfo.getValue().intValue());
            if (widget == null || widget.isSelfHidden()) continue;
            FixedHideChatPlugin.changeWidgetHeight(originalHeight, newHeight, widget);
        }
    }

    private void setViewSizeTo(int originalHeight, int newHeight) {
        Widget fixedMain;
        Widget viewport = this.client.getWidget(WidgetInfo.FIXED_VIEWPORT);
        if (viewport != null) {
            viewport.setHeight(newHeight);
        }
        if ((fixedMain = this.client.getWidget(FixedHideChatConstants.FIXED_MAIN.getKey().intValue(), FixedHideChatConstants.FIXED_MAIN.getValue().intValue())) != null && fixedMain.getHeight() == originalHeight) {
            Widget[] staticChildren;
            fixedMain.setHeight(newHeight);
            for (Widget child : staticChildren = fixedMain.getStaticChildren()) {
                FixedHideChatPlugin.changeWidgetHeight(originalHeight, newHeight, child);
            }
        }
    }

    private void resetWidgets() {
        if (this.client.isResized()) {
            return;
        }
        this.setViewSizeTo(476, 334);
        this.setWidgetsSizeTo(476, 334);
        Widget chatboxMessages = this.client.getWidget(WidgetInfo.CHATBOX);
        if (chatboxMessages != null) {
            chatboxMessages.setHidden(false);
        }
    }
}

