/*
 * Decompiled with CFR 0.152.
 */
package blue.warner.proximityscape;

import blue.warner.proximityscape.ProximityScapeConfig;
import com.google.inject.Provides;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;

@PluginDescriptor(name="ProximityScape - Discord", description="Proximity chat for RuneScape", tags={"discord", "chat", "proximity", "chunk", "vc"})
public class ProximityScapePlugin
extends Plugin {
    public Socket socket;
    @Inject
    private Client client;
    @Inject
    private ProximityScapeConfig config;
    private ScheduledExecutorService ses;

    protected void startUp() {
        if (this.config.ClientID() == "") {
            this.client.addChatMessage(ChatMessageType.MODCHAT, "[ProximityScape]", "No ClientID specified.", "");
            return;
        }
        this.socket = null;
        this.ses = Executors.newSingleThreadScheduledExecutor();
        this.ses.scheduleAtFixedRate(() -> {
            block10: {
                if (this.socket == null && !this.config.ClientID().equals("")) {
                    try {
                        this.socket = new Socket("143.198.107.197", 4999);
                        if (this.client.getGameState().equals((Object)GameState.LOGGED_IN)) {
                            this.client.addChatMessage(ChatMessageType.MODCHAT, "[ProximityScape]", "Connected to Socket.", "");
                        }
                    }
                    catch (IOException e) {
                        if (!this.client.getGameState().equals((Object)GameState.LOGGED_IN)) break block10;
                        this.client.addChatMessage(ChatMessageType.MODCHAT, "[ProximityScape]", "Failed to connect to the Socket, report this to warnerBlue.", "");
                    }
                }
            }
            if (!this.config.ClientID().equals("") && this.client.getGameState().equals((Object)GameState.LOGGED_IN)) {
                try {
                    PrintWriter printWriter = new PrintWriter(this.socket.getOutputStream());
                    printWriter.println(this.config.ClientID() + ":" + this.client.getWorld() + ":" + this.client.getLocalPlayer().getWorldLocation().getRegionID());
                    printWriter.flush();
                }
                catch (Exception printWriter) {}
            } else {
                try {
                    PrintWriter printWriter = new PrintWriter(this.socket.getOutputStream());
                    printWriter.println(this.config.ClientID() + ":LOGGED_OUT");
                    printWriter.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, 0L, 600L, TimeUnit.MILLISECONDS);
    }

    protected void shutDown() {
        try {
            PrintWriter printWriter = new PrintWriter(this.socket.getOutputStream());
            printWriter.println("QUIT");
            printWriter.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
        if (this.ses != null) {
            this.ses.shutdown();
        }
    }

    @Provides
    public ProximityScapeConfig provideConfig(ConfigManager configManager) {
        return (ProximityScapeConfig)configManager.getConfig(ProximityScapeConfig.class);
    }
}

