/*
 * Decompiled with CFR 0.152.
 */
package com.iplank.fakestats;

import com.google.inject.Provides;
import com.iplank.fakestats.CachedConfig;
import com.iplank.fakestats.FakeStatsConfig;
import java.text.NumberFormat;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.api.events.ClientTick;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.PluginChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Fake Stats", description="Allows you to spoof Skill and Total Levels", tags={"stats", "spoof", "fake", "skills", "total"}, conflicts={"Virtual Levels", "Effective Levels"}, enabledByDefault=false)
public class FakeStatsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(FakeStatsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private FakeStatsConfig config;
    @Inject
    private ClientThread clientThread;
    private CachedConfig cachedConfig = new CachedConfig();
    private static final String TOTAL_LEVEL_TEXT_PREFIX = "Total level:<br>";

    protected void startUp() throws Exception {
        this.cachedConfig.setConfig(this.config);
        this.cachedConfig.cacheValues();
        log.info("Fake Stats started!");
    }

    protected void shutDown() throws Exception {
        this.clientThread.invoke(this::simulateSkillChange);
        log.info("Fake Stats stopped!");
    }

    @Subscribe
    public void onPluginChanged(PluginChanged pluginChanged) {
        if (pluginChanged.getPlugin() == this) {
            this.cachedConfig.cacheValues();
            this.clientThread.invoke(this::simulateSkillChange);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals("fakestats")) {
            return;
        }
        this.cachedConfig.cacheValues();
        this.clientThread.invoke(this::simulateSkillChange);
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        Widget[] skillWidgetComponents;
        Widget skillWidget;
        if (this.cachedConfig.spoofAttack) {
            skillWidget = this.client.getWidget(320, 1);
            if (skillWidget == null) {
                return;
            }
            skillWidgetComponents = skillWidget.getDynamicChildren();
            if (skillWidgetComponents.length >= 4) {
                if (this.cachedConfig.attackLevel > 99) {
                    if (this.cachedConfig.virtualLevels) {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("" + this.cachedConfig.attackLevel);
                    } else {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("99");
                    }
                } else {
                    skillWidgetComponents[3].setText("" + this.cachedConfig.attackLevel);
                    skillWidgetComponents[4].setText("" + this.cachedConfig.attackLevel);
                }
            }
        }
        if (this.cachedConfig.spoofStrength) {
            skillWidget = this.client.getWidget(320, 2);
            if (skillWidget == null) {
                return;
            }
            skillWidgetComponents = skillWidget.getDynamicChildren();
            if (skillWidgetComponents.length >= 4) {
                if (this.cachedConfig.strengthLevel > 99) {
                    if (this.cachedConfig.virtualLevels) {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("" + this.cachedConfig.strengthLevel);
                    } else {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("99");
                    }
                } else {
                    skillWidgetComponents[3].setText("" + this.cachedConfig.strengthLevel);
                    skillWidgetComponents[4].setText("" + this.cachedConfig.strengthLevel);
                }
            }
        }
        if (this.cachedConfig.spoofDefence) {
            skillWidget = this.client.getWidget(320, 3);
            if (skillWidget == null) {
                return;
            }
            skillWidgetComponents = skillWidget.getDynamicChildren();
            if (skillWidgetComponents.length >= 4) {
                if (this.cachedConfig.defenceLevel > 99) {
                    if (this.cachedConfig.virtualLevels) {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("" + this.cachedConfig.defenceLevel);
                    } else {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("99");
                    }
                } else {
                    skillWidgetComponents[3].setText("" + this.cachedConfig.defenceLevel);
                    skillWidgetComponents[4].setText("" + this.cachedConfig.defenceLevel);
                }
            }
        }
        if (this.cachedConfig.spoofRanged) {
            skillWidget = this.client.getWidget(320, 4);
            if (skillWidget == null) {
                return;
            }
            skillWidgetComponents = skillWidget.getDynamicChildren();
            if (skillWidgetComponents.length >= 4) {
                if (this.cachedConfig.rangedLevel > 99) {
                    if (this.cachedConfig.virtualLevels) {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("" + this.cachedConfig.rangedLevel);
                    } else {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("99");
                    }
                } else {
                    skillWidgetComponents[3].setText("" + this.cachedConfig.rangedLevel);
                    skillWidgetComponents[4].setText("" + this.cachedConfig.rangedLevel);
                }
            }
        }
        if (this.cachedConfig.spoofPrayer) {
            skillWidget = this.client.getWidget(320, 5);
            if (skillWidget == null) {
                return;
            }
            skillWidgetComponents = skillWidget.getDynamicChildren();
            if (skillWidgetComponents.length >= 4) {
                if (this.cachedConfig.prayerLevel > 99) {
                    if (this.cachedConfig.virtualLevels) {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("" + this.cachedConfig.prayerLevel);
                    } else {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("99");
                    }
                } else {
                    skillWidgetComponents[3].setText("" + this.cachedConfig.prayerLevel);
                    skillWidgetComponents[4].setText("" + this.cachedConfig.prayerLevel);
                }
            }
        }
        if (this.cachedConfig.spoofMagic) {
            skillWidget = this.client.getWidget(320, 6);
            if (skillWidget == null) {
                return;
            }
            skillWidgetComponents = skillWidget.getDynamicChildren();
            if (skillWidgetComponents.length >= 4) {
                if (this.cachedConfig.magicLevel > 99) {
                    if (this.cachedConfig.virtualLevels) {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("" + this.cachedConfig.magicLevel);
                    } else {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("99");
                    }
                } else {
                    skillWidgetComponents[3].setText("" + this.cachedConfig.magicLevel);
                    skillWidgetComponents[4].setText("" + this.cachedConfig.magicLevel);
                }
            }
        }
        if (this.cachedConfig.spoofRunecraft) {
            skillWidget = this.client.getWidget(320, 7);
            if (skillWidget == null) {
                return;
            }
            skillWidgetComponents = skillWidget.getDynamicChildren();
            if (skillWidgetComponents.length >= 4) {
                if (this.cachedConfig.runecraftLevel > 99) {
                    if (this.cachedConfig.virtualLevels) {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("" + this.cachedConfig.runecraftLevel);
                    } else {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("99");
                    }
                } else {
                    skillWidgetComponents[3].setText("" + this.cachedConfig.runecraftLevel);
                    skillWidgetComponents[4].setText("" + this.cachedConfig.runecraftLevel);
                }
            }
        }
        if (this.cachedConfig.spoofConstruction) {
            skillWidget = this.client.getWidget(320, 8);
            if (skillWidget == null) {
                return;
            }
            skillWidgetComponents = skillWidget.getDynamicChildren();
            if (skillWidgetComponents.length >= 4) {
                if (this.cachedConfig.constructionLevel > 99) {
                    if (this.cachedConfig.virtualLevels) {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("" + this.cachedConfig.constructionLevel);
                    } else {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("99");
                    }
                } else {
                    skillWidgetComponents[3].setText("" + this.cachedConfig.constructionLevel);
                    skillWidgetComponents[4].setText("" + this.cachedConfig.constructionLevel);
                }
            }
        }
        if (this.cachedConfig.spoofHitpoints) {
            skillWidget = this.client.getWidget(320, 9);
            if (skillWidget == null) {
                return;
            }
            skillWidgetComponents = skillWidget.getDynamicChildren();
            if (skillWidgetComponents.length >= 4) {
                if (this.cachedConfig.hitpointsLevel > 99) {
                    if (this.cachedConfig.virtualLevels) {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("" + this.cachedConfig.hitpointsLevel);
                    } else {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("99");
                    }
                } else {
                    skillWidgetComponents[3].setText("" + this.cachedConfig.hitpointsLevel);
                    skillWidgetComponents[4].setText("" + this.cachedConfig.hitpointsLevel);
                }
            }
        }
        if (this.cachedConfig.spoofAgility) {
            skillWidget = this.client.getWidget(320, 10);
            if (skillWidget == null) {
                return;
            }
            skillWidgetComponents = skillWidget.getDynamicChildren();
            if (skillWidgetComponents.length >= 4) {
                if (this.cachedConfig.agilityLevel > 99) {
                    if (this.cachedConfig.virtualLevels) {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("" + this.cachedConfig.agilityLevel);
                    } else {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("99");
                    }
                } else {
                    skillWidgetComponents[3].setText("" + this.cachedConfig.agilityLevel);
                    skillWidgetComponents[4].setText("" + this.cachedConfig.agilityLevel);
                }
            }
        }
        if (this.cachedConfig.spoofHerblore) {
            skillWidget = this.client.getWidget(320, 11);
            if (skillWidget == null) {
                return;
            }
            skillWidgetComponents = skillWidget.getDynamicChildren();
            if (skillWidgetComponents.length >= 4) {
                if (this.cachedConfig.herbloreLevel > 99) {
                    if (this.cachedConfig.virtualLevels) {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("" + this.cachedConfig.herbloreLevel);
                    } else {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("99");
                    }
                } else {
                    skillWidgetComponents[3].setText("" + this.cachedConfig.herbloreLevel);
                    skillWidgetComponents[4].setText("" + this.cachedConfig.herbloreLevel);
                }
            }
        }
        if (this.cachedConfig.spoofThieving) {
            skillWidget = this.client.getWidget(320, 12);
            if (skillWidget == null) {
                return;
            }
            skillWidgetComponents = skillWidget.getDynamicChildren();
            if (skillWidgetComponents.length >= 4) {
                if (this.cachedConfig.thievingLevel > 99) {
                    if (this.cachedConfig.virtualLevels) {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("" + this.cachedConfig.thievingLevel);
                    } else {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("99");
                    }
                } else {
                    skillWidgetComponents[3].setText("" + this.cachedConfig.thievingLevel);
                    skillWidgetComponents[4].setText("" + this.cachedConfig.thievingLevel);
                }
            }
        }
        if (this.cachedConfig.spoofCrafting) {
            skillWidget = this.client.getWidget(320, 13);
            if (skillWidget == null) {
                return;
            }
            skillWidgetComponents = skillWidget.getDynamicChildren();
            if (skillWidgetComponents.length >= 4) {
                if (this.cachedConfig.craftingLevel > 99) {
                    if (this.cachedConfig.virtualLevels) {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("" + this.cachedConfig.craftingLevel);
                    } else {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("99");
                    }
                } else {
                    skillWidgetComponents[3].setText("" + this.cachedConfig.craftingLevel);
                    skillWidgetComponents[4].setText("" + this.cachedConfig.craftingLevel);
                }
            }
        }
        if (this.cachedConfig.spoofFletching) {
            skillWidget = this.client.getWidget(320, 14);
            if (skillWidget == null) {
                return;
            }
            skillWidgetComponents = skillWidget.getDynamicChildren();
            if (skillWidgetComponents.length >= 4) {
                if (this.cachedConfig.fletchingLevel > 99) {
                    if (this.cachedConfig.virtualLevels) {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("" + this.cachedConfig.fletchingLevel);
                    } else {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("99");
                    }
                } else {
                    skillWidgetComponents[3].setText("" + this.cachedConfig.fletchingLevel);
                    skillWidgetComponents[4].setText("" + this.cachedConfig.fletchingLevel);
                }
            }
        }
        if (this.cachedConfig.spoofSlayer) {
            skillWidget = this.client.getWidget(320, 15);
            if (skillWidget == null) {
                return;
            }
            skillWidgetComponents = skillWidget.getDynamicChildren();
            if (skillWidgetComponents.length >= 4) {
                if (this.cachedConfig.slayerLevel > 99) {
                    if (this.cachedConfig.virtualLevels) {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("" + this.cachedConfig.slayerLevel);
                    } else {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("99");
                    }
                } else {
                    skillWidgetComponents[3].setText("" + this.cachedConfig.slayerLevel);
                    skillWidgetComponents[4].setText("" + this.cachedConfig.slayerLevel);
                }
            }
        }
        if (this.cachedConfig.spoofHunter) {
            skillWidget = this.client.getWidget(320, 16);
            if (skillWidget == null) {
                return;
            }
            skillWidgetComponents = skillWidget.getDynamicChildren();
            if (skillWidgetComponents.length >= 4) {
                if (this.cachedConfig.hunterLevel > 99) {
                    if (this.cachedConfig.virtualLevels) {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("" + this.cachedConfig.hunterLevel);
                    } else {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("99");
                    }
                } else {
                    skillWidgetComponents[3].setText("" + this.cachedConfig.hunterLevel);
                    skillWidgetComponents[4].setText("" + this.cachedConfig.hunterLevel);
                }
            }
        }
        if (this.cachedConfig.spoofMining) {
            skillWidget = this.client.getWidget(320, 17);
            if (skillWidget == null) {
                return;
            }
            skillWidgetComponents = skillWidget.getDynamicChildren();
            if (skillWidgetComponents.length >= 4) {
                if (this.cachedConfig.miningLevel > 99) {
                    if (this.cachedConfig.virtualLevels) {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("" + this.cachedConfig.miningLevel);
                    } else {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("99");
                    }
                } else {
                    skillWidgetComponents[3].setText("" + this.cachedConfig.miningLevel);
                    skillWidgetComponents[4].setText("" + this.cachedConfig.miningLevel);
                }
            }
        }
        if (this.cachedConfig.spoofSmithing) {
            skillWidget = this.client.getWidget(320, 18);
            if (skillWidget == null) {
                return;
            }
            skillWidgetComponents = skillWidget.getDynamicChildren();
            if (skillWidgetComponents.length >= 4) {
                if (this.cachedConfig.smithingLevel > 99) {
                    if (this.cachedConfig.virtualLevels) {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("" + this.cachedConfig.smithingLevel);
                    } else {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("99");
                    }
                } else {
                    skillWidgetComponents[3].setText("" + this.cachedConfig.smithingLevel);
                    skillWidgetComponents[4].setText("" + this.cachedConfig.smithingLevel);
                }
            }
        }
        if (this.cachedConfig.spoofFishing) {
            skillWidget = this.client.getWidget(320, 19);
            if (skillWidget == null) {
                return;
            }
            skillWidgetComponents = skillWidget.getDynamicChildren();
            if (skillWidgetComponents.length >= 4) {
                if (this.cachedConfig.fishingLevel > 99) {
                    if (this.cachedConfig.virtualLevels) {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("" + this.cachedConfig.fishingLevel);
                    } else {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("99");
                    }
                } else {
                    skillWidgetComponents[3].setText("" + this.cachedConfig.fishingLevel);
                    skillWidgetComponents[4].setText("" + this.cachedConfig.fishingLevel);
                }
            }
        }
        if (this.cachedConfig.spoofCooking) {
            skillWidget = this.client.getWidget(320, 20);
            if (skillWidget == null) {
                return;
            }
            skillWidgetComponents = skillWidget.getDynamicChildren();
            if (skillWidgetComponents.length >= 4) {
                if (this.cachedConfig.cookingLevel > 99) {
                    if (this.cachedConfig.virtualLevels) {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("" + this.cachedConfig.cookingLevel);
                    } else {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("99");
                    }
                } else {
                    skillWidgetComponents[3].setText("" + this.cachedConfig.cookingLevel);
                    skillWidgetComponents[4].setText("" + this.cachedConfig.cookingLevel);
                }
            }
        }
        if (this.cachedConfig.spoofFiremaking) {
            skillWidget = this.client.getWidget(320, 21);
            if (skillWidget == null) {
                return;
            }
            skillWidgetComponents = skillWidget.getDynamicChildren();
            if (skillWidgetComponents.length >= 4) {
                if (this.cachedConfig.firemakingLevel > 99) {
                    if (this.cachedConfig.virtualLevels) {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("" + this.cachedConfig.firemakingLevel);
                    } else {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("99");
                    }
                } else {
                    skillWidgetComponents[3].setText("" + this.cachedConfig.firemakingLevel);
                    skillWidgetComponents[4].setText("" + this.cachedConfig.firemakingLevel);
                }
            }
        }
        if (this.cachedConfig.spoofWoodcutting) {
            skillWidget = this.client.getWidget(320, 22);
            if (skillWidget == null) {
                return;
            }
            skillWidgetComponents = skillWidget.getDynamicChildren();
            if (skillWidgetComponents.length >= 4) {
                if (this.cachedConfig.woodcuttingLevel > 99) {
                    if (this.cachedConfig.virtualLevels) {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("" + this.cachedConfig.woodcuttingLevel);
                    } else {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("99");
                    }
                } else {
                    skillWidgetComponents[3].setText("" + this.cachedConfig.woodcuttingLevel);
                    skillWidgetComponents[4].setText("" + this.cachedConfig.woodcuttingLevel);
                }
            }
        }
        if (this.cachedConfig.spoofFarming) {
            skillWidget = this.client.getWidget(320, 23);
            if (skillWidget == null) {
                return;
            }
            skillWidgetComponents = skillWidget.getDynamicChildren();
            if (skillWidgetComponents.length >= 4) {
                if (this.cachedConfig.farmingLevel > 99) {
                    if (this.cachedConfig.virtualLevels) {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("" + this.cachedConfig.farmingLevel);
                    } else {
                        skillWidgetComponents[3].setText("99");
                        skillWidgetComponents[4].setText("99");
                    }
                } else {
                    skillWidgetComponents[3].setText("" + this.cachedConfig.farmingLevel);
                    skillWidgetComponents[4].setText("" + this.cachedConfig.farmingLevel);
                }
            }
        }
        Widget totalWidget = this.client.getWidget(320, 24);
        Widget[] totalWidgetComponents = totalWidget.getStaticChildren();
        Widget widgetText = totalWidgetComponents[2];
        if (totalWidget == null || totalWidgetComponents == null) {
            return;
        }
        if (this.cachedConfig.preset != FakeStatsConfig.ModePresets.NONE) {
            switch (this.cachedConfig.preset) {
                case All_200M: {
                    int counter200M = 0;
                    while (counter200M < 23) {
                        Widget skillWidget2;
                        if ((skillWidget2 = this.client.getWidget(320, ++counter200M)) == null) {
                            return;
                        }
                        Widget[] skillWidgetComponents2 = skillWidget2.getDynamicChildren();
                        if (skillWidgetComponents2.length < 4) continue;
                        skillWidgetComponents2[3].setText("99");
                        if (this.cachedConfig.virtualLevels) {
                            skillWidgetComponents2[4].setText("126");
                            continue;
                        }
                        skillWidgetComponents2[4].setText("99");
                    }
                    if (this.cachedConfig.virtualTotal) {
                        widgetText.setText("Total level:<br>2898");
                    } else {
                        widgetText.setText("Total level:<br>2277");
                    }
                    Widget widget200mEXP = this.client.getWidget(122, 10);
                    widget200mEXP.setText("4,600,000,000");
                    break;
                }
                case Maxed: {
                    int counterMax = 0;
                    while (counterMax < 23) {
                        Widget skillWidget3;
                        if ((skillWidget3 = this.client.getWidget(320, ++counterMax)) == null) {
                            return;
                        }
                        Widget[] skillWidgetComponents3 = skillWidget3.getDynamicChildren();
                        if (skillWidgetComponents3.length < 4) continue;
                        skillWidgetComponents3[3].setText("99");
                        skillWidgetComponents3[4].setText("99");
                    }
                    widgetText.setText("Total level:<br>2277");
                    Widget widgetMaxEXP = this.client.getWidget(122, 10);
                    long totalMaxExp = 299791913L + this.client.getOverallExperience();
                    String formatted = NumberFormat.getInstance().format(totalMaxExp);
                    widgetMaxEXP.setText(formatted);
                    break;
                }
                case Level_Three: {
                    int counterLevel3 = 0;
                    while (counterLevel3 < 23) {
                        Widget skillWidget4;
                        if ((skillWidget4 = this.client.getWidget(320, ++counterLevel3)) == null) {
                            return;
                        }
                        Widget[] skillWidgetComponents4 = skillWidget4.getDynamicChildren();
                        if (skillWidgetComponents4.length < 4) continue;
                        if (counterLevel3 == 9) {
                            skillWidgetComponents4[3].setText("10");
                            skillWidgetComponents4[4].setText("10");
                            continue;
                        }
                        skillWidgetComponents4[3].setText("1");
                        skillWidgetComponents4[4].setText("1");
                    }
                    widgetText.setText("Total level:<br>32");
                    Widget widgetLevel3EXP = this.client.getWidget(122, 10);
                    widgetLevel3EXP.setText("1,154");
                    break;
                }
            }
        } else if (this.cachedConfig.overrideTotalText) {
            widgetText.setText(this.cachedConfig.totalLevelText);
        } else if (this.cachedConfig.spoofTotal) {
            widgetText.setText(TOTAL_LEVEL_TEXT_PREFIX + this.cachedConfig.totalLevel);
        } else if (this.cachedConfig.fakeSpoofTotal) {
            int total = 0;
            if (this.cachedConfig.spoofAttack) {
                if (this.cachedConfig.attackLevel <= 99) {
                    total += this.cachedConfig.attackLevel;
                } else if (this.cachedConfig.attackLevel > 99 && this.cachedConfig.attackLevel <= 126 && this.cachedConfig.virtualTotal) {
                    total += this.cachedConfig.attackLevel;
                } else if (this.cachedConfig.attackLevel > 126 && this.cachedConfig.virtualTotal) {
                    total += 126;
                } else if (this.cachedConfig.attackLevel > 99) {
                    total += 99;
                }
            } else {
                total += this.client.getRealSkillLevel(Skill.ATTACK);
            }
            if (this.cachedConfig.spoofStrength) {
                if (this.cachedConfig.strengthLevel <= 99) {
                    total += this.cachedConfig.strengthLevel;
                } else if (this.cachedConfig.strengthLevel > 99 && this.cachedConfig.strengthLevel <= 126 && this.cachedConfig.virtualTotal) {
                    total += this.cachedConfig.strengthLevel;
                } else if (this.cachedConfig.strengthLevel > 126 && this.cachedConfig.virtualTotal) {
                    total += 126;
                } else if (this.cachedConfig.strengthLevel > 99) {
                    total += 99;
                }
            } else {
                total += this.client.getRealSkillLevel(Skill.STRENGTH);
            }
            if (this.cachedConfig.spoofDefence) {
                if (this.cachedConfig.defenceLevel <= 99) {
                    total += this.cachedConfig.defenceLevel;
                } else if (this.cachedConfig.defenceLevel > 99 && this.cachedConfig.defenceLevel <= 126 && this.cachedConfig.virtualTotal) {
                    total += this.cachedConfig.defenceLevel;
                } else if (this.cachedConfig.defenceLevel > 126 && this.cachedConfig.virtualTotal) {
                    total += 126;
                } else if (this.cachedConfig.defenceLevel > 99) {
                    total += 99;
                }
            } else {
                total += this.client.getRealSkillLevel(Skill.DEFENCE);
            }
            if (this.cachedConfig.spoofRanged) {
                if (this.cachedConfig.rangedLevel <= 99) {
                    total += this.cachedConfig.rangedLevel;
                } else if (this.cachedConfig.rangedLevel > 99 && this.cachedConfig.rangedLevel <= 126 && this.cachedConfig.virtualTotal) {
                    total += this.cachedConfig.rangedLevel;
                } else if (this.cachedConfig.rangedLevel > 126 && this.cachedConfig.virtualTotal) {
                    total += 126;
                } else if (this.cachedConfig.rangedLevel > 99) {
                    total += 99;
                }
            } else {
                total += this.client.getRealSkillLevel(Skill.RANGED);
            }
            if (this.cachedConfig.spoofPrayer) {
                if (this.cachedConfig.prayerLevel <= 99) {
                    total += this.cachedConfig.prayerLevel;
                } else if (this.cachedConfig.prayerLevel > 99 && this.cachedConfig.prayerLevel <= 126 && this.cachedConfig.virtualTotal) {
                    total += this.cachedConfig.prayerLevel;
                } else if (this.cachedConfig.prayerLevel > 126 && this.cachedConfig.virtualTotal) {
                    total += 126;
                } else if (this.cachedConfig.prayerLevel > 99) {
                    total += 99;
                }
            } else {
                total += this.client.getRealSkillLevel(Skill.PRAYER);
            }
            if (this.cachedConfig.spoofMagic) {
                if (this.cachedConfig.magicLevel <= 99) {
                    total += this.cachedConfig.magicLevel;
                } else if (this.cachedConfig.magicLevel > 99 && this.cachedConfig.magicLevel <= 126 && this.cachedConfig.virtualTotal) {
                    total += this.cachedConfig.magicLevel;
                } else if (this.cachedConfig.magicLevel > 126 && this.cachedConfig.virtualTotal) {
                    total += 126;
                } else if (this.cachedConfig.magicLevel > 99) {
                    total += 99;
                }
            } else {
                total += this.client.getRealSkillLevel(Skill.MAGIC);
            }
            if (this.cachedConfig.spoofRunecraft) {
                if (this.cachedConfig.runecraftLevel <= 99) {
                    total += this.cachedConfig.runecraftLevel;
                } else if (this.cachedConfig.runecraftLevel > 99 && this.cachedConfig.runecraftLevel <= 126 && this.cachedConfig.virtualTotal) {
                    total += this.cachedConfig.runecraftLevel;
                } else if (this.cachedConfig.runecraftLevel > 126 && this.cachedConfig.virtualTotal) {
                    total += 126;
                } else if (this.cachedConfig.runecraftLevel > 99) {
                    total += 99;
                }
            } else {
                total += this.client.getRealSkillLevel(Skill.RUNECRAFT);
            }
            if (this.cachedConfig.spoofConstruction) {
                if (this.cachedConfig.constructionLevel <= 99) {
                    total += this.cachedConfig.constructionLevel;
                } else if (this.cachedConfig.constructionLevel > 99 && this.cachedConfig.constructionLevel <= 126 && this.cachedConfig.virtualTotal) {
                    total += this.cachedConfig.constructionLevel;
                } else if (this.cachedConfig.constructionLevel > 126 && this.cachedConfig.virtualTotal) {
                    total += 126;
                } else if (this.cachedConfig.constructionLevel > 99) {
                    total += 99;
                }
            } else {
                total += this.client.getRealSkillLevel(Skill.CONSTRUCTION);
            }
            if (this.cachedConfig.spoofHitpoints) {
                if (this.cachedConfig.hitpointsLevel <= 99) {
                    total += this.cachedConfig.hitpointsLevel;
                } else if (this.cachedConfig.hitpointsLevel > 99 && this.cachedConfig.hitpointsLevel <= 126 && this.cachedConfig.virtualTotal) {
                    total += this.cachedConfig.hitpointsLevel;
                } else if (this.cachedConfig.hitpointsLevel > 126 && this.cachedConfig.virtualTotal) {
                    total += 126;
                } else if (this.cachedConfig.hitpointsLevel > 99) {
                    total += 99;
                }
            } else {
                total += this.client.getRealSkillLevel(Skill.HITPOINTS);
            }
            if (this.cachedConfig.spoofAgility) {
                if (this.cachedConfig.agilityLevel <= 99) {
                    total += this.cachedConfig.agilityLevel;
                } else if (this.cachedConfig.agilityLevel > 99 && this.cachedConfig.agilityLevel <= 126 && this.cachedConfig.virtualTotal) {
                    total += this.cachedConfig.agilityLevel;
                } else if (this.cachedConfig.agilityLevel > 126 && this.cachedConfig.virtualTotal) {
                    total += 126;
                } else if (this.cachedConfig.agilityLevel > 99) {
                    total += 99;
                }
            } else {
                total += this.client.getRealSkillLevel(Skill.AGILITY);
            }
            if (this.cachedConfig.spoofHerblore) {
                if (this.cachedConfig.herbloreLevel <= 99) {
                    total += this.cachedConfig.herbloreLevel;
                } else if (this.cachedConfig.herbloreLevel > 99 && this.cachedConfig.herbloreLevel <= 126 && this.cachedConfig.virtualTotal) {
                    total += this.cachedConfig.herbloreLevel;
                } else if (this.cachedConfig.herbloreLevel > 126 && this.cachedConfig.virtualTotal) {
                    total += 126;
                } else if (this.cachedConfig.herbloreLevel > 99) {
                    total += 99;
                }
            } else {
                total += this.client.getRealSkillLevel(Skill.HERBLORE);
            }
            if (this.cachedConfig.spoofThieving) {
                if (this.cachedConfig.thievingLevel <= 99) {
                    total += this.cachedConfig.thievingLevel;
                } else if (this.cachedConfig.thievingLevel > 99 && this.cachedConfig.thievingLevel <= 126 && this.cachedConfig.virtualTotal) {
                    total += this.cachedConfig.thievingLevel;
                } else if (this.cachedConfig.thievingLevel > 126 && this.cachedConfig.virtualTotal) {
                    total += 126;
                } else if (this.cachedConfig.thievingLevel > 99) {
                    total += 99;
                }
            } else {
                total += this.client.getRealSkillLevel(Skill.THIEVING);
            }
            if (this.cachedConfig.spoofCrafting) {
                if (this.cachedConfig.craftingLevel <= 99) {
                    total += this.cachedConfig.craftingLevel;
                } else if (this.cachedConfig.craftingLevel > 99 && this.cachedConfig.craftingLevel <= 126 && this.cachedConfig.virtualTotal) {
                    total += this.cachedConfig.craftingLevel;
                } else if (this.cachedConfig.craftingLevel > 126 && this.cachedConfig.virtualTotal) {
                    total += 126;
                } else if (this.cachedConfig.craftingLevel > 99) {
                    total += 99;
                }
            } else {
                total += this.client.getRealSkillLevel(Skill.CRAFTING);
            }
            if (this.cachedConfig.spoofFletching) {
                if (this.cachedConfig.fletchingLevel <= 99) {
                    total += this.cachedConfig.fletchingLevel;
                } else if (this.cachedConfig.fletchingLevel > 99 && this.cachedConfig.fletchingLevel <= 126 && this.cachedConfig.virtualTotal) {
                    total += this.cachedConfig.fletchingLevel;
                } else if (this.cachedConfig.fletchingLevel > 126 && this.cachedConfig.virtualTotal) {
                    total += 126;
                } else if (this.cachedConfig.fletchingLevel > 99) {
                    total += 99;
                }
            } else {
                total += this.client.getRealSkillLevel(Skill.FLETCHING);
            }
            if (this.cachedConfig.spoofSlayer) {
                if (this.cachedConfig.slayerLevel <= 99) {
                    total += this.cachedConfig.slayerLevel;
                } else if (this.cachedConfig.slayerLevel > 99 && this.cachedConfig.slayerLevel <= 126 && this.cachedConfig.virtualTotal) {
                    total += this.cachedConfig.slayerLevel;
                } else if (this.cachedConfig.slayerLevel > 126 && this.cachedConfig.virtualTotal) {
                    total += 126;
                } else if (this.cachedConfig.slayerLevel > 99) {
                    total += 99;
                }
            } else {
                total += this.client.getRealSkillLevel(Skill.SLAYER);
            }
            if (this.cachedConfig.spoofHunter) {
                if (this.cachedConfig.hunterLevel <= 99) {
                    total += this.cachedConfig.hunterLevel;
                } else if (this.cachedConfig.hunterLevel > 99 && this.cachedConfig.hunterLevel <= 126 && this.cachedConfig.virtualTotal) {
                    total += this.cachedConfig.hunterLevel;
                } else if (this.cachedConfig.hunterLevel > 126 && this.cachedConfig.virtualTotal) {
                    total += 126;
                } else if (this.cachedConfig.hunterLevel > 99) {
                    total += 99;
                }
            } else {
                total += this.client.getRealSkillLevel(Skill.HUNTER);
            }
            if (this.cachedConfig.spoofMining) {
                if (this.cachedConfig.miningLevel <= 99) {
                    total += this.cachedConfig.miningLevel;
                } else if (this.cachedConfig.miningLevel > 99 && this.cachedConfig.miningLevel <= 126 && this.cachedConfig.virtualTotal) {
                    total += this.cachedConfig.miningLevel;
                } else if (this.cachedConfig.miningLevel > 126 && this.cachedConfig.virtualTotal) {
                    total += 126;
                } else if (this.cachedConfig.miningLevel > 99) {
                    total += 99;
                }
            } else {
                total += this.client.getRealSkillLevel(Skill.MINING);
            }
            if (this.cachedConfig.spoofSmithing) {
                if (this.cachedConfig.smithingLevel <= 99) {
                    total += this.cachedConfig.smithingLevel;
                } else if (this.cachedConfig.smithingLevel > 99 && this.cachedConfig.smithingLevel <= 126 && this.cachedConfig.virtualTotal) {
                    total += this.cachedConfig.smithingLevel;
                } else if (this.cachedConfig.smithingLevel > 126 && this.cachedConfig.virtualTotal) {
                    total += 126;
                } else if (this.cachedConfig.smithingLevel > 99) {
                    total += 99;
                }
            } else {
                total += this.client.getRealSkillLevel(Skill.SMITHING);
            }
            if (this.cachedConfig.spoofFishing) {
                if (this.cachedConfig.fishingLevel <= 99) {
                    total += this.cachedConfig.fishingLevel;
                } else if (this.cachedConfig.fishingLevel > 99 && this.cachedConfig.fishingLevel <= 126 && this.cachedConfig.virtualTotal) {
                    total += this.cachedConfig.fishingLevel;
                } else if (this.cachedConfig.fishingLevel > 126 && this.cachedConfig.virtualTotal) {
                    total += 126;
                } else if (this.cachedConfig.fishingLevel > 99) {
                    total += 99;
                }
            } else {
                total += this.client.getRealSkillLevel(Skill.FISHING);
            }
            if (this.cachedConfig.spoofCooking) {
                if (this.cachedConfig.cookingLevel <= 99) {
                    total += this.cachedConfig.cookingLevel;
                } else if (this.cachedConfig.cookingLevel > 99 && this.cachedConfig.cookingLevel <= 126 && this.cachedConfig.virtualTotal) {
                    total += this.cachedConfig.cookingLevel;
                } else if (this.cachedConfig.cookingLevel > 126 && this.cachedConfig.virtualTotal) {
                    total += 126;
                } else if (this.cachedConfig.cookingLevel > 99) {
                    total += 99;
                }
            } else {
                total += this.client.getRealSkillLevel(Skill.COOKING);
            }
            if (this.cachedConfig.spoofFiremaking) {
                if (this.cachedConfig.firemakingLevel <= 99) {
                    total += this.cachedConfig.firemakingLevel;
                } else if (this.cachedConfig.firemakingLevel > 99 && this.cachedConfig.firemakingLevel <= 126 && this.cachedConfig.virtualTotal) {
                    total += this.cachedConfig.firemakingLevel;
                } else if (this.cachedConfig.firemakingLevel > 126 && this.cachedConfig.virtualTotal) {
                    total += 126;
                } else if (this.cachedConfig.firemakingLevel > 99) {
                    total += 99;
                }
            } else {
                total += this.client.getRealSkillLevel(Skill.FIREMAKING);
            }
            if (this.cachedConfig.spoofWoodcutting) {
                if (this.cachedConfig.woodcuttingLevel <= 99) {
                    total += this.cachedConfig.woodcuttingLevel;
                } else if (this.cachedConfig.woodcuttingLevel > 99 && this.cachedConfig.woodcuttingLevel <= 126 && this.cachedConfig.virtualTotal) {
                    total += this.cachedConfig.woodcuttingLevel;
                } else if (this.cachedConfig.woodcuttingLevel > 126 && this.cachedConfig.virtualTotal) {
                    total += 126;
                } else if (this.cachedConfig.woodcuttingLevel > 99) {
                    total += 99;
                }
            } else {
                total += this.client.getRealSkillLevel(Skill.WOODCUTTING);
            }
            if (this.cachedConfig.spoofFarming) {
                if (this.cachedConfig.farmingLevel <= 99) {
                    total += this.cachedConfig.farmingLevel;
                } else if (this.cachedConfig.farmingLevel > 99 && this.cachedConfig.farmingLevel <= 126 && this.cachedConfig.virtualTotal) {
                    total += this.cachedConfig.farmingLevel;
                } else if (this.cachedConfig.farmingLevel > 126 && this.cachedConfig.virtualTotal) {
                    total += 126;
                } else if (this.cachedConfig.farmingLevel > 99) {
                    total += 99;
                }
            } else {
                total += this.client.getRealSkillLevel(Skill.FARMING);
            }
            widgetText.setText(TOTAL_LEVEL_TEXT_PREFIX + total);
        }
    }

    private void simulateSkillChange() {
        for (Skill skill : Skill.values()) {
            if (skill == Skill.OVERALL) continue;
            this.client.queueChangedSkill(skill);
        }
    }

    @Provides
    FakeStatsConfig provideConfig(ConfigManager configManager) {
        return (FakeStatsConfig)configManager.getConfig(FakeStatsConfig.class);
    }
}

