/*
 * Decompiled with CFR 0.152.
 */
package com.discordNotifier;

import com.discordNotifier.DiscordNotifierConfig;
import com.discordNotifier.DiscordWebhookBody;
import com.google.inject.Provides;
import java.io.IOException;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.NotificationFired;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Discord Notifier")
public class DiscordNotifier
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DiscordNotifier.class);
    @Inject
    private Client client;
    @Inject
    private DiscordNotifierConfig config;
    @Inject
    private OkHttpClient okHttpClient;

    private void sendDiscordMessage(String message) {
        if (this.config.webhook().trim().isEmpty()) {
            log.warn("Missing Discord webhook. Cannot send message.");
            return;
        }
        if (!this.config.mention().trim().isEmpty()) {
            message = "<@" + this.config.mention().trim() + "> " + (String)message;
        }
        DiscordWebhookBody discordWebhookBody = new DiscordWebhookBody();
        discordWebhookBody.setContent((String)message);
        HttpUrl url = HttpUrl.parse((String)this.config.webhook().trim());
        MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("payload_json", RuneLiteAPI.GSON.toJson((Object)discordWebhookBody));
        MultipartBody requestBody = requestBodyBuilder.build();
        Request request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.error("Error submitting message to Discord webhook.", (Throwable)e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                log.info("Successfully sent message to Discord.");
                response.close();
            }
        });
    }

    @Subscribe
    public void onNotificationFired(NotificationFired notificationFired) {
        this.sendDiscordMessage(notificationFired.getMessage());
    }

    protected void startUp() throws Exception {
        log.info("Starting Discord Notifier Plugin.");
    }

    protected void shutDown() throws Exception {
        log.info("Discord Notifier Plugin stopped!");
    }

    @Provides
    DiscordNotifierConfig provideConfig(ConfigManager configManager) {
        return (DiscordNotifierConfig)configManager.getConfig(DiscordNotifierConfig.class);
    }
}

