/*
 * Decompiled with CFR 0.152.
 */
package com.herbsackpricecheck;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.QuantityFormatter;
import net.runelite.http.api.item.ItemPrice;

@PluginDescriptor(name="Herb Sack Price Check", description="Price checks the herbs in herb sack", tags={"herbs", "prices"})
public class HerbSackPriceCheckPlugin
extends Plugin {
    private boolean gettingHerbs = false;
    private ArrayList<ChatMessage> herbsInChatMessage = new ArrayList();
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ChatMessageManager chatMessageManager;

    @Subscribe
    private void onMenuOptionClicked(MenuOptionClicked event) {
        if (!event.getMenuOption().equals("Check") || event.getItemId() != 24478 && event.getItemId() != 13226) {
            return;
        }
        this.gettingHerbs = true;
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (!this.gettingHerbs || chatMessage.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String messageString = chatMessage.getMessage();
        if (messageString.contains("x Grimy")) {
            this.herbsInChatMessage.add(chatMessage);
        }
        if (messageString == "The herb sack is empty.") {
            this.herbsInChatMessage.clear();
            this.gettingHerbs = false;
        }
    }

    private HashMap<String, Integer> reformatHerbChatMessages() {
        HashMap<String, Integer> herbsWithQuantity = new HashMap<String, Integer>();
        for (ChatMessage message : this.herbsInChatMessage) {
            String[] fullHerbName = message.getMessage().split(" x ");
            if (fullHerbName.length != 2) continue;
            herbsWithQuantity.put(fullHerbName[1].trim(), Integer.parseInt(fullHerbName[0].trim(), 10));
        }
        return herbsWithQuantity;
    }

    @Subscribe
    private void onGameTick(GameTick event) {
        if (this.gettingHerbs && !this.herbsInChatMessage.isEmpty()) {
            HashMap<String, Integer> herbsWithQuantity = this.reformatHerbChatMessages();
            int totalValue = this.herbPriceLookup(herbsWithQuantity);
            this.buildValueMessage(totalValue);
            this.gettingHerbs = false;
            this.herbsInChatMessage = new ArrayList();
        }
    }

    private int herbPriceLookup(HashMap<String, Integer> herbsWithQuantity) {
        int totalValue = 0;
        for (Map.Entry<String, Integer> herbQuant : herbsWithQuantity.entrySet()) {
            List results = this.itemManager.search(herbQuant.getKey());
            if (results == null || results.isEmpty()) continue;
            for (ItemPrice result : results) {
                totalValue += result.getPrice() * herbQuant.getValue();
            }
        }
        return totalValue;
    }

    private void buildValueMessage(int totalValue) {
        ChatMessageBuilder output = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Total value of herbs in sack: ").append(ChatColorType.HIGHLIGHT).append(QuantityFormatter.formatNumber((long)totalValue));
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.ITEM_EXAMINE).runeLiteFormattedMessage(output.build()).build());
    }

    protected void startUp() throws Exception {
    }

    protected void shutDown() throws Exception {
    }
}

