/*
 * Decompiled with CFR 0.152.
 */
package com.wikisearchshortcuts;

import com.google.inject.Provides;
import com.wikisearchshortcuts.WikiSearchShortcutsConfig;
import javax.inject.Inject;
import javax.inject.Provider;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.wiki.WikiSearchChatboxTextInput;
import net.runelite.client.util.HotkeyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Wiki Search Shortcuts", description="Shortcut keys to open osrs wiki search", tags={"wiki", "search", "shortcut", "hotkey"})
public class WikiSearchShortcutsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WikiSearchShortcutsPlugin.class);
    @Inject
    private WikiSearchShortcutsConfig config;
    @Inject
    private Provider<WikiSearchChatboxTextInput> wikiSearchChatboxTextInputProvider;
    @Inject
    private KeyManager keyManager;
    private final HotkeyListener hotkeyListener = new HotkeyListener(() -> this.config.hotkey()){

        public void hotkeyPressed() {
            ((WikiSearchChatboxTextInput)WikiSearchShortcutsPlugin.this.wikiSearchChatboxTextInputProvider.get()).build();
        }
    };

    @Provides
    WikiSearchShortcutsConfig getConfig(ConfigManager configManager) {
        return (WikiSearchShortcutsConfig)configManager.getConfig(WikiSearchShortcutsConfig.class);
    }

    protected void startUp() throws Exception {
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener);
    }

    protected void shutDown() throws Exception {
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener);
    }

    HotkeyListener getHotkeyListener() {
        return this.hotkeyListener;
    }
}

