/*
 * Decompiled with CFR 0.152.
 */
package com.Salverrs.DialogueAssistant;

import com.Salverrs.DialogueAssistant.OptionStatus;
import java.util.HashMap;
import java.util.Map;

public class DialogueConfig {
    private int targetId;
    private Map<String, OptionStatus> optionMap = new HashMap<String, OptionStatus>();

    public DialogueConfig(int id) {
        this.targetId = id;
    }

    public boolean isHighlighted(String option) {
        return this.optionMap.containsKey(option) && this.optionMap.get(option) == OptionStatus.HIGHLIGHTED;
    }

    public boolean isLocked(String option) {
        return this.optionMap.containsKey(option) && this.optionMap.get(option) == OptionStatus.LOCKED;
    }

    public void setHighlighted(String option) {
        this.optionMap.put(option, OptionStatus.HIGHLIGHTED);
    }

    public void setLocked(String option) {
        this.optionMap.put(option, OptionStatus.LOCKED);
    }

    public void resetOption(String option) {
        this.optionMap.remove(option);
    }

    public int getTargetId() {
        return this.targetId;
    }
}

