/*
 * Decompiled with CFR 0.152.
 */
package com.Salverrs.DialogueAssistant;

import com.Salverrs.DialogueAssistant.DialogueAssistantConfig;
import com.Salverrs.DialogueAssistant.DialogueConfig;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Provides;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.InteractingChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.http.api.RuneLiteAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Dialogue Assistant", description="Highlight and lock NPC dialogue options.", tags={"dialogue, dialog, assistant, npc, chat, options, lock, highlight"})
public class DialogueAssistantPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DialogueAssistantPlugin.class);
    public static final String CONFIG_GROUP = "DIALOGUE_ASSISTANT";
    private final String MAP_KEY = "DIALOGUE_CONFIG";
    private int lastNPCInteractionId = -1;
    private int lastInteractionId = -1;
    private int optionParentId = -1;
    private int viewportBoxId = -1;
    private Map<Integer, DialogueConfig> dialogMap = new HashMap<Integer, DialogueConfig>();
    private List<Widget> recentWidgets = new ArrayList<Widget>();
    @Inject
    private Client client;
    @Inject
    private DialogueAssistantConfig config;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;

    protected void startUp() {
        this.loadConfig();
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 219) {
            this.checkDialogOptions();
        }
    }

    @Subscribe
    protected void onClientTick(ClientTick clientTick) {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.client.isMenuOpen()) {
            return;
        }
        if (!this.hasTarget()) {
            return;
        }
        ArrayList<MenuEntry> entries = new ArrayList<MenuEntry>(Arrays.asList(this.client.getMenuEntries()));
        DialogueConfig dConfig = this.getDConfig(this.lastInteractionId);
        for (MenuEntry entry : entries) {
            boolean isLocked;
            Widget widget = entry.getWidget();
            if (!this.isDialogueOption(widget)) continue;
            String option = widget.getText();
            boolean isHighlighted = dConfig != null && dConfig.isHighlighted(option);
            boolean bl = isLocked = dConfig != null && dConfig.isLocked(option);
            if (isHighlighted || isLocked) {
                this.client.createMenuEntry(-1).setOption("Reset Option").setTarget("").setType(MenuAction.RUNELITE).onClick(e -> this.resetOption(dConfig, option, widget));
            }
            if (!isLocked) {
                this.client.createMenuEntry(-1).setOption("Lock Option").setTarget("").setType(MenuAction.RUNELITE).onClick(e -> this.setAsLockedOption(this.lastInteractionId, option, widget));
            }
            if (isHighlighted) continue;
            this.client.createMenuEntry(-1).setOption("Highlight Option").setTarget("").setType(MenuAction.RUNELITE).onClick(e -> this.setAsHighlightedOption(this.lastInteractionId, option, widget));
        }
    }

    @Subscribe
    private void onInteractingChanged(InteractingChanged event) {
        if (event.getSource() != this.client.getLocalPlayer()) {
            return;
        }
        Actor target = event.getTarget();
        if (target instanceof NPC) {
            this.lastNPCInteractionId = this.lastInteractionId = ((NPC)event.getTarget()).getId();
        } else if (target == null) {
            this.lastNPCInteractionId = -1;
        }
    }

    @Subscribe
    private void onMenuOptionClicked(MenuOptionClicked event) {
        DialogueConfig dConfig;
        MenuEntry menuEntry = event.getMenuEntry();
        Widget widget = menuEntry.getWidget();
        if (this.lastNPCInteractionId == -1 && (this.isWorldMenuOption(menuEntry) || this.isMenuException(menuEntry))) {
            String menuOption = event.getMenuOption();
            String menuTarget = event.getMenuTarget();
            this.lastInteractionId = this.getMenuHashId(menuOption, menuTarget);
        }
        if ((dConfig = this.getDConfig(this.lastInteractionId)) == null || widget == null) {
            return;
        }
        String dialogueOption = widget.getText();
        if (dialogueOption == null || dialogueOption.equals("")) {
            return;
        }
        if (dConfig.isLocked(dialogueOption)) {
            event.consume();
        }
    }

    private boolean isWorldMenuOption(MenuEntry menuEntry) {
        NPC npc = menuEntry.getNpc();
        Actor actor = menuEntry.getActor();
        Player player = menuEntry.getPlayer();
        MenuAction type = menuEntry.getType();
        return this.isWorldMenuActionType(type) || player == null && (npc != null || actor != null);
    }

    private boolean isMenuException(MenuEntry menuEntry) {
        int maxSearch = 5;
        Widget widget = menuEntry.getWidget();
        if (menuEntry.getTarget().contains("NPC Contact")) {
            return true;
        }
        if (this.viewportBoxId == -1) {
            Widget viewportBox = this.client.getWidget(WidgetInfo.RESIZABLE_VIEWPORT_OLD_SCHOOL_BOX);
            if (viewportBox == null) {
                return false;
            }
            this.viewportBoxId = viewportBox.getId();
        }
        for (int i = 0; i < 5; ++i) {
            if (widget == null) {
                return false;
            }
            if (widget.getId() == this.viewportBoxId) {
                return true;
            }
            widget = widget.getParent();
        }
        return false;
    }

    private boolean isWorldMenuActionType(MenuAction type) {
        switch (type) {
            case GAME_OBJECT_FIRST_OPTION: 
            case GAME_OBJECT_SECOND_OPTION: 
            case GAME_OBJECT_THIRD_OPTION: 
            case GAME_OBJECT_FOURTH_OPTION: 
            case GAME_OBJECT_FIFTH_OPTION: 
            case NPC_FIRST_OPTION: 
            case NPC_SECOND_OPTION: 
            case NPC_THIRD_OPTION: 
            case NPC_FOURTH_OPTION: 
            case NPC_FIFTH_OPTION: {
                return true;
            }
        }
        return false;
    }

    private boolean isDialogueOption(Widget widget) {
        if (this.optionParentId == -1) {
            Widget optionGroup = this.client.getWidget(WidgetInfo.DIALOG_OPTION_OPTIONS);
            if (optionGroup == null) {
                return false;
            }
            this.optionParentId = optionGroup.getId();
        }
        return widget != null && widget.getParent() != null && widget.getParent().getId() == this.optionParentId;
    }

    private int getMenuHashId(String option, String target) {
        if (target.contains("NPC Contact")) {
            target = "";
        }
        return (option + target).hashCode();
    }

    private void checkDialogOptions() {
        DialogueConfig dConfig = this.getDConfig(this.lastInteractionId);
        if (dConfig == null) {
            return;
        }
        this.clientThread.invokeAtTickEnd(() -> {
            Widget[] children;
            Widget optionGroup = this.client.getWidget(WidgetInfo.DIALOG_OPTION_OPTIONS);
            Widget[] widgetArray = children = optionGroup != null ? optionGroup.getChildren() : null;
            if (children == null || children.length == 0) {
                return;
            }
            List options = Arrays.stream(children).filter(Widget::hasListener).collect(Collectors.toList());
            this.recentWidgets = options;
            for (Widget optionWidget : options) {
                String option = optionWidget.getText();
                if (dConfig.isHighlighted(option)) {
                    this.highlightOptionWidget(optionWidget, true, false);
                    continue;
                }
                if (!dConfig.isLocked(option)) continue;
                this.lockOptionWidget(optionWidget, true, false);
            }
        });
    }

    private void highlightOptionWidget(Widget optionWidget, boolean highlighted, boolean reset) {
        if (highlighted) {
            optionWidget.setTextColor(this.config.optionHighlightColor().getRGB());
            optionWidget.setOnMouseLeaveListener(new Object[]{ev -> optionWidget.setTextColor(this.config.optionHighlightColor().getRGB())});
        } else if (reset) {
            optionWidget.setTextColor(Color.BLACK.getRGB());
            optionWidget.setOnMouseLeaveListener(new Object[]{ev -> optionWidget.setTextColor(Color.BLACK.getRGB())});
        }
    }

    private void lockOptionWidget(Widget optionWidget, boolean locked, boolean reset) {
        if (locked) {
            optionWidget.setHasListener(false);
            optionWidget.setTextColor(this.config.optionLockedColor().getRGB());
            optionWidget.setOnMouseLeaveListener(new Object[]{ev -> optionWidget.setTextColor(this.config.optionLockedColor().getRGB())});
        } else if (reset) {
            optionWidget.setHasListener(true);
            optionWidget.setTextColor(Color.BLACK.getRGB());
            optionWidget.setOnMouseLeaveListener(new Object[]{ev -> optionWidget.setTextColor(Color.BLACK.getRGB())});
        }
    }

    private void setAsHighlightedOption(int targetId, String optionTarget, Widget widget) {
        this.clientThread.invokeLater(() -> {
            DialogueConfig dConfig = this.getDConfig(targetId, true);
            dConfig.setHighlighted(optionTarget);
            this.refreshOptionState(dConfig, optionTarget, widget);
            this.saveConfig();
        });
    }

    private void setAsLockedOption(int targetId, String optionTarget, Widget widget) {
        this.clientThread.invokeLater(() -> {
            DialogueConfig dConfig = this.getDConfig(targetId, true);
            dConfig.setLocked(optionTarget);
            this.refreshOptionState(dConfig, optionTarget, widget);
            this.saveConfig();
        });
    }

    private void resetOption(DialogueConfig dConfig, String optionTarget, Widget widget) {
        this.clientThread.invokeLater(() -> {
            dConfig.resetOption(optionTarget);
            this.refreshOptionState(dConfig, optionTarget, widget);
            this.saveConfig();
        });
    }

    private void refreshOptionState(DialogueConfig dConfig, String optionTarget, Widget widget) {
        this.highlightOptionWidget(widget, false, true);
        this.lockOptionWidget(widget, false, true);
        this.highlightOptionWidget(widget, dConfig.isHighlighted(optionTarget), false);
        this.lockOptionWidget(widget, dConfig.isLocked(optionTarget), false);
    }

    private DialogueConfig getDConfig(int id) {
        if (id == -1) {
            return null;
        }
        return this.getDConfig(id, false);
    }

    private DialogueConfig getDConfig(int id, boolean forceCreate) {
        if (id == -1) {
            return null;
        }
        DialogueConfig dConfig = this.dialogMap.getOrDefault(id, null);
        if (forceCreate && dConfig == null) {
            return this.addDialogueConfig(id);
        }
        return this.dialogMap.getOrDefault(id, null);
    }

    private DialogueConfig addDialogueConfig(int id) {
        DialogueConfig dialogueOptions = new DialogueConfig(id);
        this.dialogMap.put(id, dialogueOptions);
        return dialogueOptions;
    }

    private void resetAllRecentWidgets() {
        this.clientThread.invokeLater(() -> {
            for (Widget widget : this.recentWidgets) {
                if (widget == null) continue;
                this.highlightOptionWidget(widget, false, true);
                this.lockOptionWidget(widget, false, true);
            }
            this.recentWidgets.clear();
        });
    }

    private void saveConfig() {
        String json = RuneLiteAPI.GSON.toJson(this.dialogMap);
        this.configManager.setConfiguration(CONFIG_GROUP, "DIALOGUE_CONFIG", json);
    }

    private void loadConfig() {
        String json = this.configManager.getConfiguration(CONFIG_GROUP, "DIALOGUE_CONFIG");
        if (json == null || json.equals("")) {
            this.dialogMap = new HashMap<Integer, DialogueConfig>();
        } else {
            Type mapType = new TypeToken<Map<Integer, DialogueConfig>>(){}.getType();
            this.dialogMap = (Map)RuneLiteAPI.GSON.fromJson(json, mapType);
        }
    }

    private boolean hasTarget() {
        return this.lastInteractionId != -1;
    }

    protected void shutDown() {
        this.lastInteractionId = -1;
        this.resetAllRecentWidgets();
    }

    @Provides
    DialogueAssistantConfig provideConfig(ConfigManager configManager) {
        return (DialogueAssistantConfig)configManager.getConfig(DialogueAssistantConfig.class);
    }
}

