/*
 * Decompiled with CFR 0.152.
 */
package herb10hp.blastfurnacetrainer;

import com.google.inject.Provides;
import herb10hp.blastfurnacetrainer.BlastFurnaceClickBoxOverlay;
import herb10hp.blastfurnacetrainer.BlastFurnaceTrainerConfig;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Blast Furnace Trainer", description="Highlights Skill training activities at the Blast Furnace.", tags={"minigame", "overlay", "skilling", "crafting", "strength", "firemaking"})
public class BlastFurnaceTrainerPlugin
extends Plugin {
    private GameObject westPipesFixed;
    private GameObject westPipesBroken;
    private GameObject eastPipesFixed;
    private GameObject eastPipesBroken;
    private GameObject cogsFixed;
    private GameObject cogsBroken;
    private GameObject driveBeltFixed;
    private GameObject driveBeltBroken;
    private GameObject pump;
    private GameObject stoveEmpty;
    private GameObject stovePartial;
    private GameObject stoveFull;
    @Inject
    private Notifier notifier;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private BlastFurnaceClickBoxOverlay clickBoxOverlay;
    @Inject
    private BlastFurnaceTrainerConfig config;
    @Inject
    private Client client;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.clickBoxOverlay);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.clickBoxOverlay);
        this.westPipesFixed = null;
        this.eastPipesFixed = null;
        this.westPipesBroken = null;
        this.eastPipesBroken = null;
        this.cogsFixed = null;
        this.cogsBroken = null;
        this.driveBeltFixed = null;
        this.driveBeltBroken = null;
        this.pump = null;
        this.stoveEmpty = null;
        this.stovePartial = null;
        this.stoveFull = null;
    }

    @Provides
    BlastFurnaceTrainerConfig provideConfig(ConfigManager configManager) {
        return (BlastFurnaceTrainerConfig)configManager.getConfig(BlastFurnaceTrainerConfig.class);
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject gameObject = event.getGameObject();
        switch (gameObject.getId()) {
            case 9116: {
                this.westPipesFixed = gameObject;
                break;
            }
            case 9117: {
                this.westPipesBroken = gameObject;
                break;
            }
            case 9120: {
                this.eastPipesFixed = gameObject;
                break;
            }
            case 9121: {
                this.eastPipesBroken = gameObject;
                break;
            }
            case 9102: {
                this.driveBeltFixed = gameObject;
                break;
            }
            case 9103: {
                this.driveBeltBroken = gameObject;
                break;
            }
            case 9104: {
                this.cogsFixed = gameObject;
                break;
            }
            case 9105: {
                this.cogsBroken = gameObject;
                break;
            }
            case 9090: {
                this.pump = gameObject;
                break;
            }
            case 9085: {
                if (this.config.notifyEmptyStove()) {
                    this.notifier.notify("The Blast Furnace Stove needs Coke.");
                }
                this.stoveEmpty = gameObject;
                break;
            }
            case 9086: {
                this.stovePartial = gameObject;
                break;
            }
            case 9087: {
                this.stoveFull = gameObject;
            }
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        GameObject gameObject = event.getGameObject();
        switch (gameObject.getId()) {
            case 9116: {
                this.westPipesFixed = null;
                break;
            }
            case 9117: {
                this.westPipesBroken = null;
                break;
            }
            case 9120: {
                this.eastPipesFixed = null;
                break;
            }
            case 9121: {
                this.eastPipesBroken = null;
                break;
            }
            case 9102: {
                this.driveBeltFixed = null;
                break;
            }
            case 9103: {
                this.driveBeltBroken = null;
                break;
            }
            case 9104: {
                this.cogsFixed = null;
                break;
            }
            case 9105: {
                this.cogsBroken = null;
                break;
            }
            case 9090: {
                this.pump = null;
                break;
            }
            case 9085: {
                this.stoveEmpty = null;
                break;
            }
            case 9086: {
                this.stovePartial = null;
                break;
            }
            case 9087: {
                this.stoveFull = null;
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            this.westPipesFixed = null;
            this.eastPipesFixed = null;
            this.westPipesBroken = null;
            this.eastPipesBroken = null;
            this.cogsFixed = null;
            this.cogsBroken = null;
            this.driveBeltFixed = null;
            this.driveBeltBroken = null;
            this.pump = null;
            this.stoveEmpty = null;
            this.stovePartial = null;
            this.stoveFull = null;
        }
    }

    GameObject getWestPipesFixed() {
        return this.westPipesFixed;
    }

    GameObject getWestPipesBroken() {
        return this.westPipesBroken;
    }

    GameObject getEastPipesFixed() {
        return this.eastPipesFixed;
    }

    GameObject getEastPipesBroken() {
        return this.eastPipesBroken;
    }

    GameObject getCogsFixed() {
        return this.cogsFixed;
    }

    GameObject getCogsBroken() {
        return this.cogsBroken;
    }

    GameObject getDriveBeltFixed() {
        return this.driveBeltFixed;
    }

    GameObject getDriveBeltBroken() {
        return this.driveBeltBroken;
    }

    GameObject getPump() {
        return this.pump;
    }

    GameObject getStoveEmpty() {
        return this.stoveEmpty;
    }

    GameObject getStovePartial() {
        return this.stovePartial;
    }

    GameObject getStoveFull() {
        return this.stoveFull;
    }
}

