/*
 * Decompiled with CFR 0.152.
 */
package herb10hp.blastfurnacetrainer;

import herb10hp.blastfurnacetrainer.BlastFurnaceTrainerConfig;
import herb10hp.blastfurnacetrainer.BlastFurnaceTrainerPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;

class BlastFurnaceClickBoxOverlay
extends Overlay {
    private static final int MAX_DISTANCE = 2350;
    private final Client client;
    private final BlastFurnaceTrainerPlugin plugin;
    private final BlastFurnaceTrainerConfig config;

    @Inject
    private BlastFurnaceClickBoxOverlay(Client client, BlastFurnaceTrainerPlugin plugin, BlastFurnaceTrainerConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.showCrafting()) {
            if (this.plugin.getWestPipesFixed() != null) {
                this.renderObject(this.plugin.getWestPipesFixed(), graphics, Color.GREEN);
            }
            if (this.plugin.getWestPipesBroken() != null) {
                this.renderObject(this.plugin.getWestPipesBroken(), graphics, Color.RED);
            }
            if (this.plugin.getEastPipesFixed() != null) {
                this.renderObject(this.plugin.getEastPipesFixed(), graphics, Color.GREEN);
            }
            if (this.plugin.getEastPipesBroken() != null) {
                this.renderObject(this.plugin.getEastPipesBroken(), graphics, Color.RED);
            }
            if (this.plugin.getDriveBeltFixed() != null) {
                this.renderObject(this.plugin.getDriveBeltFixed(), graphics, Color.GREEN);
            }
            if (this.plugin.getDriveBeltBroken() != null) {
                this.renderObject(this.plugin.getDriveBeltBroken(), graphics, Color.RED);
            }
            if (this.plugin.getCogsFixed() != null) {
                this.renderObject(this.plugin.getCogsFixed(), graphics, Color.GREEN);
            }
            if (this.plugin.getCogsBroken() != null) {
                this.renderObject(this.plugin.getCogsBroken(), graphics, Color.RED);
            }
        }
        if (this.config.showStove()) {
            if (this.plugin.getStoveEmpty() != null) {
                this.renderObject(this.plugin.getStoveEmpty(), graphics, Color.RED);
            }
            if (this.plugin.getStovePartial() != null) {
                this.renderObject(this.plugin.getStovePartial(), graphics, Color.YELLOW);
            }
            if (this.plugin.getStoveFull() != null) {
                this.renderObject(this.plugin.getStoveFull(), graphics, Color.GREEN);
            }
        }
        if (this.config.showPump() && this.plugin.getPump() != null) {
            this.renderObject(this.plugin.getPump(), graphics, Color.GREEN);
        }
        return null;
    }

    private void renderObject(GameObject object, Graphics2D graphics, Color color) {
        Shape objectClickbox;
        LocalPoint localLocation = this.client.getLocalPlayer().getLocalLocation();
        Point mousePosition = this.client.getMouseCanvasPosition();
        LocalPoint location = object.getLocalLocation();
        if (localLocation.distanceTo(location) <= 2350 && (objectClickbox = object.getClickbox()) != null) {
            if (objectClickbox.contains(mousePosition.getX(), mousePosition.getY())) {
                graphics.setColor(color.darker());
            } else {
                graphics.setColor(color);
            }
            graphics.draw(objectClickbox);
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 20));
            graphics.fill(objectClickbox);
        }
    }
}

