/*
 * Decompiled with CFR 0.152.
 */
package com.healthnotifier;

import com.google.inject.Provides;
import com.healthnotifier.HealthNotifierConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.InteractingChanged;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.NPCManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Target Health Notifier", description="Notifies you when the mob you are attacking is below a certain health.", tags={"target", "notify", "hp", "dead", "kill", "enemy"})
public class HealthNotifierPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(HealthNotifierPlugin.class);
    @Inject
    private NPCManager npcManager;
    @Inject
    private Client client;
    @Inject
    private Notifier notifier;
    @Inject
    private HealthNotifierConfig config;
    public static final String CONFIG_GROUP = "healthnotifier";
    private NPC currentNpc;
    private boolean hasNotified = false;
    private List<String> npcNames = new ArrayList<String>();
    private int healthThreshold = 0;

    @Provides
    public HealthNotifierConfig getConfig(ConfigManager configManager) {
        return (HealthNotifierConfig)configManager.getConfig(HealthNotifierConfig.class);
    }

    public void startUp() {
        this.loadConfigValues();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals(CONFIG_GROUP)) {
            return;
        }
        this.loadConfigValues();
    }

    private void loadConfigValues() {
        this.npcNames = Arrays.stream(this.config.NPCName().split("[,\n]")).map(name -> name.toLowerCase().trim()).filter(name -> !name.isEmpty()).collect(Collectors.toList());
        this.currentNpc = null;
        if (this.client.getLocalPlayer() != null) {
            this.trackTarget(this.client.getLocalPlayer().getInteracting());
        }
        if (this.healthThreshold != this.config.specifiedHealth()) {
            this.healthThreshold = this.config.specifiedHealth();
            this.hasNotified = false;
        }
    }

    @Subscribe
    public void onGameTick(GameTick e) {
        if (this.currentNpc == null || this.hasNotified) {
            return;
        }
        if (this.healthThreshold == 0) {
            if (this.currentNpc.getHealthRatio() == 0) {
                this.notifier.notify("Your target is dead.");
                this.hasNotified = true;
            }
            return;
        }
        int npcHealth = this.calculateHealth(this.currentNpc);
        if (npcHealth == -1) {
            return;
        }
        if (npcHealth <= this.healthThreshold) {
            this.notifier.notify("Your target is below " + this.healthThreshold + " health.");
            this.hasNotified = true;
        }
    }

    private int calculateHealth(NPC target) {
        if (target == null || target.getName() == null) {
            return -1;
        }
        int healthScale = target.getHealthScale();
        int healthRatio = target.getHealthRatio();
        Integer maxHealth = this.npcManager.getHealth(target.getId());
        if (healthRatio < 0 || healthScale <= 0 || maxHealth == null) {
            return -1;
        }
        return (int)((float)(maxHealth * healthRatio / healthScale) + 0.5f);
    }

    @Subscribe
    public void onActorDeath(ActorDeath e) {
        if (e.getActor() == this.currentNpc && !this.hasNotified) {
            this.notifier.notify("Your target is dead.");
            this.hasNotified = true;
        }
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged e) {
        if (e.getSource() != this.client.getLocalPlayer()) {
            return;
        }
        this.trackTarget(e.getTarget());
    }

    private void trackTarget(Actor target) {
        if (target != this.currentNpc) {
            this.currentNpc = target instanceof NPC && (this.npcNames.isEmpty() || this.npcNames.contains(Text.standardize((String)target.getName()))) ? (NPC)target : null;
            this.hasNotified = false;
        }
    }
}

