/*
 * Decompiled with CFR 0.152.
 */
package com.dataexport.ui;

import com.dataexport.DataExport;
import com.dataexport.DataExportConfig;
import com.dataexport.DataExportPlugin;
import com.dataexport.ui.DataExportPluginPanel;
import com.dataexport.ui.Tab;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;

public class DataExportTabPanel
extends JPanel {
    private static final Color COLOR = ColorScheme.DARK_GRAY_COLOR;
    private static final Color HOVER_COLOR = ColorScheme.DARKER_GRAY_HOVER_COLOR;
    private final ItemManager itemManager;
    private final DataExportPlugin plugin;
    private final DataExportPluginPanel panel;
    private final DataExportConfig config;
    private final DataExport dataExport;
    public String title;
    public String status;
    public boolean visibility = true;
    JLabel readyLabel;
    JButton buttonExport;
    JButton buttonDownload;

    DataExportTabPanel(final DataExportPlugin plugin, DataExportPluginPanel panel, DataExportConfig config, DataExport dataExport, ItemManager itemManager, Tab tab, String title, final String container, String status) {
        this.plugin = plugin;
        this.panel = panel;
        this.config = config;
        this.dataExport = dataExport;
        this.itemManager = itemManager;
        this.title = title;
        this.status = status;
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(5, 10, 5, 10));
        JPanel panelWrapper = new JPanel(new BorderLayout());
        panelWrapper.setLayout(new GridLayout(1, 2));
        panelWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        panelWrapper.setBorder(new EmptyBorder(5, 10, 5, 10));
        panelWrapper.setVisible(true);
        JPanel leftContainer = new JPanel();
        leftContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        leftContainer.setLayout(new BorderLayout());
        JLabel titleLabel = new JLabel(title);
        titleLabel.setForeground(Color.WHITE);
        JLabel iconLabel = new JLabel();
        iconLabel.setMinimumSize(new Dimension(36, 32));
        itemManager.getImage(tab.getItemID()).addTo(iconLabel);
        leftContainer.add((Component)titleLabel, "North");
        leftContainer.add((Component)iconLabel, "South");
        JPanel rightContainer = new JPanel();
        rightContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        rightContainer.setLayout(new GridLayout(2, 1));
        this.readyLabel = new JLabel(status);
        this.readyLabel.setForeground(Color.RED);
        this.readyLabel.setFont(FontManager.getRunescapeSmallFont());
        JPanel buttonContainer = new JPanel();
        buttonContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        buttonContainer.setLayout(new GridLayout(1, 2));
        buttonContainer.setBorder(new EmptyBorder(5, 10, 5, 10));
        this.buttonExport = new JButton();
        this.buttonExport.setText("Export");
        this.buttonExport.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.buttonExport.setBorder(new EmptyBorder(3, 7, 3, 7));
        this.buttonExport.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DataExportTabPanel.this.buttonExport.setBackground(ColorScheme.BRAND_ORANGE);
                plugin.exportContainer(container);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DataExportTabPanel.this.buttonExport.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                DataExportTabPanel.this.buttonExport.setBackground(HOVER_COLOR);
                DataExportTabPanel.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DataExportTabPanel.this.buttonExport.setBackground(COLOR);
                DataExportTabPanel.this.setCursor(new Cursor(0));
            }
        });
        this.buttonDownload = new JButton();
        this.buttonDownload.setText("Download");
        this.buttonDownload.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.buttonDownload.setBorder(new EmptyBorder(3, 7, 3, 7));
        this.buttonDownload.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DataExportTabPanel.this.buttonDownload.setBackground(ColorScheme.BRAND_ORANGE);
                plugin.downloadContainer(container);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DataExportTabPanel.this.buttonDownload.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                DataExportTabPanel.this.buttonDownload.setBackground(HOVER_COLOR);
                DataExportTabPanel.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DataExportTabPanel.this.buttonDownload.setBackground(COLOR);
                DataExportTabPanel.this.setCursor(new Cursor(0));
            }
        });
        buttonContainer.add(this.buttonExport);
        buttonContainer.add(this.buttonDownload);
        rightContainer.add(this.readyLabel);
        rightContainer.add(buttonContainer);
        panelWrapper.add((Component)leftContainer, "West");
        panelWrapper.add((Component)rightContainer, "Center");
        this.add(panelWrapper);
        this.updateVisibility();
    }

    private void updateVisibility() {
        if (!this.config.displayExport()) {
            this.buttonExport.setVisible(false);
        }
        if (!this.config.displayDownload()) {
            this.buttonDownload.setVisible(false);
        }
    }

    public void updateStatus(String status) {
        this.readyLabel.setText(status);
        if (status.equals("Visit a bank!")) {
            this.readyLabel.setForeground(Color.RED);
        } else {
            this.readyLabel.setForeground(Color.GREEN);
        }
    }

    @Override
    public String toString() {
        return this.title + ", " + this.isVisible();
    }

    public String getTitle() {
        return this.title;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean isVisibility() {
        return this.visibility;
    }

    public void setVisibility(boolean visibility) {
        this.visibility = visibility;
    }
}

