/*
 * Decompiled with CFR 0.152.
 */
package com.dataexport.ui;

import com.dataexport.DataExport;
import com.dataexport.DataExportConfig;
import com.dataexport.DataExportPlugin;
import com.dataexport.ui.DataExportTabPanel;
import com.dataexport.ui.Tab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataExportPluginPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(DataExportPluginPanel.class);
    final JPanel wrapperPanel = new JPanel();
    private final ItemManager itemManager;
    private final DataExportPlugin plugin;
    private final DataExportConfig config;
    private final DataExport dataExport;
    private JPanel containerContainer = new JPanel();
    private Map<Tab, DataExportTabPanel> containers = new LinkedHashMap<Tab, DataExportTabPanel>();

    public DataExportPluginPanel(ItemManager itemManager, DataExportPlugin plugin, DataExportConfig config, DataExport dataExport) {
        super(true);
        this.itemManager = itemManager;
        this.plugin = plugin;
        this.config = config;
        this.dataExport = dataExport;
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(7, 7, 7, 7));
        this.wrapperPanel.setLayout(new BoxLayout(this.wrapperPanel, 1));
        this.wrapperPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.containerContainer.setLayout(new GridLayout(0, 1, 0, 8));
        this.containerContainer.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.containerContainer.setVisible(true);
        Arrays.asList(Tab.CONTAINER_TABS).forEach(t -> {
            DataExportTabPanel p = new DataExportTabPanel(plugin, this, config, dataExport, itemManager, (Tab)((Object)t), t.getName(), t.getFilePrefix(), "Not ready");
            this.containers.put((Tab)((Object)t), p);
        });
        this.containers.forEach((tab, panel) -> this.containerContainer.add((Component)panel));
        this.wrapperPanel.add(this.containerContainer);
        this.add(this.wrapperPanel);
        this.updateVisibility();
        this.rebuild();
    }

    public void updateVisibility() {
        this.containerContainer.removeAll();
        log.debug("Containers: {}", this.containers.values());
        this.containers.forEach((t, p) -> {
            if (p.isVisibility()) {
                this.containerContainer.add((Component)p);
            }
        });
        this.rebuild();
    }

    public void setVisibility(Tab tab, boolean visibility) {
        log.debug("Containers: {}", this.containers.values());
        LinkedHashMap<Tab, DataExportTabPanel> containersTemp = new LinkedHashMap<Tab, DataExportTabPanel>();
        this.containers.forEach((t, p) -> {
            if (p.isVisibility() && t.getName().compareTo(p.getTitle()) != 0) {
                this.setVisibility(Tab.ALL_ITEMS, true);
            }
            if (tab.getName().equals(t.getName())) {
                DataExportTabPanel panel = this.containers.get((Object)tab);
                panel.setVisibility(visibility);
                containersTemp.put((Tab)((Object)t), panel);
            }
            containersTemp.put((Tab)((Object)t), (DataExportTabPanel)p);
        });
        this.containers = containersTemp;
    }

    public void updateTab(String container, String newStatus) {
        this.containers.forEach((tab, panel) -> {
            if (panel.getTitle().equals(container)) {
                panel.updateStatus(newStatus);
            }
            this.containers.put((Tab)((Object)tab), (DataExportTabPanel)panel);
        });
        this.containers.forEach((tab, panel) -> this.containerContainer.add((Component)panel));
        this.rebuild();
    }

    public void rebuild() {
        this.revalidate();
        this.repaint();
    }
}

