/*
 * Decompiled with CFR 0.152.
 */
package com.dataexport.localstorage;

import com.dataexport.DataExportConfig;
import com.dataexport.DataExportItem;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import net.runelite.client.RuneLite;
import net.runelite.http.api.RuneLiteAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataWriter {
    private static final Logger log = LoggerFactory.getLogger(DataWriter.class);
    private static final String FILE_EXTENSION_JSON = ".json";
    private static final String FILE_EXTENSION_CSV = ".csv";
    private static final File LOOT_RECORD_DIR = new File(RuneLite.RUNELITE_DIR, "Data Exports");
    private File playerFolder = LOOT_RECORD_DIR;
    private String name;
    private DataExportConfig config;

    public DataWriter(DataExportConfig config) {
        this.config = config;
        LOOT_RECORD_DIR.mkdir();
    }

    private static String fileNameJSON(String dataContainerName) {
        return dataContainerName.toLowerCase().trim() + FILE_EXTENSION_JSON;
    }

    private static String fileNameCSV(String dataContainerName) {
        return dataContainerName.toLowerCase().trim() + FILE_EXTENSION_CSV;
    }

    public void setPlayerUsername(String username) {
        if (username.equalsIgnoreCase(this.name)) {
            return;
        }
        this.playerFolder = new File(LOOT_RECORD_DIR, username);
        this.playerFolder.mkdir();
        this.name = username;
    }

    public void writeFile(String dataContainer, Map<Integer, DataExportItem> items) {
        if (this.config.downloadJSON()) {
            this.writeJSON(dataContainer, items);
        }
        if (this.config.downloadCSV()) {
            this.writeCSV(dataContainer, items);
        }
    }

    public synchronized boolean writeJSON(String dataContainer, Map<Integer, DataExportItem> items) {
        String fileName = DataWriter.fileNameJSON(dataContainer);
        File lootFile = new File(this.playerFolder, fileName);
        try {
            BufferedWriter file = new BufferedWriter(new FileWriter(String.valueOf(lootFile), false));
            for (Map.Entry<Integer, DataExportItem> item : items.entrySet()) {
                String dataAsString = RuneLiteAPI.GSON.toJson((Object)item.getValue());
                file.append(dataAsString);
                file.newLine();
            }
            file.close();
            return true;
        }
        catch (IOException ioe) {
            log.warn("Error rewriting data to file {}: {}", (Object)fileName, (Object)ioe.getMessage());
            return false;
        }
    }

    public synchronized boolean writeCSV(String dataContainer, Map<Integer, DataExportItem> items) {
        String fileName = DataWriter.fileNameCSV(dataContainer);
        File lootFile = new File(this.playerFolder, fileName);
        try {
            BufferedWriter file = new BufferedWriter(new FileWriter(String.valueOf(lootFile), false));
            for (Map.Entry<Integer, DataExportItem> item : items.entrySet()) {
                String line = item.getValue().getCSV();
                file.append(line);
                file.newLine();
            }
            file.close();
            return true;
        }
        catch (IOException ioe) {
            log.warn("Error rewriting data to file {}: {}", (Object)fileName, (Object)ioe.getMessage());
            return false;
        }
    }
}

