/*
 * Decompiled with CFR 0.152.
 */
package com.dataexport;

import com.dataexport.DataExport;
import com.dataexport.DataExportConfig;
import com.dataexport.DataExportItem;
import com.dataexport.localstorage.DataWriter;
import com.dataexport.ui.DataExportPluginPanel;
import com.dataexport.ui.Tab;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Data Export")
public class DataExportPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DataExportPlugin.class);
    private static final Set<Integer> CONTAINERS = ImmutableSet.of((Object)InventoryID.BANK.getId(), (Object)InventoryID.SEED_VAULT.getId(), (Object)InventoryID.INVENTORY.getId(), (Object)InventoryID.EQUIPMENT.getId());
    public DataWriter dataWriter;
    public DataExport dataExport;
    public Map<Tab, Boolean> visibilityMap = new LinkedHashMap<Tab, Boolean>();
    int hashAllItems = -1;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ItemManager itemManager;
    @Inject
    private SkillIconManager skillIconManager;
    @Inject
    private DataExportConfig config;
    @Inject
    private KeyManager keyManager;
    private DataExportPluginPanel panel;
    private NavigationButton navButton;
    private int hashBank = -1;
    private int hashSeedVault = -1;
    private int hashInventory = -1;
    private int hashEquipment = -1;
    private int hashSkills = -1;
    private int lastTick = -1;

    @Provides
    DataExportConfig provideConfig(ConfigManager configManager) {
        return (DataExportConfig)configManager.getConfig(DataExportConfig.class);
    }

    protected void startUp() throws Exception {
        log.debug("Data Export started!");
        this.dataExport = new DataExport(this.client, this.config, this.itemManager, this);
        this.dataWriter = new DataWriter(this.config);
        Arrays.asList(Tab.CONTAINER_TABS).forEach(t -> this.visibilityMap.put((Tab)((Object)t), true));
        this.panel = new DataExportPluginPanel(this.itemManager, this, this.config, this.dataExport);
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"/data_export_icon.png");
        this.navButton = NavigationButton.builder().tooltip("Data Exporter").icon(icon).priority(6).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.clientThread.invokeLater(() -> {
            switch (this.client.getGameState()) {
                case STARTING: 
                case UNKNOWN: {
                    return false;
                }
            }
            SwingUtilities.invokeLater(() -> this.panel.rebuild());
            return true;
        });
    }

    protected void shutDown() throws Exception {
        log.debug("Data Export stopped!");
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("dataexport")) {
            return;
        }
        HashMap<Integer, DataExportItem> mapBlank = new HashMap<Integer, DataExportItem>();
        if (!this.config.includeBank()) {
            this.dataExport.setMapBank(mapBlank);
            this.visibilityMap.put(Tab.BANK, false);
        } else {
            this.visibilityMap.put(Tab.BANK, true);
        }
        if (!this.config.includeSeedVault()) {
            this.dataExport.setMapSeedVault(mapBlank);
            this.visibilityMap.put(Tab.SEED_VAULT, false);
        } else {
            this.visibilityMap.put(Tab.SEED_VAULT, true);
        }
        if (!this.config.includeInventory()) {
            this.dataExport.setMapInventory(mapBlank);
            this.visibilityMap.put(Tab.INVENTORY, false);
        } else {
            this.visibilityMap.put(Tab.INVENTORY, true);
        }
        if (!this.config.includeEquipment()) {
            this.dataExport.setMapEquipment(mapBlank);
            this.visibilityMap.put(Tab.EQUIPMENT, false);
        } else {
            this.visibilityMap.put(Tab.EQUIPMENT, true);
        }
        this.visibilityMap.forEach((t, v) -> this.panel.setVisibility((Tab)((Object)t), (boolean)v));
        this.panel.updateVisibility();
        this.panel.rebuild();
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        int tick = this.client.getTickCount();
        if (tick == this.lastTick) {
            return;
        }
        this.lastTick = tick;
        ItemContainer itemContainer = event.getItemContainer();
        int itemContainerId = event.getContainerId();
        if (itemContainer == null) {
            return;
        }
        if (!CONTAINERS.contains(itemContainerId)) {
            return;
        }
        Item[] widgetItems = itemContainer.getItems();
        if (widgetItems == null || widgetItems.length == 0) {
            return;
        }
        int hash = this.hashItems(widgetItems);
        LinkedHashMap<Integer, DataExportItem> mapContainer = new LinkedHashMap<Integer, DataExportItem>();
        for (Item widgetItem : widgetItems) {
            ItemComposition itemComposition = this.itemManager.getItemComposition(widgetItem.getId());
            String name = itemComposition.getName();
            int quantity = widgetItem.getQuantity();
            int id = widgetItem.getId();
            if (itemComposition.getPlaceholderTemplateId() != -1) {
                quantity = 0;
            }
            if (name == null || quantity <= 0 || id == -1) continue;
            DataExportItem item = new DataExportItem(name, quantity, id);
            mapContainer.putIfAbsent(id, item);
            this.dataExport.addItemAll(id, item);
        }
        if (mapContainer.size() < 2) {
            return;
        }
        if (itemContainerId == InventoryID.BANK.getId() && this.config.includeBank() && hash != this.hashBank) {
            log.debug("Bank hash: " + this.hashBank + "   ->   " + hash);
            this.hashBank = hash;
            this.updateBankData(mapContainer);
        } else if (itemContainerId == InventoryID.SEED_VAULT.getId() && this.config.includeSeedVault() && hash != this.hashSeedVault) {
            log.debug("Seed vault hash: " + this.hashSeedVault + "   ->   " + hash);
            this.hashSeedVault = hash;
            this.updateSeedVaultData(mapContainer);
        } else if (itemContainerId == InventoryID.INVENTORY.getId() && this.config.includeInventory() && hash != this.hashInventory) {
            log.debug("Inventory hash: " + this.hashInventory + "   ->   " + hash);
            this.hashInventory = hash;
            this.updateInventoryData(mapContainer);
        } else if (itemContainerId == InventoryID.EQUIPMENT.getId() && this.config.includeEquipment() && hash != this.hashEquipment) {
            log.debug("Equipment hash: " + this.hashEquipment + "   ->   " + hash);
            this.hashEquipment = hash;
            this.updateEquipmentData(mapContainer);
        }
    }

    private void updateBankData(Map<Integer, DataExportItem> map) {
        this.dataExport.setMapBank(map);
        this.dataWriter.writeJSON("container_bank", map);
        log.debug("Bank Container Map: {}", map);
        if (map.size() > 1) {
            this.panel.updateTab("Bank", "Ready");
        } else {
            this.panel.updateTab("Bank", "Visit a bank!");
        }
    }

    private void updateSeedVaultData(Map<Integer, DataExportItem> map) {
        this.dataExport.setMapSeedVault(map);
        this.dataWriter.writeJSON("container_seed_vault", map);
        log.debug("Seed Vault Container Map: {}", map);
        if (map.size() > 1) {
            this.panel.updateTab("Seed Vault", "Ready");
        } else {
            this.panel.updateTab("Seed Vault", "Inventory empty");
        }
    }

    private void updateInventoryData(Map<Integer, DataExportItem> map) {
        this.dataExport.setMapInventory(map);
        this.dataWriter.writeJSON("container_inventory", map);
        log.debug("Inventory Container Map: {}", map);
        if (map.size() > 1) {
            this.panel.updateTab("Inventory", "Ready");
        } else {
            this.panel.updateTab("Inventory", "No items equipped");
        }
    }

    private void updateEquipmentData(Map<Integer, DataExportItem> map) {
        this.dataExport.setMapEquipment(map);
        this.dataWriter.writeJSON("container_equipment", map);
        log.debug("Equipment Container Map: {}", map);
        if (map.size() > 1) {
            this.panel.updateTab("Equipment", "Ready");
        } else {
            this.panel.updateTab("Equipment", "No items equipped");
        }
    }

    public void exportContainer(String container) {
        if (container.equals("container_all_items")) {
            this.dataExport.exportContainer(container);
        } else if (container.equals("container_bank")) {
            this.dataExport.exportContainer(container);
        } else if (container.equals("container_seed_vault")) {
            this.dataExport.exportContainer(container);
        } else if (container.equals("container_inventory")) {
            this.dataExport.exportContainer(container);
        } else if (container.equals("container_equipment")) {
            this.dataExport.exportContainer(container);
        }
    }

    public void downloadContainer(String container) {
        if (container.equals("container_all_items")) {
            this.dataWriter.writeFile(container, this.dataExport.getMapItems());
        } else if (container.equals("container_bank")) {
            this.dataWriter.writeFile(container, this.dataExport.getMapBank());
        } else if (container.equals("container_seed_vault")) {
            this.dataWriter.writeFile(container, this.dataExport.getMapSeedVault());
        } else if (container.equals("container_inventory")) {
            this.dataWriter.writeFile(container, this.dataExport.getMapInventory());
        } else if (container.equals("container_equipment")) {
            this.dataWriter.writeFile(container, this.dataExport.getMapEquipment());
        }
    }

    private int hashItems(Item[] items) {
        HashMap<Integer, Integer> mapCheck = new HashMap<Integer, Integer>(items.length);
        for (Item item : items) {
            mapCheck.put(item.getId(), item.getQuantity());
        }
        return mapCheck.hashCode();
    }
}

