/*
 * Decompiled with CFR 0.152.
 */
package com.dataexport;

import com.dataexport.DataExportConfig;
import com.dataexport.DataExportItem;
import com.dataexport.DataExportPlugin;
import com.dataexport.ui.DataExportPluginPanel;
import com.google.gson.Gson;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.client.game.ItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataExport {
    private static final Logger log = LoggerFactory.getLogger(DataExport.class);
    private final Client client;
    private final DataExportConfig config;
    private final ItemManager itemManager;
    int hashAllItems;
    private Map<Integer, DataExportItem> mapBank;
    private Map<Integer, DataExportItem> mapSeedVault;
    private Map<Integer, DataExportItem> mapInventory;
    private Map<Integer, DataExportItem> mapEquipment;
    private Map<Integer, DataExportItem> mapSkills;
    private Map<Integer, DataExportItem> mapItems;
    private ArrayList<Integer> arrayListItems;
    private DataExportPluginPanel panel;
    private DataExportPlugin plugin;

    public DataExport(Client client, DataExportConfig config, ItemManager itemManager, DataExportPlugin plugin) {
        this.client = client;
        this.config = config;
        this.itemManager = itemManager;
        this.plugin = plugin;
        this.hashAllItems = -1;
        this.mapBank = new LinkedHashMap<Integer, DataExportItem>();
        this.mapSeedVault = new LinkedHashMap<Integer, DataExportItem>();
        this.mapInventory = new LinkedHashMap<Integer, DataExportItem>();
        this.mapEquipment = new LinkedHashMap<Integer, DataExportItem>();
        this.mapItems = new LinkedHashMap<Integer, DataExportItem>();
        this.arrayListItems = new ArrayList();
    }

    public void exportContainer(String container) {
        Map<Integer, DataExportItem> map = container.equals("container_all_items") ? this.mapItems : (container.equals("container_bank") ? this.mapBank : (container.equals("container_seed_vault") ? this.mapSeedVault : (container.equals("container_inventory") ? this.mapInventory : (container.equals("container_equipment") ? this.mapEquipment : (container.equals("container_all_items") ? this.mapItems : new LinkedHashMap<Integer, DataExportItem>())))));
        if (map == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            Gson gson = new Gson();
            String json = gson.toJson(map.values());
            StringSelection contents = new StringSelection(json);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(contents, null);
            JOptionPane.showMessageDialog((Component)((Object)this.panel), "Container data was copied to clipboard.", "Export Setup Succeeded", -1);
        });
    }

    public void rebuildSkillArrayList() {
    }

    private int getTotalQuantityForItem(int id) {
        int total = 0;
        if (this.mapBank.containsKey(id) && this.mapBank.size() > 1) {
            total += this.mapBank.get(id).getQuantity();
        }
        if (this.mapSeedVault.containsKey(id) && this.mapSeedVault.size() > 1) {
            total += this.mapSeedVault.get(id).getQuantity();
        }
        if (this.mapInventory.containsKey(id) && this.mapInventory.size() > 1) {
            total += this.mapInventory.get(id).getQuantity();
        }
        if (this.mapEquipment.containsKey(id) && this.mapEquipment.size() > 1) {
            total += this.mapEquipment.get(id).getQuantity();
        }
        return total;
    }

    public void addItemAll(int id, DataExportItem item) {
        DataExportItem item2 = this.mapItems.get(id);
        if (item2 != null) {
            return;
        }
        log.info("Adding to list: " + item.getName());
        this.mapItems.put(id, item);
    }

    public Map<Integer, DataExportItem> getMapBank() {
        return this.mapBank;
    }

    public void setMapBank(Map<Integer, DataExportItem> mapBank) {
        this.mapBank = mapBank;
    }

    public Map<Integer, DataExportItem> getMapSeedVault() {
        return this.mapSeedVault;
    }

    public void setMapSeedVault(Map<Integer, DataExportItem> mapSeedVault) {
        this.mapSeedVault = mapSeedVault;
    }

    public Map<Integer, DataExportItem> getMapInventory() {
        return this.mapInventory;
    }

    public void setMapInventory(Map<Integer, DataExportItem> mapInventory) {
        this.mapInventory = mapInventory;
    }

    public Map<Integer, DataExportItem> getMapEquipment() {
        return this.mapEquipment;
    }

    public void setMapEquipment(Map<Integer, DataExportItem> mapEquipment) {
        this.mapEquipment = mapEquipment;
    }

    public Map<Integer, DataExportItem> getMapSkills() {
        return this.mapSkills;
    }

    public void setMapSkills(Map<Integer, DataExportItem> mapSkills) {
        this.mapSkills = mapSkills;
    }

    public Map<Integer, DataExportItem> getMapItems() {
        return this.mapItems;
    }

    public void setMapItems(Map<Integer, DataExportItem> mapItems) {
        this.mapItems = mapItems;
    }

    public ArrayList<Integer> getArrayListItems() {
        return this.arrayListItems;
    }

    public void setArrayListItems(ArrayList<Integer> arrayListItems) {
        this.arrayListItems = arrayListItems;
    }
}

