/*
 * Decompiled with CFR 0.152.
 */
package com.pip;

import com.google.inject.Provides;
import com.pip.PictureInPictureConfig;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Skill;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.ui.FontManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Picture In Picture", description="Displays picture in picture mode when RuneLite is not in focus", tags={"pip", "picture", "display", "afk"})
public class PictureInPicturePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PictureInPicturePlugin.class);
    private static boolean focused = true;
    private static boolean pipUp = false;
    private JFrame pipFrame = null;
    private JLabel lbl = null;
    private pipBar leftBar;
    private pipBar rightBar;
    private Skill leftSkill;
    private Skill rightSkill;
    private Point pipPoint = new Point(0, 0);
    private int clientTick = 0;
    private int pipWidth;
    private int pipHeight;
    private double pipScale;
    private int maxHealth;
    private int currentHealth;
    private int maxPrayer;
    private int currentPrayer;
    private Color[] healthColor;
    private static final Color PRAYER_COLOR = new Color(32, 160, 160);
    private static final Color PRAYER_BG_COLOR = new Color(10, 50, 50);
    private static final Color[] PRAYER = new Color[]{PRAYER_COLOR, PRAYER_BG_COLOR};
    private static final Color HEALTH_COLOR = new Color(160, 32, 0);
    private static final Color HEALTH_BG_COLOR = new Color(50, 10, 0);
    private static final Color[] HEALTH = new Color[]{HEALTH_COLOR, HEALTH_BG_COLOR};
    private static final Color POISONED_COLOR = new Color(0, 160, 0);
    private static final Color POISONED_BG_COLOR = new Color(0, 50, 0);
    private static final Color[] POISONED = new Color[]{POISONED_COLOR, POISONED_BG_COLOR};
    private static final Color VENOMED_COLOR = new Color(0, 90, 0);
    private static final Color VENOMED_BG_COLOR = new Color(0, 25, 0);
    private static final Color[] VENOMED = new Color[]{VENOMED_COLOR, VENOMED_BG_COLOR};
    private static final Color DISEASE_COLOR = new Color(200, 160, 64);
    private static final Color DISEASE_BG_COLOR = new Color(63, 50, 20);
    private static final Color[] DISEASE = new Color[]{DISEASE_COLOR, DISEASE_BG_COLOR};
    @Inject
    private ClientUI clientUi;
    @Inject
    private Client client;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private DrawManager drawManager;
    @Inject
    private PictureInPictureConfig config;
    @Inject
    private ConfigManager configManager;

    protected void startUp() throws Exception {
        log.debug("PIP started!");
    }

    protected void shutDown() throws Exception {
        log.debug("PIP stopped!");
        this.destroyPip();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN) {
            this.destroyPip();
        }
    }

    @Subscribe
    public void onClientTick(ClientTick event) {
        Window window;
        if (!focused && (window = FocusManager.getCurrentManager().getActiveWindow()) == null && this.pipFrame == null) {
            this.updateHitpoints();
            this.updatePrayer();
            this.initializePip();
        }
        if (this.clientTick % this.config.redrawRate().getId() == 0) {
            this.clientTick = 0;
            if (focused != this.clientUi.isFocused() && (focused = this.clientUi.isFocused())) {
                this.destroyPip();
            }
            if (!focused && this.pipFrame != null && pipUp) {
                this.updatePip();
            }
        }
        ++this.clientTick;
        if (!focused && this.pipFrame != null && pipUp) {
            this.updateHitpoints();
            this.updatePrayer();
            this.updateBars();
        }
    }

    @Provides
    PictureInPictureConfig provideConfig(ConfigManager configManager) {
        return (PictureInPictureConfig)configManager.getConfig(PictureInPictureConfig.class);
    }

    private void updateHitpoints() {
        this.currentHealth = this.client.getBoostedSkillLevel(Skill.HITPOINTS);
        this.maxHealth = this.client.getRealSkillLevel(Skill.HITPOINTS);
        this.healthColor = HEALTH;
        int poisonState = this.client.getVarpValue(102);
        if (poisonState >= 1000000) {
            this.healthColor = VENOMED;
        } else if (poisonState > 0) {
            this.healthColor = POISONED;
        } else if (this.client.getVarpValue(456) > 0) {
            this.healthColor = DISEASE;
        }
    }

    private void updatePrayer() {
        this.currentPrayer = this.client.getBoostedSkillLevel(Skill.PRAYER);
        this.maxPrayer = this.client.getRealSkillLevel(Skill.PRAYER);
    }

    private void startPip(final Image image) {
        final int position = this.config.barPosition().getPosition();
        this.leftSkill = this.config.leftBar().getSkill();
        this.rightSkill = this.config.rightBar().getSkill();
        final int offset = this.getOffset();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!pipUp) {
                    log.debug("Initializing PIP");
                    if (PictureInPicturePlugin.this.config.limitedDimension().toString().equals("Width")) {
                        PictureInPicturePlugin.this.pipWidth = PictureInPicturePlugin.this.config.targetSize().getWidth();
                        PictureInPicturePlugin.this.pipScale = (double)PictureInPicturePlugin.this.pipWidth / (double)image.getWidth(null);
                        PictureInPicturePlugin.this.pipHeight = (int)((double)image.getHeight(null) * PictureInPicturePlugin.this.pipScale);
                    } else {
                        PictureInPicturePlugin.this.pipHeight = PictureInPicturePlugin.this.config.targetSize().getHeight();
                        PictureInPicturePlugin.this.pipScale = (double)PictureInPicturePlugin.this.pipHeight / (double)image.getHeight(null);
                        PictureInPicturePlugin.this.pipWidth = (int)((double)image.getWidth(null) * PictureInPicturePlugin.this.pipScale);
                    }
                    Image img = PictureInPicturePlugin.this.pipScale(image);
                    ImageIcon icon = new ImageIcon(img);
                    PictureInPicturePlugin.this.pipFrame = new JFrame("Picture in Picture");
                    PictureInPicturePlugin.this.pipFrame.setFocusableWindowState(false);
                    PictureInPicturePlugin.this.pipFrame.setType(Window.Type.UTILITY);
                    PictureInPicturePlugin.this.pipFrame.setLayout(new FlowLayout(0, PictureInPicturePlugin.this.config.borderWidth(), PictureInPicturePlugin.this.config.borderWidth()));
                    PictureInPicturePlugin.this.pipFrame.setSize(img.getWidth(null) + offset, img.getHeight(null));
                    PictureInPicturePlugin.this.lbl = new JLabel();
                    PictureInPicturePlugin.this.lbl.setIcon(icon);
                    PictureInPicturePlugin.this.pipFrame.setUndecorated(true);
                    if (PictureInPicturePlugin.this.leftSkill == Skill.HITPOINTS) {
                        PictureInPicturePlugin.this.leftBar = new pipBar(PictureInPicturePlugin.this.maxHealth, PictureInPicturePlugin.this.currentHealth, PictureInPicturePlugin.this.healthColor);
                    } else if (PictureInPicturePlugin.this.leftSkill == Skill.PRAYER) {
                        PictureInPicturePlugin.this.leftBar = new pipBar(PictureInPicturePlugin.this.maxPrayer, PictureInPicturePlugin.this.currentPrayer, PRAYER);
                    }
                    if (PictureInPicturePlugin.this.rightSkill == Skill.HITPOINTS) {
                        PictureInPicturePlugin.this.rightBar = new pipBar(PictureInPicturePlugin.this.maxHealth, PictureInPicturePlugin.this.currentHealth, PictureInPicturePlugin.this.healthColor);
                    } else if (PictureInPicturePlugin.this.rightSkill == Skill.PRAYER) {
                        PictureInPicturePlugin.this.rightBar = new pipBar(PictureInPicturePlugin.this.maxPrayer, PictureInPicturePlugin.this.currentPrayer, PRAYER);
                    }
                    if (position == 0) {
                        if (PictureInPicturePlugin.this.leftSkill != null) {
                            PictureInPicturePlugin.this.pipFrame.add(PictureInPicturePlugin.this.leftBar);
                        }
                        if (PictureInPicturePlugin.this.rightSkill != null) {
                            PictureInPicturePlugin.this.pipFrame.add(PictureInPicturePlugin.this.rightBar);
                        }
                        PictureInPicturePlugin.this.pipFrame.add(PictureInPicturePlugin.this.lbl);
                    } else if (position == 1) {
                        PictureInPicturePlugin.this.pipFrame.add(PictureInPicturePlugin.this.lbl);
                        if (PictureInPicturePlugin.this.leftSkill != null) {
                            PictureInPicturePlugin.this.pipFrame.add(PictureInPicturePlugin.this.leftBar);
                        }
                        if (PictureInPicturePlugin.this.rightSkill != null) {
                            PictureInPicturePlugin.this.pipFrame.add(PictureInPicturePlugin.this.rightBar);
                        }
                    } else {
                        if (PictureInPicturePlugin.this.leftSkill != null) {
                            PictureInPicturePlugin.this.pipFrame.add(PictureInPicturePlugin.this.leftBar);
                        }
                        PictureInPicturePlugin.this.pipFrame.add(PictureInPicturePlugin.this.lbl);
                        if (PictureInPicturePlugin.this.rightSkill != null) {
                            PictureInPicturePlugin.this.pipFrame.add(PictureInPicturePlugin.this.rightBar);
                        }
                    }
                    PictureInPicturePlugin.this.pipFrame.setDefaultCloseOperation(2);
                    PictureInPicturePlugin.this.pipFrame.setAlwaysOnTop(true);
                    MoveMouseListener listener = new MoveMouseListener(PictureInPicturePlugin.this.pipFrame);
                    PictureInPicturePlugin.this.pipFrame.addMouseListener(listener);
                    PictureInPicturePlugin.this.pipFrame.addMouseMotionListener(listener);
                    Rectangle effectiveScreenArea = PictureInPicturePlugin.this.getEffectiveScreenArea();
                    if (PictureInPicturePlugin.this.config.quadrantID().getId() == 1) {
                        PictureInPicturePlugin.this.pipPoint.setLocation(effectiveScreenArea.width - PictureInPicturePlugin.this.pipWidth - PictureInPicturePlugin.this.config.paddingX() - offset, PictureInPicturePlugin.this.config.paddingY());
                    } else if (PictureInPicturePlugin.this.config.quadrantID().getId() == 2) {
                        PictureInPicturePlugin.this.pipPoint.setLocation(PictureInPicturePlugin.this.config.paddingX(), PictureInPicturePlugin.this.config.paddingY());
                    } else if (PictureInPicturePlugin.this.config.quadrantID().getId() == 3) {
                        PictureInPicturePlugin.this.pipPoint.setLocation(PictureInPicturePlugin.this.config.paddingX(), effectiveScreenArea.height - PictureInPicturePlugin.this.pipHeight - PictureInPicturePlugin.this.config.paddingY() - 2 * PictureInPicturePlugin.this.config.borderWidth());
                    } else {
                        PictureInPicturePlugin.this.pipPoint.setLocation(effectiveScreenArea.width - PictureInPicturePlugin.this.pipWidth - PictureInPicturePlugin.this.config.paddingX() - offset, effectiveScreenArea.height - PictureInPicturePlugin.this.pipHeight - PictureInPicturePlugin.this.config.paddingY() - 2 * PictureInPicturePlugin.this.config.borderWidth());
                    }
                    PictureInPicturePlugin.this.pipFrame.setLocation(PictureInPicturePlugin.this.pipPoint);
                    PictureInPicturePlugin.this.pipFrame.pack();
                    PictureInPicturePlugin.this.pipFrame.setVisible(true);
                    pipUp = true;
                    log.debug("PIP initialized");
                }
            }
        });
    }

    private Rectangle getEffectiveScreenArea() {
        GraphicsConfiguration gc = this.clientUi.getGraphicsConfiguration();
        Rectangle bounds = gc.getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        Rectangle effectiveScreenArea = new Rectangle();
        effectiveScreenArea.x = bounds.x + screenInsets.left;
        effectiveScreenArea.y = bounds.y + screenInsets.top;
        effectiveScreenArea.height = bounds.height - screenInsets.top - screenInsets.bottom;
        effectiveScreenArea.width = bounds.width - screenInsets.left - screenInsets.right;
        return effectiveScreenArea;
    }

    private int getOffset() {
        return 2 * this.config.borderWidth() + (this.leftSkill != null ? this.config.borderWidth() + this.config.getBarWidth() : 0) + (this.rightSkill != null ? this.config.borderWidth() + this.config.getBarWidth() : 0);
    }

    private void destroyPip() {
        if (this.pipFrame != null) {
            this.pipFrame.setVisible(false);
            this.pipFrame.dispose();
            this.pipFrame = null;
            pipUp = false;
            log.debug("PIP destroyed");
        }
        for (Frame frame : Frame.getFrames()) {
            if (frame.getTitle() == null || !frame.getTitle().equals("Picture in Picture")) continue;
            frame.setVisible(false);
            frame.dispose();
            frame = null;
            log.debug("PIP cleanup");
        }
    }

    private void initializePip() {
        Consumer<Image> imageCallback = img -> this.executor.submit(() -> this.startPip((Image)img));
        this.drawManager.requestNextFrameListener(imageCallback);
    }

    private void updatePip() {
        Consumer<Image> imageCallback = img -> this.executor.submit(() -> this.updatePip((Image)img));
        this.drawManager.requestNextFrameListener(imageCallback);
    }

    private void updatePip(final Image image) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Image img = PictureInPicturePlugin.this.pipScale(image);
                ImageIcon icon = new ImageIcon(img);
                icon.getImage().flush();
                PictureInPicturePlugin.this.lbl.setIcon(icon);
            }
        });
    }

    private void updateBars() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PictureInPicturePlugin.this.leftSkill == Skill.HITPOINTS) {
                    PictureInPicturePlugin.this.leftBar.updateBar(PictureInPicturePlugin.this.maxHealth, PictureInPicturePlugin.this.currentHealth, PictureInPicturePlugin.this.healthColor);
                } else if (PictureInPicturePlugin.this.leftSkill == Skill.PRAYER) {
                    PictureInPicturePlugin.this.leftBar.updateBar(PictureInPicturePlugin.this.maxPrayer, PictureInPicturePlugin.this.currentPrayer, PRAYER);
                }
                if (PictureInPicturePlugin.this.rightSkill == Skill.HITPOINTS) {
                    PictureInPicturePlugin.this.rightBar.updateBar(PictureInPicturePlugin.this.maxHealth, PictureInPicturePlugin.this.currentHealth, PictureInPicturePlugin.this.healthColor);
                } else if (PictureInPicturePlugin.this.rightSkill == Skill.PRAYER) {
                    PictureInPicturePlugin.this.rightBar.updateBar(PictureInPicturePlugin.this.maxPrayer, PictureInPicturePlugin.this.currentPrayer, PRAYER);
                }
            }
        });
    }

    private Image pipScale(Image originalImage) {
        int samples = this.config.renderQuality().getRedraw();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, this.config.renderQuality().getQuality()));
        hints.add(new RenderingHints(RenderingHints.KEY_INTERPOLATION, this.config.renderQuality().getHint()));
        if (this.pipScale > 1.0) {
            return originalImage;
        }
        BufferedImage returnImage = (BufferedImage)originalImage;
        int w = originalImage.getWidth(null);
        int h = originalImage.getHeight(null);
        int incW = (w - this.pipWidth) / samples;
        int incH = (h - this.pipHeight) / samples;
        for (int i = 1; i <= samples; ++i) {
            if (i == samples) {
                w = this.pipWidth;
                h = this.pipHeight;
            } else {
                w -= incW;
                h -= incH;
            }
            BufferedImage tempImage = new BufferedImage(w, h, 1);
            Graphics2D g2 = tempImage.createGraphics();
            g2.setRenderingHints(hints);
            g2.drawImage(returnImage, 0, 0, w, h, null);
            g2.dispose();
            returnImage = tempImage;
        }
        return returnImage;
    }

    private class pipBar
    extends JPanel {
        int maxLevel;
        int currentLevel;
        Color[] colors;

        private pipBar(int maxLevel, int currentLevel, Color[] colors) {
            this.maxLevel = maxLevel;
            this.currentLevel = currentLevel;
            this.colors = colors;
        }

        private void updateBar(int maxLevel, int currentLevel, Color[] colors) {
            this.maxLevel = maxLevel;
            this.currentLevel = currentLevel;
            this.colors = colors;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(this.colors[0]);
            g.fillRect(0, 0, PictureInPicturePlugin.this.config.getBarWidth(), PictureInPicturePlugin.this.pipHeight);
            int bgHeight = (int)((float)((this.maxLevel - this.currentLevel) * PictureInPicturePlugin.this.pipHeight) / (float)this.maxLevel);
            g.setColor(this.colors[1]);
            g.fillRect(0, 0, PictureInPicturePlugin.this.config.getBarWidth(), bgHeight);
            if (PictureInPicturePlugin.this.config.barText() && PictureInPicturePlugin.this.config.getBarWidth() >= 15) {
                g.setFont(FontManager.getRunescapeSmallFont());
                String text = String.valueOf(this.currentLevel);
                int y = 20;
                int x = PictureInPicturePlugin.this.config.getBarWidth() / 2 - g.getFontMetrics().stringWidth(text) / 2;
                g.setColor(Color.BLACK);
                g.drawString(text, x, y + 1);
                g.drawString(text, x, y - 1);
                g.drawString(text, x + 1, y);
                g.drawString(text, x - 1, y);
                g.setColor(Color.WHITE);
                g.drawString(text, x, y);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(PictureInPicturePlugin.this.config.getBarWidth(), PictureInPicturePlugin.this.pipHeight);
        }
    }

    class MoveMouseListener
    implements MouseListener,
    MouseMotionListener {
        JFrame target;
        Point startDrag;
        Point startLocation;

        public MoveMouseListener(JFrame target) {
            this.target = target;
        }

        public JFrame getFrame(Container target) {
            if (target instanceof JFrame) {
                return (JFrame)target;
            }
            return this.getFrame(target.getParent());
        }

        Point getScreenLocation(MouseEvent e) {
            Point cursor = e.getPoint();
            Point target_location = this.target.getLocationOnScreen();
            return new Point((int)(target_location.getX() + cursor.getX()), (int)(target_location.getY() + cursor.getY()));
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isShiftDown()) {
                if (PictureInPicturePlugin.this.config.shiftClickAction() == PictureInPictureConfig.clickAction.DRAG_MODE) {
                    this.startDrag = this.getScreenLocation(e);
                    this.startLocation = this.target.getLocation();
                } else if (PictureInPicturePlugin.this.config.shiftClickAction() == PictureInPictureConfig.clickAction.REQUEST_FOCUS) {
                    PictureInPicturePlugin.this.destroyPip();
                    PictureInPicturePlugin.this.clientUi.requestFocus();
                } else if (PictureInPicturePlugin.this.config.shiftClickAction() == PictureInPictureConfig.clickAction.FORCE_FOCUS) {
                    PictureInPicturePlugin.this.destroyPip();
                    PictureInPicturePlugin.this.clientUi.forceFocus();
                }
            } else if (PictureInPicturePlugin.this.config.clickAction() == PictureInPictureConfig.clickAction.DRAG_MODE) {
                this.startDrag = this.getScreenLocation(e);
                this.startLocation = this.target.getLocation();
            } else if (PictureInPicturePlugin.this.config.clickAction() == PictureInPictureConfig.clickAction.REQUEST_FOCUS) {
                PictureInPicturePlugin.this.destroyPip();
                PictureInPicturePlugin.this.clientUi.requestFocus();
            } else if (PictureInPicturePlugin.this.config.clickAction() == PictureInPictureConfig.clickAction.FORCE_FOCUS) {
                PictureInPicturePlugin.this.destroyPip();
                PictureInPicturePlugin.this.clientUi.forceFocus();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int newY;
            int newX;
            int offset = PictureInPicturePlugin.this.getOffset();
            Rectangle effectiveScreenArea = PictureInPicturePlugin.this.getEffectiveScreenArea();
            if (PictureInPicturePlugin.this.config.quadrantID().getId() == 1) {
                newX = effectiveScreenArea.width - PictureInPicturePlugin.this.pipWidth - PictureInPicturePlugin.this.pipPoint.x - offset;
                newY = PictureInPicturePlugin.this.pipPoint.y;
            } else if (PictureInPicturePlugin.this.config.quadrantID().getId() == 2) {
                newX = PictureInPicturePlugin.this.pipPoint.x;
                newY = PictureInPicturePlugin.this.pipPoint.y;
            } else if (PictureInPicturePlugin.this.config.quadrantID().getId() == 3) {
                newX = PictureInPicturePlugin.this.pipPoint.x;
                newY = effectiveScreenArea.height - PictureInPicturePlugin.this.pipHeight - PictureInPicturePlugin.this.pipPoint.y - 2 * PictureInPicturePlugin.this.config.borderWidth();
            } else {
                newX = effectiveScreenArea.width - PictureInPicturePlugin.this.pipWidth - PictureInPicturePlugin.this.pipPoint.x - offset;
                newY = effectiveScreenArea.height - PictureInPicturePlugin.this.pipHeight - PictureInPicturePlugin.this.pipPoint.y - 2 * PictureInPicturePlugin.this.config.borderWidth();
            }
            if (PictureInPicturePlugin.this.config.preserveShiftDrag()) {
                PictureInPicturePlugin.this.configManager.setConfiguration("pip", "paddingX", (Object)newX);
                PictureInPicturePlugin.this.configManager.setConfiguration("pip", "paddingY", (Object)newY);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point current = this.getScreenLocation(e);
            Point offset = new Point((int)current.getX() - (int)this.startDrag.getX(), (int)current.getY() - (int)this.startDrag.getY());
            PictureInPicturePlugin.this.pipPoint = new Point((int)(this.startLocation.getX() + offset.getX()), (int)(this.startLocation.getY() + offset.getY()));
            this.target.setLocation(PictureInPicturePlugin.this.pipPoint);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

