/*
 * Decompiled with CFR 0.152.
 */
package fking.work.chatlogger;

import com.google.gson.Gson;
import fking.work.chatlogger.ChatEntry;
import fking.work.chatlogger.ChatLoggerConfig;
import fking.work.chatlogger.ZonedDateTimeAdapter;
import java.io.IOException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteSubmitter {
    private static final Logger log = LoggerFactory.getLogger(RemoteSubmitter.class);
    private static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json");
    private static final int MAX_ENTRIES_PER_TICK = 30;
    private static final int TICK_INTERVAL = 5;
    private static final CircuitBreaker<Object> BREAKER = ((CircuitBreaker)new CircuitBreaker().handle((Class<? extends Throwable>)((Class<Throwable>)IOException.class))).withDelay(Duration.ofMinutes(5L)).withFailureThreshold(3, Duration.ofSeconds(30L)).onHalfOpen(RemoteSubmitter::onHalfOpen);
    private final ConcurrentLinkedDeque<ChatEntry> queuedEntries = new ConcurrentLinkedDeque();
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private final ChatLoggerConfig config;
    private final OkHttpClient okHttpClient;
    private final Gson gson;

    private RemoteSubmitter(ChatLoggerConfig config, OkHttpClient okHttpClient, Gson gson) {
        this.config = config;
        this.okHttpClient = okHttpClient;
        this.gson = gson.newBuilder().registerTypeAdapter(ZonedDateTime.class, (Object)new ZonedDateTimeAdapter()).create();
    }

    public static RemoteSubmitter create(ChatLoggerConfig config, OkHttpClient okHttpClient, Gson gson) {
        return new RemoteSubmitter(config, okHttpClient, gson);
    }

    private static void onHalfOpen() {
        log.info("Checking if remote host is answering properly again (HALF_OPEN)");
    }

    public void initialize() {
        this.executorService.scheduleAtFixedRate(this::processQueue, 5L, 5L, TimeUnit.SECONDS);
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    public void queue(ChatEntry entry) {
        this.queuedEntries.add(entry);
    }

    private void processQueue() {
        block3: {
            if (this.queuedEntries.isEmpty()) {
                return;
            }
            RequestBody payload = this.buildPayload();
            try {
                Failsafe.with((Policy[])new CircuitBreaker[]{BREAKER}).run(() -> {
                    String authorization = this.config.remoteEndpointAuthorization();
                    if (authorization == null || authorization.trim().isEmpty()) {
                        authorization = "none";
                    }
                    Request request = new Request.Builder().url(this.config.remoteEndpoint()).addHeader("Authorization", authorization).post(payload).build();
                    try (Response response = this.okHttpClient.newCall(request).execute();){
                        if (!response.isSuccessful()) {
                            log.warn("Remote endpoint returned non successful response, responseCode={}", (Object)response.code());
                        }
                    }
                });
            }
            catch (Exception e) {
                if (BREAKER.isOpen()) break block3;
                log.warn("Failed to submit chat entries: {}", (Object)e.getMessage());
            }
        }
    }

    private RequestBody buildPayload() {
        ArrayList<ChatEntry> entries = new ArrayList<ChatEntry>();
        for (int count = 0; !this.queuedEntries.isEmpty() && count < 30; ++count) {
            entries.add(this.queuedEntries.poll());
        }
        return RequestBody.create((MediaType)APPLICATION_JSON, (String)this.gson.toJson(entries));
    }
}

