/*
 * Decompiled with CFR 0.152.
 */
package fking.work.chatlogger;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Provides;
import fking.work.chatlogger.ChatEntry;
import fking.work.chatlogger.ChatLoggerConfig;
import fking.work.chatlogger.CrossWorldMessages;
import fking.work.chatlogger.RemoteSubmitter;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.FriendsChatManager;
import net.runelite.api.FriendsChatMember;
import net.runelite.api.clan.ClanChannel;
import net.runelite.api.clan.ClanChannelMember;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Chat Logger", description="Logs chat messages to a file")
public class ChatLoggerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ChatLoggerPlugin.class);
    private static final String BASE_DIRECTORY = System.getProperty("user.home") + "/.runelite/chatlogs/";
    private static final int CHANNEL_UNRANKED = -2;
    @Inject
    private ChatLoggerConfig config;
    @Inject
    private Client client;
    @Inject
    private OkHttpClient httpClient;
    @Inject
    private Gson gson;
    private RemoteSubmitter remoteSubmitter;
    private ch.qos.logback.classic.Logger publicChatLogger;
    private ch.qos.logback.classic.Logger privateChatLogger;
    private ch.qos.logback.classic.Logger friendsChatLogger;
    private ch.qos.logback.classic.Logger clanChatLogger;

    @Provides
    ChatLoggerConfig provideConfig(ConfigManager configManager) {
        return (ChatLoggerConfig)configManager.getConfig(ChatLoggerConfig.class);
    }

    protected void startUp() {
        this.publicChatLogger = this.setupLogger("PublicChatLogger", "public");
        this.privateChatLogger = this.setupLogger("PrivateChatLogger", "private");
        this.friendsChatLogger = this.setupLogger("FriendsChatLogger", "friends");
        this.clanChatLogger = this.setupLogger("ClanChatLogger", "clan");
        this.startRemoteSubmitter();
    }

    protected void shutDown() {
        this.shutdownRemoteSubmitter();
    }

    private void startRemoteSubmitter() {
        if (this.config.remoteSubmitLogFriendsChat() || this.config.remoteSubmitLogClanChat()) {
            if (this.remoteSubmitter != null) {
                log.debug("Shutting down previous remoteSubmitter...");
                this.shutdownRemoteSubmitter();
            }
            log.debug("Starting a new remoteSubmitter...");
            this.remoteSubmitter = RemoteSubmitter.create(this.config, this.httpClient, this.gson);
            this.remoteSubmitter.initialize();
        }
    }

    private void shutdownRemoteSubmitter() {
        if (this.remoteSubmitter != null) {
            this.remoteSubmitter.shutdown();
            this.remoteSubmitter = null;
        }
    }

    private int friendsChatMemberRank(String name) {
        FriendsChatManager friendsChatManager = this.client.getFriendsChatManager();
        if (friendsChatManager != null) {
            FriendsChatMember member = (FriendsChatMember)friendsChatManager.findByName(Text.removeTags((String)name));
            return member != null ? member.getRank().getValue() : -2;
        }
        return -2;
    }

    private int clanChannelMemberRank(String name, String clanName) {
        ClanChannelMember member;
        String cleanName = Text.removeTags((String)name);
        ClanChannel clanChannel = this.client.getClanChannel();
        if (clanChannel != null && (member = clanChannel.findMember(cleanName)) != null && clanChannel.getName().equals(clanName)) {
            return member.getRank().ordinal();
        }
        clanChannel = this.client.getGuestClanChannel();
        if (clanChannel != null && (member = clanChannel.findMember(cleanName)) != null && clanChannel.getName().equals(clanName)) {
            return member.getRank().ordinal();
        }
        return -2;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!"chatlogger".equals(event.getGroup())) {
            return;
        }
        this.startRemoteSubmitter();
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        switch (event.getType()) {
            case FRIENDSCHAT: {
                if (this.config.logFriendsChat()) {
                    this.friendsChatLogger.info("[{}] {}: {}", new Object[]{event.getSender(), event.getName(), event.getMessage()});
                }
                if (!this.config.remoteSubmitLogFriendsChat() || this.remoteSubmitter == null) break;
                FriendsChatManager friendsChatManager = this.client.getFriendsChatManager();
                if (friendsChatManager == null) {
                    return;
                }
                String owner = friendsChatManager.getOwner();
                this.submitToRemote(owner, event, this.friendsChatMemberRank(event.getName()));
                break;
            }
            case CLAN_CHAT: 
            case CLAN_GUEST_CHAT: 
            case CLAN_MESSAGE: {
                ClanChannel clanChannel;
                if (this.config.logClanChat()) {
                    if (event.getType() == ChatMessageType.CLAN_MESSAGE) {
                        this.clanChatLogger.info("{}", (Object)event.getMessage());
                    } else {
                        this.clanChatLogger.info("{}: {}", (Object)event.getName(), (Object)event.getMessage());
                    }
                }
                if (!this.config.remoteSubmitLogClanChat() || this.remoteSubmitter == null) break;
                ClanChannel clanChannel2 = clanChannel = event.getType() == ChatMessageType.CLAN_CHAT || event.getType() == ChatMessageType.CLAN_MESSAGE ? this.client.getClanChannel() : this.client.getGuestClanChannel();
                if (clanChannel == null) {
                    return;
                }
                String chatName = clanChannel.getName();
                this.submitToRemote(chatName, event, this.clanChannelMemberRank(event.getName(), chatName));
                break;
            }
            case PRIVATECHAT: 
            case MODPRIVATECHAT: 
            case PRIVATECHATOUT: {
                if (!this.config.logPrivateChat()) break;
                String predicate = event.getType() == ChatMessageType.PRIVATECHATOUT ? "To" : "From";
                this.privateChatLogger.info("{} {}: {}", new Object[]{predicate, event.getName(), event.getMessage()});
                break;
            }
            case MODCHAT: 
            case PUBLICCHAT: {
                if (!this.config.logPublicChat()) break;
                this.publicChatLogger.info("{}: {}", (Object)event.getName(), (Object)event.getMessage());
            }
        }
    }

    private void submitToRemote(String channelName, ChatMessage event, int rank) {
        long messageId = CrossWorldMessages.latestId(this.client);
        this.remoteSubmitter.queue(ChatEntry.from(messageId, ChatEntry.ChatType.CLAN, channelName, rank, event));
    }

    private ch.qos.logback.classic.Logger setupLogger(String loggerName, String subFolder) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)context);
        encoder.setPattern("%d{HH:mm:ss} %msg%n");
        encoder.start();
        String directory = BASE_DIRECTORY + subFolder + "/";
        RollingFileAppender appender = new RollingFileAppender();
        appender.setFile(directory + "latest.log");
        appender.setAppend(true);
        appender.setEncoder((Encoder)encoder);
        appender.setContext((Context)context);
        TimeBasedRollingPolicy logFilePolicy = new TimeBasedRollingPolicy();
        logFilePolicy.setContext((Context)context);
        logFilePolicy.setParent((FileAppender)appender);
        logFilePolicy.setFileNamePattern(directory + "chatlog_%d{yyyy-MM-dd}.log");
        logFilePolicy.setMaxHistory(30);
        logFilePolicy.start();
        appender.setRollingPolicy((RollingPolicy)logFilePolicy);
        appender.start();
        ch.qos.logback.classic.Logger logger = context.getLogger(loggerName);
        logger.detachAndStopAllAppenders();
        logger.setAdditive(false);
        logger.setLevel(Level.INFO);
        logger.addAppender((Appender)appender);
        return logger;
    }
}

