/*
 * Decompiled with CFR 0.152.
 */
package fking.work.chatlogger;

import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;

@ConfigGroup(value="chatlogger")
public interface ChatLoggerConfig
extends Config {
    public static final String GROUP_NAME = "chatlogger";
    @ConfigSection(name="Remote Submission", description="Settings for remote submission of chat messages", position=0, closedByDefault=true)
    public static final String sectionRemote = "remote";

    @ConfigItem(keyName="public", name="Public Chat", description="Enables logging of the public chat")
    default public boolean logPublicChat() {
        return false;
    }

    @ConfigItem(keyName="private", name="Private Chat", description="Enables logging of the private chat")
    default public boolean logPrivateChat() {
        return false;
    }

    @ConfigItem(keyName="friends", name="Friends Chat (Channel Chat)", description="Enables logging of the friends chat")
    default public boolean logFriendsChat() {
        return true;
    }

    @ConfigItem(keyName="remotelogfriends", name="Remote Friends Chat (Channel Chat)", description="Enables remote submission of the friends chat", section="remote")
    default public boolean remoteSubmitLogFriendsChat() {
        return false;
    }

    @ConfigItem(keyName="clan", name="Clan Chat", description="Enables logging of the clan chat")
    default public boolean logClanChat() {
        return true;
    }

    @ConfigItem(keyName="remotelogclan", name="Remote Clan Chat", description="Enables remote submission of the clan chat", section="remote")
    default public boolean remoteSubmitLogClanChat() {
        return false;
    }

    @ConfigItem(keyName="remoteendpoint", name="Endpoint", description="The endpoint that messages will be submitted to", section="remote")
    default public String remoteEndpoint() {
        return null;
    }

    @ConfigItem(keyName="remoteauthorization", name="Authorization", description="The Authorization header value", section="remote")
    default public String remoteEndpointAuthorization() {
        return null;
    }
}

