/*
 * Decompiled with CFR 0.152.
 */
package fking.work.chatlogger;

import java.time.Clock;
import java.time.ZonedDateTime;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.util.Text;

public class ChatEntry {
    private final ZonedDateTime timestamp;
    private final long id;
    private final ChatType chatType;
    private final String chatName;
    private final String sender;
    private final int rank;
    private final String message;

    private ChatEntry(long id, ChatType chatType, String chatName, String sender, int rank, String message) {
        this.id = id;
        this.chatType = chatType;
        this.timestamp = ZonedDateTime.now(Clock.systemUTC());
        this.chatName = chatName;
        this.sender = sender;
        this.rank = rank;
        this.message = message;
    }

    public static ChatEntry from(long messageId, ChatType chatType, String chatName, int rank, ChatMessage chatMessage) {
        String sender = chatMessage.getName().isEmpty() ? chatName : Text.removeFormattingTags((String)chatMessage.getName());
        return new ChatEntry(messageId, chatType, Text.standardize((String)chatName), sender, rank, chatMessage.getMessage());
    }

    public String toString() {
        return "ChatEntry(timestamp=" + this.timestamp + ", id=" + this.id + ", chatType=" + this.chatType + ", chatName=" + this.chatName + ", sender=" + this.sender + ", rank=" + this.rank + ", message=" + this.message + ")";
    }

    public static enum ChatType {
        FRIENDS,
        CLAN;

    }
}

