/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.jargenerator;

import com.google.inject.Provides;
import com.janboerman.jargenerator.Charges;
import com.janboerman.jargenerator.JarGeneratorConfig;
import com.janboerman.jargenerator.JarGeneratorLingo;
import com.janboerman.jargenerator.JarGeneratorOverlay;
import com.janboerman.jargenerator.Unknown;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Jar Generator", description="Overlays impling jar generator charges", tags={"impling", "butterfly", "jar", "generator", "charge"})
public class JarGeneratorPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(JarGeneratorPlugin.class);
    static final int JAR_GENERATOR_ITEM_ID = 11258;
    private Charges currentCharges = Charges.unknown();
    private JarGeneratorOverlay jarGeneratorOverlay;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private JarGeneratorConfig config;
    private int lastCheckTick = -1;

    @Provides
    JarGeneratorConfig getConfig(ConfigManager configManager) {
        return (JarGeneratorConfig)configManager.getConfig(JarGeneratorConfig.class);
    }

    protected void startUp() {
        log.info("Jar Generator started!");
        this.setCharges(Charges.probably(this.config.charges()));
        this.jarGeneratorOverlay = new JarGeneratorOverlay(this, this.config);
        this.overlayManager.add((Overlay)this.jarGeneratorOverlay);
    }

    protected void shutDown() {
        log.info("Jar Generator stopped!");
        this.overlayManager.remove((Overlay)this.jarGeneratorOverlay);
        this.jarGeneratorOverlay = null;
        this.setCharges(Charges.probably(this.getCharges().getAmount()));
        Charges.clearCache();
    }

    public Charges getCharges() {
        return this.currentCharges;
    }

    public void setCharges(Charges charges) {
        log.debug("Set charges to " + charges);
        this.currentCharges = charges;
        if (!(charges instanceof Unknown)) {
            this.config.charges(charges.getAmount());
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String text = event.getMessage();
        Charges charges = JarGeneratorLingo.interpret(text);
        if (charges.isKnown()) {
            this.setCharges(charges);
        }
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        int currentTick;
        int yesOption;
        if ("destroyOnOpKey".equals(event.getEventName()) && (yesOption = this.client.getIntStack()[this.client.getIntStackSize() - 1]) == 1 && this.lastCheckTick != (currentTick = this.client.getTickCount())) {
            this.lastCheckTick = currentTick;
            Widget widgetDestroyItemName = this.client.getWidget(WidgetInfo.DESTROY_ITEM_NAME);
            if (widgetDestroyItemName != null && widgetDestroyItemName.getText().equals("Jar generator")) {
                this.setCharges(Charges.empty());
            }
        }
    }
}

