/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.jargenerator;

import com.janboerman.jargenerator.Charges;
import com.janboerman.jargenerator.JarGeneratorConfig;
import com.janboerman.jargenerator.JarGeneratorPlugin;
import com.janboerman.jargenerator.Unknown;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.ui.overlay.components.TextComponent;

public class JarGeneratorOverlay
extends WidgetItemOverlay {
    private final JarGeneratorPlugin plugin;
    private final JarGeneratorConfig config;

    public JarGeneratorOverlay(JarGeneratorPlugin plugin, JarGeneratorConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.showOnInventory();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        if (itemId == 11258) {
            String text;
            Color colour;
            Rectangle bounds = itemWidget.getCanvasBounds();
            TextComponent textComponent = new TextComponent();
            textComponent.setPosition(new Point(bounds.x - 1, bounds.y + 8));
            Charges charges = this.plugin.getCharges();
            if (charges instanceof Unknown) {
                colour = this.config.unknownChargesColour();
                text = "?";
            } else {
                colour = charges.isKnown() ? this.config.knownChargesColour() : this.config.unknownChargesColour();
                text = String.valueOf(charges.getAmount());
            }
            textComponent.setColor(colour);
            textComponent.setText(text);
            textComponent.render(graphics);
        }
    }
}

