/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.jargenerator;

import com.janboerman.jargenerator.BestGuess;
import com.janboerman.jargenerator.ExactlyKnown;
import com.janboerman.jargenerator.Unknown;
import java.util.Arrays;

public abstract class Charges {
    private static final int MAX_CHARGES = 100;
    private static final Charges[] STATES = new Charges[101];

    static void clearCache() {
        Arrays.fill(STATES, null);
    }

    public static Charges unknown() {
        return Unknown.INSTANCE;
    }

    public static Charges empty() {
        return Charges.known(0);
    }

    public static Charges full() {
        return Charges.known(100);
    }

    public static Charges probably(int charges) {
        return new BestGuess(charges);
    }

    public static Charges known(int charges) {
        if (0 <= charges && charges <= 100) {
            Charges chargeState = STATES[charges];
            if (chargeState == null) {
                Charges.STATES[charges] = chargeState = new ExactlyKnown(charges);
            }
            return chargeState;
        }
        return new ExactlyKnown(charges);
    }

    public abstract boolean isKnown();

    public abstract int getAmount();
}

